'File: TEMPLATE.MCR
'Sample / template QuickRef Project Assistant macro file

'Use macro files to automaticaly insert a batch of typical items into a
'project's set of records.

'The macro file format is simple. First, specify the mode (TIME / MONEY) for
'the items to follow. Use EXACTLY one of these formats to to specify mode:

'          %time_mode%
'          %money_mode%

'Next, each line item consists of a set of two lines where the first of the
'set is the item's note, and the second is the amount.

'Macro format rules are as follows:

'     plain ASCII text only
'     blank lines, and lines starting with ' are ignored
'     notes will be truncated at 40 characters
'     filename must end in the extension .MCR
'     "STANDARD.MCR" is hardwired into the program as the default name
'     macros must be stored in the main QuickRef directory (with QR.EXE)
'     mode-switch lines are single lines %time_mode% or %money_mode% only
'     item lines must be in sets of two: note, then amount

'You may create as many macro files as you wish, and they may contain as many
'line items and mode changes as you wish. If you are only going to use one
'macro, or if you use one a lot more often than others, name it "STANDARD.MCR"
'to avoid having to type a filename each time.

'This template file should have been set to "read-only" during the
'installation process. When you select MAKE A NEW MACRO from the macro menu,
'your text editor will start and load this file. Immediately use your editor's
'"save as" function to save the template as a new .MCR file, and then start
'adding your own lines below. (Retain these instructions in the file for
'future reference). The remainder of this file is a "real" sample macro which
'changes mode twice, inserts six sample line items, and contains comments.

'************************** start "real" macro *******************************

'go into time mode...

%time_mode%

'insert a few "to-do" items - note that second lines (amounts) are zero...

read the QuickRef manual
0

learn how to use the macro utility
0

register QuickRef
0

'go into money mode...

%money_mode%

'note that the second lines represent currency figures

register QuickRef
35

shipping and handling
2.5

'money mode can have "to-do" reminders also...

try out READ editor (from WellsCom)
0


'************************** end "real" macro ********************************
