Title EGATOOL2           ; EGATOOL2.ASM -- EGA/VGA Icon Drawing
                         ; C Style Calling method for routines
                         ; All routines use a near call model
;==================================================================
;================CODE SOURCE BY PEDER JUNGCK=======================
;================      COPYRIGHT 1991       =======================
;==================================================================

DATA  segment byte public 'DATA'
DATA  ends

_TEXT  segment byte public 'CODE'
      assume     cs:_TEXT, ds:DATA, es:nothing;

Public _Video_Mode             ;(int Mode) 
Public _Set_Pixel              ;(int x,int y,int Color)
Public _Display_Icon           ;(int x,int y,void far *Data);
Public _Copy_Icon              ;(int OrigX, int OrigY, int X, int Y);

BytesPerLine  dw  40           ; screen width in bytes (320x200 Mode)
VOffset       equ 0a000h       ; video RAM offset

; =================================================================

; void Video_Mode(int Mode);
vm_mode equ [bp+4]             ; parameter passing new video mode
_Video_Mode proc near
  push bp                      ; save base pointer
  mov  bp,sp                   ; put sp in bp, to find parameters on stack
  mov  ax,vm_mode
  xor  ah,ah                   ; set video mode ( ah=0 )
  int  10h                     ; call video BIOS
  pop  bp                      ; restore old base pointer
  ret                          ; restore old stack conditions
_Video_Mode endp

; ==============================================================

; Set_Pixel(int x, int y, int Color);
ps_xpos equ [bp+4]
ps_ypos equ [bp+6]
Color   equ [bp+8]
_Set_Pixel proc near
       push   bp               ; save the base pointer
       mov    bp,sp            ; copy of the stack pointer used for params.
       push   ds               ; save the data segment
       mov    dx,VOffset       ; get the video ram address
       mov    ds,dx            ; set data segment to ega

       mov    ax,ps_ypos       ; get the y coordinate
       mul    BytesPerLine     ; get the offset to line y

       mov    bx,ps_xpos       ; get the x coordinate
       shr    bx,1
       shr    bx,1
       shr    bx,1             ; get the byte pixel is within
       add    bx,ax            ; bx := BytesPerLine*y+(x/8) 
                               ; we now have x,y memory offset 
       mov    cx,ps_xpos       ; generate a mask for the one pixel in byte
       and    cl,7h
       xor    cl,7h
       mov    ch,1
       shl    ch,cl            ; ch := 1 >> (7-(x mod 8))
; set write mode 2
       mov    dx,3ceh
       mov    al,5
       out    dx,al            ; select mode (register 5)
       mov    dx,3cfh
       mov    al,2
       out    dx,al            ; select write mode 2
; set up mask
       mov    dx,3ceh
       mov    al,8
       out    dx,al            ; select mask (register 8)
       mov    dx,3cfh
       mov    al,ch
       out    dx,al            ; set mask
; color dot
       mov    al,[bx]          ; read from card
       mov    ax,Color
       mov    [bx],al          ; write color to dot
; restore default mode
       mov    dx,3ceh
       mov    al,5
       out    dx,al            ; select mode (register 5)
       mov    dx,3cfh
       mov    al,0
       out    dx,al            ; set write mode back to 0
       mov    dx,3ceh
       mov    al,8
       out    dx,al            ; select mask (register 8)
       mov    dx,3cfh
       mov    al,0ffh
       out    dx,al            ; set default mask
       pop    ds               ; restore data segment
       pop    bp               ; restore base pointer
       ret                     ; return from function
_Set_Pixel endp

; ==============================================================


; _Diaplay_Icon(int x, int y, void far *Data);
pp_xpos    equ [bp+4]
pp_ypos    equ [bp+6]
pp_pointer equ [bp+8]
_Display_Icon proc near
        push       bp
        mov        bp,sp
        push       ds
	push 	   di
        push       si

        mov        di,BytesPerLine          ; RAM Line length currently set

        lds        si,pp_pointer            ; ds:[si]=start of icon
        mov        dx,VOffset               ; EGA address
        mov        es,dx                    ; segment ega

        mov        ax,pp_ypos               ; get vertical line
        mul        di

        mov        bx,pp_xpos               ; horizontal byte
        add        bx,ax                    ; (y*40) + bx <- the horiz byte
                                            ; normally in wm0

        dec        di                       ; Next line offset variable
                                            ; Adding at position 2 in icon
                                            ; to end up at position 1 in next
                                            ; line of the icon in video RAM

        mov        dx,03c4h                 ; select the map register.
        mov        al,2
        out        dx,al

        mov        cx,16                    ; Number of lines per icon
DIStart:                                    ; column 1
        mov        dx,3ceh
        lodsb                               ; get the mask.
        mov        ah,8
        xchg       ah,al
        out        dx,ax

        mov        dx,03c5h                 ; load the map register data address.

        mov        al,1                     ; plane 1.
        out        dx,al
        lodsb
        xchg       es:[bx],al

        mov        al,2                        ; plane 2.
        out        dx,al
        lodsb
        xchg       es:[bx],al

        mov        al,4                        ; plane 4.
        out        dx,al
        lodsb
        xchg       es:[bx],al

        mov        al,8                        ; plane 8.
        out        dx,al
        lodsb
        xchg       es:[bx],al

        inc        bx                ; column 2

        mov        dx,3ceh
        lodsb                                ; get the mask.
        mov        ah,8
        xchg       ah,al
        out        dx,ax

        mov        dx,03c5h                ; load the map register data address.

        mov        al,1                        ; plane 1.
        out        dx,al
        lodsb
        xchg       es:[bx],al

        mov        al,2                        ; plane 2.
        out        dx,al
        lodsb
        xchg       es:[bx],al

        mov        al,4                        ; plane 4.
        out        dx,al
        lodsb
        xchg       es:[bx],al

        mov        al,8                        ; plane 8.
        out        dx,al
        lodsb
        xchg       es:[bx],al

        add        bx,di                   ; Start of next line of icon
                                           ; in video RAM
        
        loop       DIStart                 ; do next row

        mov        al,0fh                        ;reset the map mask.
        out        dx,al

        mov        dx,3ceh
        mov        ax,0ff08h                ; reset the bit mask to all ones.
        out        dx,ax

	pop	   si
        pop	   di
        pop        ds
        pop        bp
        ret        
_Display_Icon endp

;********************************************************************



;********************************************************************

; Copy_Icon(int OrigX, int OrigY, int X, int Y);
CIOx   equ [bp+ 4]
CIOy   equ [bp+ 6]
CIx    equ [bp+ 8]
CIy    equ [bp+10]
_Copy_Icon proc near
        push       bp
        mov        bp,sp
        push       si
        push       di
        push       ds

        mov        dx,VOffset               ; EGA address
        mov        es,dx                    ; segment ega
        mov        ds,dx                    ; segment for ega


                                            ; Get the origination icon addr
        mov        ax,CIOy                  ; get vertical line
        mul        BytesPerLine

        mov        si,CIOx                  ; horizontal byte
        add        si,ax                    ; (y*40) + bx <- the horiz byte


        mov        ax,CIy                   ; get vertical line
        mul        BytesPerLine

        mov        di,CIx                   ; horizontal byte
        add        di,ax                    ; (y*40) + bx <- the horiz byte
                                            ; normally in wm0

        mov        dx,03c4h
        mov        al,02
        out        dx,al

        mov        dx,03c5h                 ; load the map register data address.
                                            
        mov        al,0fh                   ; enable all planes 
        out        dx,al

        mov        dx,3ceh
        mov        al,5
        out        dx,al

        inc        dx
        mov        al,1
        out        dx,al                    ; select write mode 1

        mov        ax,BytesPerLine          ; Offset to next line
        dec        ax                       ; Subtract icon width
        dec        ax

        mov        cx,16
CIStart:movsb     ; reads ds:[si] then writes es:[di] 
        movsb     ; reads icon place in memory then writes to dest

        add        si,ax                    ; Get to start of next line of
        add        di,ax                    ; the orig and dest addresses

        loop       CIStart


        mov        dx,3cfh                  ; write mode register already
        mov        al,0                     ; selected, just output value now
        out        dx,al                    ; restore write mode 0 

        pop        ds
        pop        di
        pop        si
        pop        bp
        ret        
_Copy_Icon endp

_TEXT ends
end


