	title	termination routines
	include	asm.inc

	public	enable_exit_intercept
	public	disable_exit_intercept

XPB	segment word public 'DATA'	; full exit routines
XPB	ends
XP	segment word public 'DATA'
	dw	disable_exit_intercept	; on full exit, disable exit
XP	ends				;  intercept
XPE	segment word public 'DATA'
XPE	ends

XCB	segment word public 'DATA'	; quick exit routines
	extrn	xcbegin:word
XCB	ends
XC	segment word public 'DATA'
XC	ends
XCE	segment word public 'DATA'
	extrn	xcend:word
XCE	ends

DGROUP	group	XPB,XP,XPE,XCB,XC,XCE

	.data
	extrn	psp:word

	.data?
	extrn	top_of_stack:word


terminate_offset	dw	?	; original terminate address from
terminate_segment	dw	?	;  PSP:000A


	.code
	extn	initterm


;;	enable exit intercept
;
;	uses	AX,SI,DS
;
enable_exit_intercept proc
	mov	ds,psp[bp]
	mov	si,0Ah

	mov	ax,cs
	cmp	ax,[si+2]
	je	eei1			;  if exit intercept already set

	xchg	ax,[si+2]
	mov	terminate_segment[bp],ax

	lea	ax,process_surprise_exit
	xchg	ax,[si]
	mov	terminate_offset[bp],ax

eei1:	ret
enable_exit_intercept endp


;;	disable exit intercept
;
;	uses	AX,SI,DS
;
disable_exit_intercept proc
	movx	ax,0
	xchg	ax,terminate_segment[bp]
	cmpx	ax,0
	je	dei1			;  if no exit intercept

	mov	ds,psp[bp]		; restore original terminate address
	mov	si,0Ah
	mov	[si+2],ax

	movx	ax,0
	xchg	ax,terminate_offset[bp]
	mov	[si],ax

dei1:	ret
disable_exit_intercept endp


;;	process surprise exit
;
process_surprise_exit proc far
	mov	cx,DGROUP		; access DGROUP via DS (SS != DGROUP)
	mov	ds,cx
	assume	ds:DGROUP

	push	terminate_segment	; set far return to original terminate
	push	terminate_offset	;  address from PSP:000A

	mov	ax,sp			; save COMMAND.COM's stack pointer
	mov	dx,ss

	mov	ss,cx			; switch to our stack
	mov	sp,top_of_stack

	pushf				; call terminators
	pushm	ax,dx,bp
	movx	bp,0
	lea	di,xcend
	lea	si,xcbegin
	call	initterm
	popm	bp,dx,ax
	popf				;  (flags aren't changed by intercept)

	mov	ss,dx			; restore COMMAND.COM stack
	mov	sp,ax
	ret
process_surprise_exit endp

	end
