/*
    COOP.C - functions to handle twll structure and related structures

    add_twll()              - insert a new item on the top of the list
    add_data_twll()         - add a new data_twll item by calling add_twll()
    print_twll()            - print a description of the item's type
    print_data_twll()       - print values and call print_twll()
    print_my_data_twll()    - print values and call print_data_twll()
    print_other_data_twll() - print values and call print_data_twll()

*/

#include "coop.h"


/* -----------------------------------------------------------------
 Add a new item to the top of a two way linked list
*/

add_twll(head,twll,type)
struct TWLL_HEAD *head;
struct TWLL    *twll;
int              type;
{
    struct TWLL *cur;

    cur        =head->top;
    twll->prev =0;
    twll->next =cur;
    if (cur) {
        cur->prev  =twll;
        head->top  =twll;
        head->cnt++;
        }
    head->top=twll;
    twll->type=type;
}



/* -----------------------------------------------------------------
 This function inits any struct that starts with DATA_TWLL.

 These structures must have x and y inited to 5 and 6.

 It then calls the regular add function to insert the struct.
*/

add_data_twll(head,twll,type)
struct HEAD_TWLL *head;
struct DATA_TWLL *twll;
int              type;

{
    twll->x=5;
    twll->y=6;
    add_twll(head,twll,type);
}





/* -----------------------------------------------------------------
 Print the data type

*/

print_twll(twll)
struct TWLL *twll;
{
    switch (twll->type) {
        case DATA:
            printf("type is DATA\n");
            break;
        case MY_DATA:
            printf("type is MY_DATA\n");
            break;
        case OTHER_DATA:
            printf("type is OTHER_DATA\n");
            break;
        }
    return;
}





/* -----------------------------------------------------------------
 Print the data in a DATA_TWLL
*/

print_data_twll(twll)
struct DATA_TWLL *twll;

{
    printf("x is %d, y is %d \t",twll->x,twll->y);
    print_twll(twll);
}



/* -----------------------------------------------------------------
 Print the data in a MY_DATA_TWLL
*/

print_my_data_twll(twll)
struct MY_DATA_TWLL *twll;
{
    printf("a is %s \t",twll->a);
    print_data_twll(twll);
}




/* -----------------------------------------------------------------
 Print the data in a OTHER_DATA_TWLL
*/

print_other_data_twll(twll)
struct OTHER_DATA_TWLL *twll;
{
     printf("a is %d \t",twll->a);
     print_data_twll(twll);

}
