/* 
  Initialization segment for the digital clock.
  This code can be discarded after it is used.
 */

#include <windows.h>
#include "dc.h"

/* local function declarations */
static BOOL NEAR RegisterWindowClass(HANDLE);
static HFONT NEAR GetFontInfo(HANDLE);
static void NEAR GetPrevInstanceData(HANDLE);
static BOOL NEAR MakeAndShowMainWnd(HANDLE, HANDLE, int);

/* This routine is FAR since it is called from another segment */
BOOL FAR InitProgram(hInstance,hPrevInstance, lpszCmdLine, cmdShow)
HANDLE hInstance, hPrevInstance;
LPSTR lpszCmdLine;
int cmdShow;
{

  /* if this is the first instance of the program ... */
    if (!hPrevInstance) {
      /* read some strings from the resources */
	LoadString(hInstance,IDS_TIMESTR,(LPSTR)szTimestr,sizeof(szTimestr));
	LoadString(hInstance,IDS_AM,(LPSTR)szAM,sizeof(szAM));
	LoadString(hInstance,IDS_PM,(LPSTR)szPM,sizeof(szPM));
      /* register the window */
	if (!RegisterWindowClass(hInstance))
	    return FALSE;
      /* get a font for displaying the time in the icon window */
        if ((hFont = GetFontInfo(hInstance)) == NULL)
	    return FALSE;
    }
  /* A previous instance already exists so get global data from there */
    else
	GetPrevInstanceData(hPrevInstance);

  /* Create and show the window */
    if (!MakeAndShowMainWnd(hInstance,hPrevInstance, cmdShow))
	return FALSE;

  /* Set the timer to generate a WM_TIMER message about once a second */
    if (!(ClockTimerEventID = SetTimer(hWndMain, NULL, 975, NULL)))
		/* at 1000 msec, clock skips a second every 24 seconds;   */
		/* at  975 msec, clock repeats a second every 87 seconds  */
        return FALSE;

    return TRUE;
}

/* Every window must belong to a class. We register ours here */
static BOOL NEAR RegisterWindowClass(hInstance)
HANDLE hInstance;
{

    PWNDCLASS pWndClass;
    HANDLE hTemp;

  /* Load the name string from resources */
    LoadString(hInstance, IDS_APPNAME,(LPSTR)szAppName,sizeof(szAppName));

  /* allocate space for the WNDCLASS structure and lock it down */
    hTemp = LocalAlloc(LPTR,sizeof(WNDCLASS));
    pWndClass = (PWNDCLASS)LocalLock(hTemp);

  /* fill the structure */	
    pWndClass->hCursor	= LoadCursor(NULL, IDC_ARROW);  /* standard cursor */
    pWndClass->hIcon	= NULL;				/* no icon */
    pWndClass->lpszMenuName = NULL;			/* no class menu */
    pWndClass->lpszClassName = (LPSTR)szAppName;	/* our class name */
    pWndClass->hbrBackground = GetStockObject(WHITE_BRUSH); /*white background*/
    pWndClass->hInstance = hInstance;		/* instance handle */
    pWndClass->style = CS_VREDRAW | CS_HREDRAW; /* standard redraw values */
    pWndClass->lpfnWndProc = MainWndProc;	/* pointer to our window proc */

  /* register the class.  if fail, abort */
    if (!RegisterClass((LPWNDCLASS)pWndClass))
	return FALSE;

  /* free the memory used */
    LocalUnlock(hTemp);
    LocalFree(hTemp);

  /* show success */
    return TRUE;
}

/*
   If this not the first instance, we can retrieve static data from a
   previous invocation of the program
*/
static void NEAR GetPrevInstanceData(hInstance)
HANDLE hInstance;
{

    GetInstanceData(hInstance, (PSTR)szAppName, sizeof(szAppName));
    GetInstanceData(hInstance, (PSTR)szTimestr, sizeof(szTimestr));
    GetInstanceData(hInstance, (PSTR)szAM, sizeof(szAM));
    GetInstanceData(hInstance, (PSTR)szPM, sizeof(szPM));
    GetInstanceData(hInstance, (PSTR)&hFont, sizeof(HFONT));
}

/*
 Create the window, making sure that its position and size are suitable
 for the display.
*/
static BOOL NEAR MakeAndShowMainWnd(hInstance, hPrevInstance, cmdShow)
HANDLE hInstance;
HANDLE hPrevInstance;
int cmdShow;
{

    DWORD style;
    RECT clrect;
    HDC hIC;
    char szDisplayName[20];
    TEXTMETRIC TM;
    int displaywidth, displayheight;
    int width, height;

  /* First, create an information context for the display */
    LoadString(hInstance, IDS_DISPLAYNAME,
			 (LPSTR)szDisplayName,sizeof(szDisplayName));
    hIC = CreateIC((LPSTR)szDisplayName,(LPSTR)NULL, (LPSTR)NULL, (LPSTR)NULL);
  /* Now get the size of the system font */
    GetTextMetrics(hIC, (LPTEXTMETRIC)&TM);
  /* Also, retrieve information about the width and height of the display */
    displayheight = GetDeviceCaps(hIC, VERTRES);
    displaywidth = GetDeviceCaps(hIC, HORZRES);
  /* delete what we no longer need */
    DeleteDC(hIC);
  /* 
     Now we specify the client window we would like to have.  However,
     its position is only nominal and later we will move it.  What we
     really want is the size of the window we need to create to achieve
     the desired client area.  Since the display is one line, the client
     must be high enough to display it.  And, since the text is an
     expression of the form hh:mm:ss A.(P.)M., it must be at least 13
     characters wide.
   */
    clrect.left = 0;
    clrect.top = 0;
    clrect.right = TM.tmAveCharWidth * 13;
    clrect.bottom = TM.tmHeight + TM.tmExternalLeading;

  /* this is the style we want */
    style = WS_OVERLAPPED | WS_MINIMIZEBOX | WS_CAPTION | WS_SYSMENU
				| WS_THICKFRAME;
  /* adjust the rectangle to the actual window size */
    AdjustWindowRect((LPRECT)&clrect, style, FALSE);
  /* now compute the actual client width and height */
    width = clrect.right - clrect.left;
    height = clrect.bottom - clrect.top;
  /* create the window, letting it fall where Windows wants */
    hWndMain = CreateWindow((LPSTR)szAppName,
			     (LPSTR)szAppName,
			     style,
			     CW_USEDEFAULT,0,
			     width, height,
			     (HWND)NULL,
			     (HMENU)NULL,
			     (HANDLE)hInstance,
			     (LPSTR)NULL);

  /* if we fail, give up */
    if (hWndMain == NULL)
	return FALSE;
  /* 
     if this is the first instance, we move the window
     to the lower right corner.
  */
    if (!hPrevInstance) {
      /* first, find out where we are */
        GetWindowRect(hWndMain, (LPRECT)&clrect);
      /* compute the width and height */
	width = clrect.right - clrect.left;
	height = clrect.bottom - clrect.top;
      /* now move the window down to the right corner */
        MoveWindow(hWndMain, displaywidth - width, displayheight - height,
			 width, height,FALSE);
    }
  /* finally, display the window and show success */
    ShowWindow(hWndMain, cmdShow);
    UpdateWindow(hWndMain);

    return TRUE;
}

/* 
   Create a logical font that is suitable for displaying the time
   in our format when the window is iconic.  Since the font weight
   and size will depend on the display in use, three of the parameters
   can be read from WIN.INI.  For CGA type displays, try using a
   height of 6, a width of 4, and a weight of 400.  For the EGA,
   values of 8, 6, and 700 (the defaults) are satisfactory.
*/
static HFONT NEAR GetFontInfo(hInstance)
HANDLE hInstance;
{

    char szKeystr[30];
  /* fill this structure with the font characteristics we want */
    LOGFONT clockfont;  
    HFONT htemp;
  /* read the height from Win.ini */
    LoadString(hInstance,IDS_FONTHEIGHT,(LPSTR)szKeystr, sizeof(szKeystr));
    clockfont.lfHeight = GetProfileInt((LPSTR)szAppName, (LPSTR)szKeystr,8);

  /* read the width from Win.ini */
    LoadString(hInstance,IDS_FONTWIDTH,(LPSTR)szKeystr, sizeof(szKeystr));
    clockfont.lfWidth = GetProfileInt((LPSTR)szAppName, (LPSTR)szKeystr,6);

  /* read the weight from Win.ini */
    LoadString(hInstance,IDS_FONTWEIGHT,(LPSTR)szKeystr, sizeof(szKeystr));
    clockfont.lfWeight = GetProfileInt((LPSTR)szAppName, (LPSTR)szKeystr,700);

  /* default these values */
    clockfont.lfEscapement = 0;
    clockfont.lfOrientation = 0;
    clockfont.lfItalic = 0;
    clockfont.lfUnderline = 0;
    clockfont.lfStrikeOut = 0;
    clockfont.lfCharSet = ANSI_CHARSET;
    clockfont.lfOutPrecision = OUT_DEFAULT_PRECIS;
    clockfont.lfClipPrecision = CLIP_DEFAULT_PRECIS;
    clockfont.lfQuality = DEFAULT_QUALITY;
    clockfont.lfPitchAndFamily = FIXED_PITCH | FF_MODERN;
    clockfont.lfFaceName[0] = 0;

  /* get the handle to the font */

    return(CreateFontIndirect((LPLOGFONT)&clockfont));
}
