  /*
   * timer    -----   Gives a rough execution time of a particular process
   *
   * Uses:
   *
   *      timer.c     -   Picks off cmd line and assembles it for spawnvp()
   *      gettime.c   -   Pulls clock ticks from MS-DOS
   *
   *   Copyright by Frank D. Greco, 1987
   *   Page 50, Volume 6.1 Programmer's Journal
   */
  
  #include <stdio.h>
  #include <process.h>
  #include <dos.h>
  #include <errno.h>
  #include "timer.h"
  
  #define NO_ERR      0       /* No error to return to the shell */
  #define NO_ARGS     1       /* If nothing to time, return this value */
  
  extern int errno;
  
  main(argc,argv)
  char **argv;
  {
      char *bp;                   /* Ptr to command to be spawned */
      unsigned long gettime();    /* Gets clock ticks from MS-DOS */
      int ret;                    /* To save the return value of spawn() */
  
      if (argc == 1)      /* If nothing to time, bye-bye */
          exit(NO_ARGS);
  
      bp = argv[1];       /* We need to avoid problems with side effects,
                           * so use another ptr to the command to be spawned.
                           */
  /*
   * Now time the requested command 
   */
      TIME(ret = spawnvp(P_WAIT, bp, ++argv), bp);
      
      if ( ret == -1 )        /* In case of an error with spawn */
          switch (errno)
          {
              case ENOENT:    fprintf(stderr, "File '%s' not found\n", bp);
                              exit(1);
  
              case ENOMEM:    fprintf(stderr, "%s to run '%s'\n", 
                                  "Not enough memory", bp);
                              exit(2);
  /*
   *  Spawn() does not appear to recognize invalid executables properly, 
   *  so it appears that the following error (i.e., ENOEXEC) will 
   *  unfortunately never be caught.
   */
              case ENOEXEC:   fprintf(stderr, "Cannot execute '%s'\n", bp);
                              exit(3);
  
              default:        fprintf(stderr, "Cannot spawn '%s'\n", bp);
                              exit(4);
          }
      exit(NO_ERR);       /* Good Housekeeping */
  }
