;--------------------------------------------------------------------
;   Code For "The Case of the Invisible CapsLock" by Tom Swan
;        Page 24, Volume 5.5, Programmer's Journal
;--------------------------------------------------------------------
;
;  PURPOSE      : CapsLock Cursor Display program (TSR)
;
;  SYSTEM       : IBM PC-DOS
;
;  LANGUAGE     : Microsoft Macro Assembler (MASM)
;
;  AUTHOR       : (C) 1987 by Tom Swan, Swan Software, P.O. Box
;                 206, Lititz, PA 17543 
;
;--------------------------------------------------------------------
;----- Equates
 
cr              equ     13              ;ASCII carriage return
lf              equ     10              ;ASCII line feed
caps            equ     040h            ;CapsLock kbflag bit
monochrome      equ     7               ;Monochrome video mode
last8x8mode     equ     0eh             ;If <=, assume 8x8 chars
fatStart14      equ     7               ;14-line cursor fat
thinStart14     equ     11              ; and thin start/end lines
endLine14       equ     12
fatStart8       equ     3               ;8-line cursor fat
thinStart8      equ     6               ; and thin start/end lines
endLine8        equ     7
 
 
BIOSDATA        SEGMENT AT 40H
 
kbflag          equ     017h            ;Keyboard flag offset
crtmode         equ     049h            ;Current video mode
BIOSDATA        ENDS
 
 
;----- Start of Program
 
CSEG            SEGMENT byte
                ASSUME  cs:CSEG,ds:CSEG,ss:CSEG,es:CSEG
                ORG     100h            ;com file entry point
 
CapsLock:       jmp     short init      ;jump to initialize program
 
 
page;----------------------------------------------------------
; INT9
;----------------------------------------------------------
; Purpose       -- Trap keyboard interrupt #9 on every
;                   keypress.  Set cursor according to
;                   current CapsLock/NumLock settings
;                   then continue with normal interrupt.
;
; Called by     -- Keyboard hardware interrupt (#9)
;
; Calls         -- Jumps to pre-installation code
;                  Does not call DOS
;
; Arguments     -- none
;
; Registers     -- none changed
;----------------------------------------------------------
 
        ASSUME  cs:CSEG, ds:BIOSDATA
 
oldcaps db      0               ;last known capslock setting
int9    PROC    near
 
        pushf                   ; save flags & registers
        push    ax
        push    cx
        push    ds
 
        mov     ax,BIOSDATA     ;set dsregister to
        mov     ds,ax           ; BIOS data segment
        mov     ah,byte ptr [ds:kbflag]         ;get keyboard flag
        and     ah,caps         ;isolate capslock bit
        cmp     ah,byte ptr [cs:oldcaps]        ;compare old setting
        je      exit            ;exit if not changed
        mov     byte ptr[cs:oldcaps],ah         ;save new setting
        mov     al,byte ptr [ds:crtmode]        ;get video mode
        cmp     al,monochrome   ;if monochrome
        je      line14          ; then use 14-line cursor settings
        cmp     al,last8x8mode  ;else if less than this
        jle     line8           ; then use 8-line cursor settings
 
line14:
        mov     al,fatStart14   ; 14-line cursors
        mov     ch,thinStart14
        mov     cl,endLine14
        jmp     short change
 
line8:
        mov     al,fatStart8    ; 8-line cursors
        mov     ch,thinStart8
        mov     cl,endLine8
 
 
;----- Change cursor style.  At this point, ah=capslock bit,
;      al=fat start line, ch=thin startline, cl=end line 
change:
        or      ah,ah           ;test capslock setting
        jz      nocaps          ;jump if key is off (thin style)
        mov     ch,al           ;else switch to fat style
 
nocaps:
        mov     ah,1            ;select cursor style
        int     10h             
;execute BIOS video I/O interrupt
 
exit:
        pop     ds              ;restore registers & flags
        pop     cx
        pop     ax
        popf
 
 
;----- The following reserves space fora far jump instruction,
;      filled in by the initialization code.  This lets the program
;      continue to the original address that handled this interrupt
;      before installing the TSR code.
 
        db      0eah    ;ea=far jump hex code
 
address:
        dd      0       ;32-bit jump address (unitialized)
 
int9    ENDP            ;end of procedure
 
 
page
;----------------------------------------------------------
; INIT
;----------------------------------------------------------
; Purpose       -- Initialize interrupt trap, terminate
;                   program and stay resident.  All code
;                   from this point on is NOT saved
;                   in memory.  Everything before stays.
;
; Called by     -- Main program (via jmp)
;
; Calls         -- DOS
;----------------------------------------------------------
 
        ASSUME  cs:CSEG,ds:CSEG
 
init    PROC    near
        mov     dx,offset id    ;print program id
        mov     ah,9
        int     21h
 
 
;----- Get vector to current interrupt #9 routine
 
        mov     ax,3509h        ;ah=35 
(get vector)
                                ;al=09 
(vector number)
        int     21h             ;set es:bx to current vector
 
 
;----- Insert vector as far jump address at end of resident code
 
init1:  mov     word ptr address,bx     ;set far jmp offset address
        mov     word ptr address+2,es   ;set far jmp segment address
 
;----- Change interrupt vector to the new TSR routine.
 
        mov     dx,offset int9  ;dx=address of routine
        mov     ax,2509h        ;ah=25(set vector)
                                
;al=09(vector number)
        int     21h             ;set interrupt 9 vector
 
 
;----- Make sure capslock bit is off.
 
        ASSUME  ds:BIOSDATA
 
        push    ds
        mov     ax,BIOSDATA
        mov     ds,ax           ;address BIOS data segment
        and     byte ptr [ds:kbflag],not caps   ; turn off caps
        pop     ds
 
        ASSUME  ds:CSEG
 
 
;----- Terminate and stay resident (TSR).
 
        mov     dx,offset init  ;dx = first available address
        int     27h             ;terminate, stay resident
init    ENDP                    ;end ofprocedure
 
 
;----- Program variables.
 
id      db      cr,lf, 'CapsLock Cursor Display Program'
        db      cr,lf, '(C) 1987 by TomSwan'
        db      cr,lf, 'Swan Software, PO Box 206, Lititz PA  17543'
        db      cr,lf, '$'
 
CSEG    ends                    ;end ofsegment
        end     CapsLock        ;end of program
 
