/* 
 * FPLOT - fpset.c
 *
 * Copyright (C) 1997 - 2000  Michael C. Ring
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for any purpose with or without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and 
 * that both that copyright notice and this permission notice appear 
 * in supporting documentation.
 *
 * Permission to modify the software is granted, but not the right to
 * distribute the modified code.  Modifications are to be distributed 
 * as patches to released version.
 *  
 * This software is provided "as is" without express or implied warranty.
 */

/*
 *      fpset.c
 *
 *      $Log: fpset.c,v $
 *      Revision 1.22  2000/01/17 21:31:19  mike
 *      add 'ALL' to label fontsize and rotations
 *
 *      Revision 1.21  2000/01/17 21:05:43  mike
 *      added set coordinates command
 *
 *      Revision 1.20  2000/01/13 04:22:19  mike
 *      add new grid line option
 *
 *      Revision 1.19  2000/01/10 04:25:07  mike
 *      add graph border code
 *
 *      Revision 1.18  2000/01/09 03:45:22  mike
 *      change g_buf to g_fields
 *
 *      Revision 1.17  2000/01/08 05:56:01  mike
 *      added proto.h and prototypes
 *
 *      Revision 1.16  1999/09/25 22:09:10  mring
 *      added new set pointsizescale command
 *
 *      Revision 1.15  1999/09/25 21:39:03  mring
 *      change special flag values for center and rightjustify
 *
 *      Revision 1.14  1998/11/26 06:13:43  mring
 *      use #define (NF) when setting local field_? variables
 *
 *      Revision 1.13  1998/10/20 04:04:10  mring
 *      only copy data into field_4 if there are actually 4 fields of data
 *
 *      Revision 1.12  1998/10/20 03:42:03  mring
 *      use local field variables for efficiency and readability
 *
 *      Revision 1.11  1998/10/16 23:09:01  mring
 *      added set rotation option
 *
 *      Revision 1.10  1998/10/16 22:26:48  mring
 *      added MAX_LABELS
 *
 *      Revision 1.9  1998/04/03 20:15:30  mring
 *      changed exit codes from 28 to 31
 *
 *      Revision 1.8  1998/03/08 19:50:23  mring
 *      added 'center' and 'rightjustify' to label commands
 *
 *      Revision 1.7  1998/03/07 04:46:01  mring
 *      error on usesamples when both values are the same
 *
 *      Revision 1.6  1998/03/05 03:42:58  mring
 *      update for 0.5a
 *
 *      Revision 1.5  1997/12/06 23:02:05  mring
 *      allow 0 for fielddefinition
 *      split file into 2 source files, created fpcmd.c
 *
 *      Revision 1.4  1997/12/05 02:20:43  mring
 *      update for version 0.4a
 *
 *      Revision 1.3  1997/11/26 23:20:56  mring
 *      added MAX_LINE_LENGTH
 *
 *      Revision 1.2  1997/11/24 01:32:07  mring
 *      added copyright notice
 *
 *      Revision 1.1  1997/11/23 23:08:19  mring
 *      Initial revision
 */

#include "fplot.h"
#include "proto.h"
#include "glob.h"

/* RCS TRACER */
/* 
 * $Id: fpset.c,v 1.22 2000/01/17 21:31:19 mike Exp $
 */

/***********************************************************************/
void	parse_set_command(fieldcount)
int     fieldcount;
{
int     k, cmd_found, bflag, font_flag, label_num, label_flag, 
	bit_map, fielddef;
double  d1, d2;
char    *field_2, *field_3, *field_4, *cp;

fieldcount = reset_field_count(fieldcount);

if (fieldcount <= 2)           /* all set commands have at least 3 fields */
  {
   invalid_set_command(fieldcount,30);
  }

field_2 = g_fields[NF-1];      /* in general, this is a bad idea ...  */
field_3 = g_fields[NF-2];
field_4 = g_fields[NF-3];

strcpy(field_2,g_fields[2]);   /* make local copy and convert to lower case */
lowercase(field_2);

strcpy(field_3,g_fields[3]);   /* make local copy and convert to lower case */
lowercase(field_3);

if (fieldcount >= 4)           /* make local copy only if we need it */
  {
   strcpy(field_4,g_fields[4]); 
   lowercase(field_4);
  }

cmd_found = FALSE;

label_num = 0;		       /* keep the compiler quiet */
 
/*
 *      set papersize 8.5, 11.0
 */

if (strposition(field_2,"papersi") == 0)  /* accept this for 'papersize' */
  {
   cmd_found = TRUE;

   if (fieldcount != 4)                   /* this command has 4 fields */
     invalid_set_command(fieldcount,31);

   g_papersize_width  = atof(field_3);
   g_papersize_length = atof(field_4);

   if (g_papersize_width < 0.90 || g_papersize_length < 0.90)
     invalid_set_command(fieldcount,31);
  }
 

/*
 *      set pointsizescale 0.7103
 */

if (strposition(field_2,"pointsiz") == 0) /* accept this for 'pointsizescale'*/
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   g_point_size_scale = atof(field_3);

   if (g_point_size_scale < 0.001)
     invalid_set_command(fieldcount,31);
  }


/*
 *      set graphborders .5 1.0 .75 .8
 *                       left  top  right  bottom
 */

if (strposition(field_2,"graphbord") == 0) /* accept this for 'graphborders'*/
  {
   cmd_found = TRUE;

   if (fieldcount != 6)                   /* this command has 6 fields */
     invalid_set_command(fieldcount,31);

   g_border_left   = atof(field_3);
   g_border_top    = atof(field_4);
   g_border_right  = atof(g_fields[5]);
   g_border_bottom = atof(g_fields[6]);

   bflag = FALSE;

   if (g_border_left < 0.0999)    bflag = TRUE;
   if (g_border_top < 0.0999)     bflag = TRUE;
   if (g_border_right < 0.0999)   bflag = TRUE;
   if (g_border_bottom < 0.0999)  bflag = TRUE;

   d1 = g_papersize_width - g_border_top - g_border_bottom;
   if (d1 < 2.0)  bflag = TRUE;
   
   d1 = g_papersize_length - g_border_left - g_border_right;
   if (d1 < 2.0)  bflag = TRUE;

   if (bflag)
     invalid_set_command(fieldcount,31);
  }


/*
 *      set outputformat postscript
 */
					/* accept this for 'outputformat' */
if (strposition(field_2,"outputfor") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                     /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   if (strposition(field_3,"postsc") == 0)  /* postscript */
      g_outputformat = FORMAT_POSTSCRIPT;
   else
      invalid_set_command(fieldcount,31);
  }


/*
 *      set usesamples 50, 100
 */

if (strposition(field_2,"usesampl") == 0) /* accept this for 'usesamples' */
  {
   cmd_found = TRUE;

   if (fieldcount != 4)                   /* this command has 4 fields */
     invalid_set_command(fieldcount,31);

   g_usesamples_low  = atol(field_3);
   g_usesamples_high = atol(field_4);

   if (g_usesamples_low >= g_usesamples_high)
     invalid_set_command(fieldcount,31);

   if (g_usesamples_low < 0 || g_usesamples_high < 0)
     invalid_set_command(fieldcount,31);

   g_usesamples = TRUE;
  }


/*
 *      set skipfactor 9
 */

if (strposition(field_2,"skipfa") == 0) /* accept this for 'skipfactor' */
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   if ((g_skip_factor = atol(field_3)) < 0)
     invalid_set_command(fieldcount,31);
  }


/*
 *      set gridlines on
 *      set gridlines off
 *      set gridlines tick
 */

if (strposition(field_2,"gridlin") == 0)  /* accept this for 'gridlines' */
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   if (strcmp(field_3,"on") == 0)
      g_gridlines = GRID_LINES_ON;
   else
     {
      if (strcmp(field_3,"off") == 0)
	 g_gridlines = GRID_LINES_OFF;
      else
        {
         if (strposition(field_3,"tick") == 0)
	   g_gridlines = GRID_LINES_TICK;
         else
	   invalid_set_command(fieldcount,31);
	}
     }
  }


/*
 *      set fontsize title 18.0
 *                   xlabel, ylabel, y1label, y2label
 *                   label1-N
 *                   labelall
 */

if (strposition(field_2,"fontsi") == 0) /* accept this for 'fontsize' */
  {
   cmd_found = TRUE;
   font_flag = FALSE;

   if (fieldcount != 4)                   /* this command has 4 fields */
     invalid_set_command(fieldcount,31);

   if ((d1 = atof(field_4)) < 0.1)
     invalid_set_command(fieldcount,31);

   if (strcmp(field_3,"title") == 0)
     {
      font_flag = TRUE;
      g_fontsize_title = d1;
     }

   if (strcmp(field_3,"xlabel") == 0)
     {
      font_flag = TRUE;
      g_fontsize_xlabel = d1;
     }

   if (strcmp(field_3,"ylabel") == 0 || strcmp(field_3,"y1label") == 0)
     {
      font_flag = TRUE;
      g_fontsize_y1label = d1;
     }

   if (strcmp(field_3,"y2label") == 0)
     {
      font_flag = TRUE;
      g_fontsize_y2label = d1;
     }

    /* see if we are specifying label 1-N, or ALL */

    if (font_flag == FALSE)
      {
       if (strposition(field_3,"label") == 0)
	 {
	  cp  = field_3;
	  cp += 5;
	  label_num = atoi(cp);

          if (strcmp(cp,"all") == 0)     /* init all labels ?? */
            {
	     font_flag = TRUE;

	     for (k=1; k <= MAX_LABELS; k++)
	       g_label_fontsize[k] = d1;
	    }
          else
            {
	     if (label_num >= 1 && label_num <= MAX_LABELS)
	       {
	        g_label_fontsize[label_num] = d1;
	        font_flag = TRUE;
	       }
	    }
	 }
      }

   if (font_flag == FALSE)
     {
      invalid_set_command(fieldcount,31);
     }
  }


/*
 *      set rotation label1 90.0
 *      set rotate   labeln -90.0
 *      set rotate   label128 43.8
 *      set rotate   labelall 180.0
 */

if (strposition(field_2,"rotat") == 0)   /* accept this for 'rotation' */
  {
   cmd_found = TRUE;

   if (fieldcount != 4)                   /* this command has 4 fields */
     invalid_set_command(fieldcount,31);

   d1 = atof(field_4);
   if (d1 < -180.1 || d1 > 180.1)
     invalid_set_command(fieldcount,31);

   if (strposition(field_3,"label") == 0)
     {
      cp  = field_3;
      cp += 5;
      label_num = atoi(cp);

      if (strcmp(cp,"all") == 0)     /* init all labels ?? */
        {
	 for (k=1; k <= MAX_LABELS; k++)
	   g_label_rotate[k] = d1;
	}
      else
        {
         if (label_num >= 1 && label_num <= MAX_LABELS)
	    g_label_rotate[label_num] = d1;
         else
	    invalid_set_command(fieldcount,31);
        }
     }
   else
      invalid_set_command(fieldcount,31);
  }


/*
 *      set coordinates label1 inches
 *      set coordinates label128 plotcoordinates
 *      set coordinates labelall inches|plotcoord
 *
 *	see the function 'get_xy_coord_labels' in fpout.c
 *	for the bit map definition of 'g_label_coord[]'.
 */

if (strposition(field_2,"coordin") == 0)   /* accept this for 'coordinates' */
  {
   cmd_found = TRUE;

   if (fieldcount != 4)                    /* this command has 4 fields */
     invalid_set_command(fieldcount,31);

   if (strposition(field_3,"label") == 0)
     {
      cp  = field_3;
      cp += 5;
      label_num = atoi(cp);

      bit_map = 0;
      if (strposition(field_4,"inch") == 0)    bit_map = 1;
      if (strposition(field_4,"plotco") == 0)  bit_map = 2;

      if (bit_map == 0)
        invalid_set_command(fieldcount,31);

      if (strcmp(cp,"all") == 0)     /* init all labels ?? */
        {
	 for (k=1; k <= MAX_LABELS; k++)
	   {
	    /* this also clears the 'center' and 'rightjustify' bits */

	    g_label_coord[k] = bit_map;
	   }
	}
      else
        {
         if (label_num >= 1 && label_num <= MAX_LABELS)
	   {
	    g_label_coord[label_num] &= ~0xF;
	    g_label_coord[label_num] |= bit_map;
	   }
         else
	    invalid_set_command(fieldcount,31);
        }
     }
   else
      invalid_set_command(fieldcount,31);
  }


/*
 *      set xoffset -2.0
 */

if (strposition(field_2,"xoffs") == 0) /* accept this for 'xoffset' */
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   g_xoffset = atof(field_3);
  }


/*
 *      set yoffset 32.0    (also y1offset)
 */

if (strposition(field_2,"yoffs") == 0 ||
    strposition(field_2,"y1offs") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   g_y1offset = atof(field_3);
  }


/*
 *      set y2offset -32.0  
 */

if (strposition(field_2,"y2offs") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   g_y2offset = atof(field_3);
  }


/*
 *      set xmultiplier 1000.0
 */

if (strposition(field_2,"xmulti") == 0) /* accept this for 'xmultiplier' */
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   g_xmultiplier = atof(field_3);
  }


/*
 *      set ymultiplier 1.0E6      (also y1multiplier)
 */

if (strposition(field_2,"ymulti") == 0 ||
    strposition(field_2,"y1multi") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   g_y1multiplier = atof(field_3);
  }


/*
 *      set y2multiplier 10.0     
 */

if (strposition(field_2,"y2multi") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   g_y2multiplier = atof(field_3);
  }


/*
 *      set fielddefinition x,1
 *      set fielddefinition y,2
 *      set fielddefinition y1,2
 *      set fielddefinition y2,3
 *      set fielddefinition y12,3              can specify 1-12
 */
				  /* accept this for 'fielddefinition' */
if (strposition(field_2,"fielddef") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 4)                   /* this command has 4 fields */
     invalid_set_command(fieldcount,31);

   fielddef = FALSE;

   if (strcmp(field_3,"x") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_x = atoi(field_4)) < 0)
	invalid_set_command(fieldcount,31);
     }

   if (strcmp(field_3,"y") == 0 || strcmp(field_3,"y1") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y1 = atoi(field_4)) < 0)
	invalid_set_command(fieldcount,31);
     }

   if (strcmp(field_3,"y2") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y2 = atoi(field_4)) < 0)
	invalid_set_command(fieldcount,31);
     }

   if (strcmp(field_3,"y3") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y3 = atoi(field_4)) < 0)
	invalid_set_command(fieldcount,31);
     }

   if (strcmp(field_3,"y4") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y4 = atoi(field_4)) < 0)
	invalid_set_command(fieldcount,31);
     }

   if (strcmp(field_3,"y5") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y5 = atoi(field_4)) < 0)
	invalid_set_command(fieldcount,31);
     }

   if (strcmp(field_3,"y6") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y6 = atoi(field_4)) < 0)
	invalid_set_command(fieldcount,31);
     }

   if (strcmp(field_3,"y7") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y7 = atoi(field_4)) < 0)
	invalid_set_command(fieldcount,31);
     }

   if (strcmp(field_3,"y8") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y8 = atoi(field_4)) < 0)
	invalid_set_command(fieldcount,31);
     }

   if (strcmp(field_3,"y9") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y9 = atoi(field_4)) < 0)
	invalid_set_command(fieldcount,31);
     }

   if (strcmp(field_3,"y10") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y10 = atoi(field_4)) < 0)
	invalid_set_command(fieldcount,31);
     }

   if (strcmp(field_3,"y11") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y11 = atoi(field_4)) < 0)
	invalid_set_command(fieldcount,31);
     }

   if (strcmp(field_3,"y12") == 0)
     {
      fielddef = TRUE;
      if ((g_field_def_y12 = atoi(field_4)) < 0)
	invalid_set_command(fieldcount,31);
     }

   if (fielddef == FALSE)
     {
      invalid_set_command(fieldcount,31);
     }
  }


/*
 *      set xaxisscale linear
 *      set xaxisscale log
 */

if (strposition(field_2,"xaxissc") == 0) /* accept this for 'xaxisscale' */
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   if (strcmp(field_3,"linear") == 0)
      g_xaxis_scale = X_AXIS_SCALE_LINEAR;
   else
     {
      if (strcmp(field_3,"log") == 0)
	g_xaxis_scale = X_AXIS_SCALE_LOG;
      else
	invalid_set_command(fieldcount,31);
     }
  }


/*
 *      set graphtype lines
 *      set graphtype points
 *      set graphtype linesandpoints
 */

if (strposition(field_2,"graphtyp") == 0) /* accept this for 'graphtype' */
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   if (strcmp(field_3,"lines") == 0)
      g_graph_type = GRAPH_TYPE_LINES;
   else
     {
      if (strcmp(field_3,"points") == 0)
	 g_graph_type = GRAPH_TYPE_POINTS;
      else
	{
	 if (strcmp(field_3,"linesandpoints") == 0)
	   g_graph_type = GRAPH_TYPE_LINES_AND_POINTS;
	 else
	   invalid_set_command(fieldcount,31);
	}
     }
  }


/*
 *      set xrange autorange
 *      set xrange -35.0,45.0
 */

if (strcmp(field_2,"xrange") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount == 3)
     {
      if (strposition(field_3,"auto") == 0)
	 g_xrange_auto = TRUE;
      else
	 invalid_set_command(fieldcount,31);
     }
   else
     {
      if (fieldcount == 4)
	{
	 g_xrange_auto = FALSE;

	 g_xrange_low  = atof(field_3);
	 g_xrange_high = atof(field_4);

	 adjust_min_max(&g_xrange_low,&g_xrange_high);

	 d1 = fabs(g_xrange_low);
	 d2 = fabs(g_xrange_high);

	 if (d2 < d1)  d2 = d1;

	 if (d2 < 1.0E-12)
	   invalid_set_command(fieldcount,31);

	 d1 = (g_xrange_high - g_xrange_low) / d2;

	 if (fabs(d1) < 1.0E-12)
	   invalid_set_command(fieldcount,31);
	}
      else
	{
	 invalid_set_command(fieldcount,31);
	}
     }
  }


/*
 *      set yrange autorange       (y1range also)
 *      set yrange -35.0,45.0      
 */

if (strcmp(field_2,"yrange") == 0 || strcmp(field_2,"y1range") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount == 3)
     {
      if (strposition(field_3,"auto") == 0)
	 g_y1range_auto = TRUE;
      else
	 invalid_set_command(fieldcount,31);
     }
   else
     {
      if (fieldcount == 4)
	{
	 g_y1range_auto = FALSE;

	 g_y1range_low  = atof(field_3);
	 g_y1range_high = atof(field_4);

	 adjust_min_max(&g_y1range_low,&g_y1range_high);

	 d1 = fabs(g_y1range_low);
	 d2 = fabs(g_y1range_high);

	 if (d2 < d1)  d2 = d1;

	 if (d2 < 1.0E-12)
	   invalid_set_command(fieldcount,31);

	 d1 = (g_y1range_high - g_y1range_low) / d2;

	 if (fabs(d1) < 1.0E-12)
	   invalid_set_command(fieldcount,31);
	}
      else
	{
	 invalid_set_command(fieldcount,31);
	}
     }
  }


/*
 *      set y2range autorange
 *      set y2range y1range           force Y2 the same as Y1
 *      set y2range -35.0,45.0      
 */

if (strcmp(field_2,"y2range") == 0)
  {
   cmd_found = TRUE;

   g_force_y2_y1 = FALSE;

   if (fieldcount == 3)
     {
      if (strposition(field_3,"auto") == 0)
	 g_y2range_auto = TRUE;
      else
	{
	 if (strposition(field_3,"y1ra") == 0)
	    g_force_y2_y1 = TRUE;
	 else
	    invalid_set_command(fieldcount,31);
	}
     }
   else
     {
      if (fieldcount == 4)
	{
	 g_y2range_auto = FALSE;

	 g_y2range_low  = atof(field_3);
	 g_y2range_high = atof(field_4);

	 adjust_min_max(&g_y2range_low,&g_y2range_high);

	 d1 = fabs(g_y2range_low);
	 d2 = fabs(g_y2range_high);

	 if (d2 < d1)  d2 = d1;

	 if (d2 < 1.0E-12)
	   invalid_set_command(fieldcount,31);

	 d1 = (g_y2range_high - g_y2range_low) / d2;

	 if (fabs(d1) < 1.0E-12)
	   invalid_set_command(fieldcount,31);
	}
      else
	{
	 invalid_set_command(fieldcount,31);
	}
     }
  }


/*
 *      set outputfile "C:\data.tmp"
 */

if (strcmp(field_2,"outputfile") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   memory_free(g_output_file);
   g_output_file = memory_allocate((strlen(field_3) + 4) * sizeof(char));
   strcpy(g_output_file,g_fields[3]);
  }


/*
 *      set title "this is the graph title"
 */

if (strcmp(field_2,"title") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   memory_free(g_title);
   g_title = memory_allocate((strlen(field_3) + 4) * sizeof(char));
   strcpy(g_title,g_fields[3]);
  }


/*
 *      set xlabel "x axis label"
 */

if (strcmp(field_2,"xlabel") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   memory_free(g_xlabel);
   g_xlabel = memory_allocate((strlen(field_3) + 4) * sizeof(char));
   strcpy(g_xlabel,g_fields[3]);
  }


/*
 *      set ylabel "y axis label"        (also y1label)
 */

if (strcmp(field_2,"ylabel") == 0 || strcmp(field_2,"y1label") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   memory_free(g_y1label);
   g_y1label = memory_allocate((strlen(field_3) + 4) * sizeof(char));
   strcpy(g_y1label,g_fields[3]);
  }


/*
 *      set y2label "y2 axis label"      
 */

if (strcmp(field_2,"y2label") == 0)
  {
   cmd_found = TRUE;

   if (fieldcount != 3)                   /* this command has 3 fields */
     invalid_set_command(fieldcount,31);

   memory_free(g_y2label);
   g_y2label = memory_allocate((strlen(field_3) + 4) * sizeof(char));
   strcpy(g_y2label,g_fields[3]);
  }


label_flag = FALSE;

/*
 *      set label1 3.0, 4.5, "extra label 1 at 3.0, 4.5"
 *      label 1 - MAX_LABELS
 *      set label053 3.0, 4.5, "extra label 53 at 3.0, 4.5"
 */

if (strposition(field_2,"label") == 0)
  {
   cp  = field_2;
   cp += 5;
   label_num = atoi(cp);

   if (label_num >= 1 && label_num <= MAX_LABELS)
      {
       cmd_found  = TRUE;
       label_flag = TRUE;
      }
  }

if (label_flag == TRUE)
  {
   if (fieldcount != 5)                   /* label commands have 5 fields */
     invalid_set_command(fieldcount,31);

   g_label_y[label_num] = atof(field_4);

   /* 
    *   check for 'center' or 'rightjustify' 
    */

   d1 = 0.0;
   g_label_coord[label_num] &= ~0xF0;

   if (strposition(field_3,"center") == 0)
      g_label_coord[label_num] |= 0x10;
   else
     {
      if (strposition(field_3,"right")  == 0)
        g_label_coord[label_num] |= 0x20;
      else
        d1 = atof(field_3);
     }

   g_label_x[label_num] = d1;

   if (g_label_array[label_num] != NULL)
     {
      memory_free(g_label_array[label_num]);
      g_label_array[label_num] = NULL;
     }
   
   cp = memory_allocate((strlen(g_fields[5]) + 4) * sizeof(char));
   strcpy(cp,g_fields[5]);
   g_label_array[label_num] = cp;
  }

if (cmd_found == FALSE)
  {
   invalid_set_command(fieldcount,31);
  }
}
/***********************************************************************/
