//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVLBOX.CPP                           |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     List box implementation              |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_string
#define uses_dc
#define uses_dialog
#define uses_icons
#define uses_label
#define uses_lbox
#define uses_system

#include "PVuses.h"

#define SCROLL_AHEAD 1

static uint ___data_size;
static Tlb_item_comparator ___comparator;

//cmp functions

static int cmp_function( const Tlb_item *a, const Tlb_item *b )
{
  return
    strcmp(
      a->data + ___data_size,
      b->data + ___data_size
    );
}

static int _cmp_function( const Tlb_item *a, const Tlb_item *b )
{
  return ___comparator( a, b );
}

//sort functions

static int sort_function( const void *a, const void *b )
{
  return
    strcmp(
      ( *( (Tlb_item **) a ) )->data + ___data_size,
      ( *( (Tlb_item **) b ) )->data + ___data_size
    );
}

static int _sort_function( const void *a, const void *b )
{
  return ___comparator( *( (Tlb_item **) a ), *( (Tlb_item **) b ) );
}

//search functions

static int search_function( const void *a, const void *b )
{
  return
    strcmp(
      ( (Tlb_item *) a )->data + ___data_size,
      ( *( (Tlb_item **) b ) )->data + ___data_size
    );
}

static int _search_function( const void *a, const void *b )
{
  return ___comparator( (Tlb_item *) a, *( (Tlb_item **) b ) );
}


//Tlb_list publics:

Tlb_list::Tlb_list( void ):
  Tlist(),
  hsize( _hsize ),
  hbeg_print( _hbeg_print ),
  hmax_print( _hmax_print ),
  hmax_size( _hmax_size ),
  changed( _changed ),
  overflow( _overflow )
{
  items_ptr = (Tlb_arr *) MALLOC( 0x100 * sizeof( Tlb_item * ) );
  scroll_ahead = SCROLL_AHEAD;
  hsize = 0;
  hmax_size = 0;
  hbeg_print = 0;
  data_size = __lsize();
  overflow = 0;
  changed = 1;
  lb_item_killer = __litem_killer();
  lb_item_comparator = __litem_comparator();
}

Tlb_list::Tlb_list( Tlb_list *_list ):
  Tlist( _list ),
  hsize( _list->hsize ),
  hbeg_print( _hbeg_print ),
  hmax_print( _hmax_print ),
  hmax_size( _list->hmax_size ),
  changed( _list->changed ),
  overflow( _list->overflow )
{
  hmax_size = 0;
  hbeg_print = 0;
  items_ptr = _list->items_ptr;
  data_size = _list->data_size;
  lb_item_killer = _list->lb_item_killer;
  lb_item_comparator = _list->lb_item_comparator;
}

Tlb_list::Tlb_list( uint &v_count, uint &v_current, uint &v_beg_print, int &v_max_print,
                    uint &h_size, uint &h_beg_print, int &h_max_print ):
  Tlist( v_count, v_current, v_beg_print, v_max_print ),
  hsize( h_size ),
  hbeg_print( h_beg_print ),
  hmax_print( h_max_print ),
  hmax_size( _hmax_size ),
  changed( _changed ),
  overflow( _overflow )
{
  items_ptr = (Tlb_arr *)MALLOC( 0x100 * sizeof( Tlb_item * ) );
  scroll_ahead = SCROLL_AHEAD;
  hsize = 0;
  hmax_size = 0;
  hbeg_print = 0;
  data_size = __lsize();
  overflow = 0;
  changed = 1;
  lb_item_killer = __litem_killer();
  lb_item_comparator = __litem_comparator();
}

Tlb_list::~Tlb_list( void )
{
  if( !( options & loASSOCIATED ) )
  {
    clear();
    if( items_ptr != NULL ) FREE( items_ptr );
  }
}

void Tlb_list::clear( void )
{
  if( items_ptr != NULL )
    for( uint i = 0; i < vcount; i++ )
      free_lb_item( (*items_ptr)[i] );
  hsize = 0;
  hmax_size = 0;
  hbeg_print = 0;
  overflow = 0;
  changed = 1;
  Tlist::clear();
}

uint Tlb_list::add( void *data )
{
  Tlb_item *p;
  int (* cmp) ( const Tlb_item *, const Tlb_item * );
  int m, l, r, x;

  if( overflow ) return (uint) -1;
  p = alloc_lb_item( (char *) data );
  if( p == NULL )
  {
    overflow = 1;
    return (uint) -1;
  }
  inc_count();
  if( overflow )
  {
    free_lb_item( p );
    return (uint) -1;
  }
  l = vcount - 1;
  if( ( vcount > 1 ) && ( options & loSORTED ) )
  {
    cmp = cmp_function;
    if( lb_item_comparator != NULL ) cmp = _cmp_function;
    ___data_size = data_size;
    ___comparator = lb_item_comparator;
    l = 0; r = vcount - 2;
    while( l <= r )
    {
      m = ( l + r ) / 2;
      x = cmp( (*items_ptr)[m], p );
      if( x == 0 )
      {
        l = m;
        break;
      }
      if( x < 0 ) { l = m+1; continue; }
      if( x > 0 ) r = m-1;
    }
    if( l < ( vcount - 1 ) )
      memmove( &( (*items_ptr)[l + 1] ), &( (*items_ptr)[l] ), (vcount - l - 1) * sizeof( Tlb_item * ) );
  }
  (*items_ptr)[l] = p;
  at( l );
  changed = 1;
  return l;
}

void Tlb_list::ins( uint i, void *data )
{
  Tlb_item *lbi;

  if( overflow ) return;
  if( i >= vcount )
    add( data );
  else
  {
    lbi = alloc_lb_item( (char *) data );
    if( lbi == NULL )
    {
      overflow = 1;
      return;
    }
    inc_count();
    if( overflow ) return;
    memmove( &( (*items_ptr)[i + 1] ), &( (*items_ptr)[i] ), (vcount - i - 1) * sizeof( Tlb_item * ) );
    (*items_ptr)[i] = lbi;
  }
  changed = 1;
}

void Tlb_list::del( uint i )
{
  if( ( i >= vcount ) || !vcount ) return;
  free_lb_item( (*items_ptr)[i] );
  memmove( &( (*items_ptr)[i] ), &( (*items_ptr)[i+1] ), (vcount - i - 1) * sizeof( Tlb_item * ) );
  dec_count();
  if( vcurrent >= vcount ) bottom();
  overflow = 0;
  changed = 1;
}

void Tlb_list::get( uint i, void *data )
{
  Tlb_item *p;

  if( i >= vcount ) return;
  p = (*items_ptr)[i];
  memmove( data, p->data, data_size );
  strcpy( ( (char *) data ) + data_size, p->data+data_size );
}

void Tlb_list::put( uint i, void *data )
{
  Tlb_item *n;

  if( i >= vcount ) return;
  n = alloc_lb_item( (char *) data );
  if( n == NULL )
  {
    overflow = 1;
    return;
  }
  free_lb_item( (*items_ptr)[i] );
  (*items_ptr)[i] = n;
  changed = 1;
}

void Tlb_list::sort( void )
{
  sort_range( 0, vcount );
}

void Tlb_list::sort_range( uint from, uint how_many )
{
  int (* sort_func) ( const void *, const void * );

  sort_func = sort_function;
  if( lb_item_comparator != NULL ) sort_func = _sort_function;
  ___data_size = data_size;
  ___comparator = lb_item_comparator;
  qsort( *items_ptr + from, how_many, sizeof( Tlb_item * ), sort_func );
}

uint Tlb_list::bin_search( Tlb_item *p )
{
  return bin_search_range( p, 0, vcount );
}

uint Tlb_list::bin_search_range( Tlb_item *p, uint from, uint how_many )
{
  int (* search_func) ( const void *, const void * );
  Tlb_item **key;

  search_func = search_function;
  if( lb_item_comparator != NULL ) search_func = _search_function;
  ___data_size = data_size;
  ___comparator = lb_item_comparator;
  key = (Tlb_item **) bsearch( p, *items_ptr + from, how_many, sizeof( Tlb_item * ), search_func );
  if( key == NULL ) return -1;
  return key - *items_ptr;
}

void Tlb_list::up( void )
{
  uint i, j;

  if( !vcount ) return;
  i = vcurrent; j = vbeg_print;
  Tlist::up();
  while( !enabled( vcurrent ) && vcurrent ) Tlist::up();
  if( !enabled( vcurrent ) )
  {
    vcurrent = i;
    vbeg_print = j;
  }
}

void Tlb_list::down( void )
{
  uint i, j;

  if( !vcount ) return;
  i = vcurrent; j = vbeg_print;
  Tlist::down();
  while( !enabled( vcurrent ) && ( vcurrent < ( vcount - 1 ) ) ) Tlist::down();
  if( !enabled( vcurrent ) )
  {
    vcurrent = i;
    vbeg_print = j;
  }
}

void Tlb_list::top( void )
{
  if( !vcount ) return;
  Tlist::top();
  while( !enabled( vcurrent ) && ( vcurrent < ( vcount - 1 ) ) ) Tlist::down();
}

void Tlb_list::bottom( void )
{
  if( !vcount ) return;
  Tlist::bottom();
  while( !enabled( vcurrent ) && vcurrent ) Tlist::up();
}

void Tlb_list::at( uint i )
{
  if( !vcount ) return;
  if( ( i < vcount ) && enabled( i ) ) Tlist::at( i );
}

void Tlb_list::gettxt( uint i, char *t )
{
  Tlb_item *p;

  if( ( i < vcount ) && ( ( p = (*items_ptr)[i] ) != NULL ) )
    item_str( p, t );
  else
    *t = 0;
}

void *Tlb_list::getptr( uint i )
{
  return (*items_ptr)[i]->data;
}

void Tlb_list::error( int error_code )
{
  exit( error_code );
}

static char *search = NULL;

static boolean text_filter( Tlist *list, uint i )
{
  char s[256];

  list->gettxt( i, s );
  return( strcmp( s, search ) == 0 );
}

uint Tlb_list::findft( char *t )
{
  search = t;
  return findf( text_filter );
}

void Tlb_list::add_title( char *data )
{
  add( data );
  ( (*items_ptr)[vcount - 1] )->flags = lbfTITLE;
}

void Tlb_list::add_blank( void )
{
  add( "" );
  ( (*items_ptr)[vcount - 1] )->flags = lbfDISABLED+lbfTITLE;
}

void Tlb_list::getdata( uint i, void *data )
{
  Tlb_item *p;

  if( i >= vcount ) return;
  p = (*items_ptr)[i];
  if( p == NULL ) return;
  item_data( p, data );
}

void Tlb_list::item_data( Tlb_item *p, void *data )
{
  memmove( data, p->data, data_size );
}

void Tlb_list::item_str( Tlb_item *p, char *s )
{
  strcpy( s, p->data+data_size );
}

void Tlb_list::check( uint i, boolean f )
{
  Tlb_item *p;

  if( i >= vcount ) return;
  p = (*items_ptr)[i];
  if( p != NULL )
    if( f )
      p->flags |= lbfCHECKED;
    else
      p->flags &= ~lbfCHECKED;
}

boolean Tlb_list::checked( uint i )
{
  Tlb_item *p;

  if( i >= vcount ) return 0;
  p = (*items_ptr)[i];
  if( p != NULL ) return ( p->flags & lbfCHECKED ) != 0;
  return 0;
}

void Tlb_list::set_enable( uint i, boolean f )
{
  Tlb_item *p;

  if( i >= vcount ) return;
  p = (*items_ptr)[i];
  if( p != NULL )
    if( f )
      p->flags &= ~lbfDISABLED;
    else
      p->flags |= lbfDISABLED;
}

boolean Tlb_list::enabled( uint i )
{
  Tlb_item *p;

  if( i >= vcount ) return 0;
  p = (*items_ptr)[i];
  if( p != NULL ) return ( p->flags & lbfDISABLED ) == 0;
  return 0;
}

void Tlb_list::set_comparator( Tlb_item_comparator _lb_item_comparator )
{
  lb_item_comparator = _lb_item_comparator;
}

//Tlb_list protected:

void Tlb_list::inc_count( void )
{
  Tlb_arr *n;
  uint cnt;

  cnt = vcount + 1;
  if( !cnt )
  {
    overflow = 1;
    return;
  }
  if( !( cnt & 0xFF ) )
  {
    n = ( Tlb_arr * ) REALLOC( items_ptr, ( ( cnt & ~0xFF ) + 0x100 ) * sizeof( Tlb_item * ) );
    if( n )
      items_ptr = n;
    else
    {
      overflow = 1;
      return;
    }
  }
  vcount = cnt;
}

void Tlb_list::dec_count( void )
{
  Tlb_arr *n;
  uint cnt;

  if( !vcount ) return;
  cnt = vcount - 1;
  if( !( vcount & 0xFF ) )
  {
    n = ( Tlb_arr * ) REALLOC( items_ptr, ( ( vcount & ~0xFF ) + 0x100 ) * sizeof( Tlb_item * ) );
    if( n )
      items_ptr = n;
    else
    {
      overflow = 1;
      return;
    }
  }
  vcount = cnt;
}

Tlb_item * Tlb_list::alloc_lb_item( char *data )
{
  Tlb_item *p;
  int sl, so;
  void *usr_data;

  usr_data = __ldata();
  so = 0;
  if( usr_data == NULL ) usr_data = data, so = data_size;
  sl = strlen( data + so );
  p = (Tlb_item *)MALLOC( 1 + data_size + sl + 1 );
  if( p != NULL )
  {
    p->flags = 0;
    if( data_size ) memmove( p->data, usr_data, data_size );
    memmove( p->data + data_size, data + so, sl + 1 );
    if( sl >= hsize )
    {
      if( sl > hsize )
      {
        hsize = sl;
        hmax_size = 0;
      }
      hmax_size++;
    }
  }
  return p;
}

void Tlb_list::free_lb_item( Tlb_item *p )
{
  uint n,i;
  int l;

  l = strlen( p->data + data_size );
  if( ( hsize > hmax_print ) && ( l == hsize ) )
  {
    hmax_size--;
    if( !hmax_size )
      for( hsize = i = 0; i < vcount; i++ )
      {
        n = strlen( ( (*items_ptr)[i] )->data + data_size );
        if( n >= hsize )
        {
          if( n > hsize )
          {
            hsize = n;
            hmax_size = 0;
          }
          hmax_size++;
        }
      }
  }
  if( lb_item_killer != NULL ) lb_item_killer( p->data );
  FREE( p );
}

void Tlb_list::flip( uint i )
{
  check( i, !checked( i ) );
}

void Tlb_list::multi_flip( uint from, uint to )
{
  uint i, min, max;

  if( from > to )
  {
    min = to;
    max = from - 1;
  }
  else
  {
    min = from + 1;
    max = to;
  }
  for( i = min; i <= max; i++ ) flip( i );
}


//Tlist_box publics:

Tlist_box::Tlist_box( uint &_data, int _xl, int _yl ):
  Titem( _xl + 2, _yl ),
  Tlb_list()
{
  init( _data );
}

Tlist_box::Tlist_box( uint &_data, int _xl, int _yl, Tlb_list *_list ):
  Titem( _xl + 2, _yl ),
  Tlb_list( _list )
{
  init( _data );
}

//Tlist_box protected:

void Tlist_box::draw( void )
{
  static char t[] = "|r. |n";
  Tlb_item *p;
  uint i, j;
  char ta;
  char s[256];

  for( i = 0, j = vbeg_print; i < vmax_print; i++ )
  {
    t[2] = (char) xl;
    if( j >= vcount )
      txt( t );
    else
    {
      p = (*items_ptr)[j++];
      ta = text_attr;
      if( ( i + vbeg_print ) == vcurrent )
        if( state( isSELECTED ) )
          text_attr = selected_attr;
        else
          text_attr = bold_attr;
      else
      {
        if( p->flags & lbfDISABLED ) text_attr = disabled_attr;
        if( p->flags & lbfTITLE ) text_attr = bold_attr;
      }
      if( p->flags & lbfCHECKED )
        txt( "|~" );
      else
        direct_txt( " " );
      item_str( p, s );
      if( hbeg_print > strlen( s ) )
        *s = 0;
      else
      {
        memmove( s, s + hbeg_print, hmax_print );
        s[hmax_print] = 0;
      }
      direct_txt( s );
      if( strlen( s ) < ( xl - 1 ) ) t[2] = (char) ( xl- strlen( s ) - 1 ); else t[2] = 0;
      txt( t );
      text_attr = ta;
    }
  }
}

void Tlist_box::event_handler( Tevent &ev )
{
  static boolean ctrl_down = 0;
  uint i;

  Titem::event_handler( ev );
  if( ( ev.code == evCOMMAND ) && ( ev.CMD_CODE == cmDLG_RESET ) && changed )
  {
    h_bar->update();
    v_bar->update();
    changed = 0;
  }
  if( state( isFOCUSED ) )
    switch( ev.code )
    {
      case evKEY_DOWN:
        if( ev.SCAN_CODE == scCTRL ) ctrl_down = 1; break;
      case evKEY_UP:
        if( ev.SCAN_CODE == scCTRL ) ctrl_down = 0; break;
      case evKEY_PRESS:
        i = vcurrent;
        switch( ev.ASCII )
        {
          case kUP:
            up(); break;
          case kDOWN:
            down(); break;
          case kPG_UP:
            pgup(); break;
          case kPG_DN:
            pgdn(); break;
          case kHOME:
            top(); break;
          case kEND:
            bottom(); break;
          case kSPACE:
            if( flags( lfMULTIPLY_SELECTION ) )
              if( ctrl_down )
              {
                flip( 0 );
                multi_flip( 0, vcount - 1 );
                item_acted = this;
              }
              else
              {
                flip( vcurrent );
                down();
              }
            break;
          default:
            return;
        }
        handled( ev ); redraw();
        item_acted = this;
        break;
#ifndef NOMOUSE
      case evMOUSE_DOWN:
        if( ev.INSIDE )
        {
          uint j = (uint) -1;
          do
          {
            ev.INSIDE = ( ev.LOCAL_Y >= 0 ) && ( ev.LOCAL_Y < vmax_print );
            if( ev.INSIDE || ( ev.code == evMOUSE_REP ) )
            {
              if( ev.LOCAL_Y >= 0 ) i = ev.LOCAL_Y; else i = 0;
              i = vbeg_print + i;
              if( !ev.INSIDE )
              {
                if( i > vcurrent ) down(); else up();
                i = vcurrent;
              }
              if( i >= vcount ) i = vcount - 1;
              if( ( j != i ) && enabled( i ) )
              {
                if( ( ev.BUTTON == 1 ) && flags( lfMULTIPLY_SELECTION ) )
                  if( ev.code == evMOUSE_DRAG )
                    multi_flip( vcurrent, i );
                  else
                    flip( i );
                vcurrent = i;
                redraw();
              }
              if( ev.CLICKS && flags( lfSTOP_MODAL ) &&
                  ( vbeg_print + ev.LOCAL_Y <= vcount ) )
              {
                stop( cmOK );
                break;
              }
              j = vcurrent;
            }
          }
          while( get_mouse( ev, evMOUSE_REP|evMOUSE_DRAG ) );
          item_acted = this;
        }
#endif
    }
}

void Tlist_box::ok_item( void )
{
  *dta = vcurrent;
}

//Tlist_box private:

void Tlist_box::init( uint &_data )
{
  set_flags( lfSTOP_MODAL, 1 );
  hmax_print = xl - 2;
  vmax_print = yl;
#ifndef NOMOUSE
  set_events_mask( evMOUSE_REP, 1 );
#endif
  dta = &_data;
  v_bar = NEW( Tvscroll_bar( vmax_print, vcount, vbeg_print ) );
    v_bar->set_flags( sfHANDLE_KEYBOARD, 0 );
    v_bar->max_print = &vmax_print;
  h_bar = NEW( Thscroll_bar( xl, hsize, hbeg_print ) );
    h_bar->set_flags( sfHANDLE_KEYBOARD, 1 );
    h_bar->max_print = &hmax_print;
  put_in( v_bar, xl, 0 );
  put_in( h_bar, 0, yl );
  top();
}

//PREFIXES

static uint lsize_ = 0;
static void *ldata_ = NULL;
static Tlb_item_killer lkiller_ = NULL;
static Tlb_item_comparator lcomparator_ = NULL;

/*
  Description:
    Specify list user data size. Call just before construct list box or
    combo box.
  Entry:
    size: sizeof( user_record ).
*/
void _lsize( uint size )
{
  lsize_ = size;
}

uint __lsize( void )
{
  uint result;

  result = lsize_;
  lsize_ = 0;
  return result;
}

/*
  Description:
    Specify user data. Call just before inserting a line in list box or in
    combo box. After that the list will hold not text only but given data as
    well. Before constructing the list or combo box use lsize to specify
    user data size.
  Entry:
    data - user data to insert in the list or combo.
*/
void _ldata( void *data )
{
  ldata_ = data;
}

void *__ldata( void )
{
  void *result;

  result = ldata_;
  ldata_ = NULL;
  return result;
}

/*
  Description:
    Specify list item comparator func. This function will be called when
    list is sorting allowing you to produce you own compare. If comparator
    not specified, list is sorted using standard alphabetical comparison.
  Entry:
    _comparator - address of the list item comparator function.
*/
void _litem_comparator( Tlb_item_comparator _comparator )
{
  lcomparator_ = _comparator;
}

Tlb_item_comparator __litem_comparator( void )
{
  Tlb_item_comparator result;

  result = lcomparator_;
  lcomparator_ = NULL;
  return result;
}

/*
  Description:
    Specify list item killer func. This function will be called when the
    list needs to free an item, allowing you to dispose some dynamic data
    in list items.
  Entry:
    _killer - address of the list item killer function.
*/
void _litem_killer( Tlb_item_killer _killer )
{
  lkiller_ = _killer;
}

Tlb_item_killer __litem_killer( void )
{
  Tlb_item_killer result;

  result = lkiller_;
  lkiller_ = NULL;
  return result;
}


//CONSTRUCTORS FOR USE WITH DIALOG BOXES

static void insert_list_box( char *t, Tlist_box *l )
{
  Tbox *b;

  l->v_bar->set_state( isHIDDEN, 0 );
  b = NEW( Tbox( t, l ) );
  b->resize( b->xl-1, b->yl );
  l->put_in( b, -1, -1 );
  hspace(); vspace();
  put_item( l, b->xl, b->yl - 1 );
  hspaces( -1 );
  return;
}

/*
  Description:
    Construct list box and insert it in the dialog box.
  Entry:
    t        - title, shortcut prefix '|~';
    data     - buffer that holds current selection;
    _xl, _yl - bounds of the list box.
  Exit:
    Return pointer to the list box.
*/
Tlist_box *list_box( char *t, uint &data, int _xl, int _yl )
{
  Tlist_box *l;

  l = NEW( Tlist_box( data, _xl, _yl ) );
  insert_list_box( t, l );
  return l;
}

/*
  Description:
    Construct list box and insert it in the dialog box.
  Entry:
    t        - title, shortcut prefix '|~';
    data     - buffer that holds current selection;
    _xl, _yl - bounds of the list box.
    list     - pointer to a pre-constructed list
  Exit:
    Return pointer to the list box.
*/
Tlist_box *list_box( char *t, uint &data, int _xl, int _yl, Tlb_list *list )
{
  Tlist_box *l;

  l = NEW( Tlist_box( data, _xl, _yl, list ) );
  insert_list_box( t, l );
  return l;
}

/*
  Description:
    Construct multiply selection list box and insert it in the dialog box.
  Entry:
    t        - title, shortcut prefix '|~';
    data     - buffer that holds current selection;
    _xl, _yl - bounds of the list box.
  Exit:
    Return pointer to the list box.
*/
Tlist_box *mslist_box( char *t, uint &data, int _xl, int _yl )
{
  Tlist_box *l;

  l = list_box( t, data, _xl, _yl );
  l->set_flags( lfSTOP_MODAL, 0 ); l->set_flags( lfMULTIPLY_SELECTION, 1 );
  return l;
}

/*
  Description:
    Construct multiply selection list box and insert it in the dialog box.
  Entry:
    t        - title, shortcut prefix '|~';
    data     - buffer that holds current selection;
    _xl, _yl - bounds of the list box.
    list     - pointer to a pre-constructed list
  Exit:
    Return pointer to the list box.
*/
Tlist_box *mslist_box( char *t, uint &data, int _xl, int _yl, Tlb_list *list )
{
  Tlist_box *l;

  l = list_box( t, data, _xl, _yl, list );
  l->set_flags( lfSTOP_MODAL, 0 ); l->set_flags( lfMULTIPLY_SELECTION, 1 );
  return l;
}
