{$R+}
PROGRAM VidModeDemo;
VAR
  VidMode : Byte;

  FUNCTION VideoMode : Byte;
  CONST
    BiosVidSvc = $10;         (* Bios Video Services Interrupt *)
    GetVidMode = $0F;         (* Bios Request for Get Video Mode *)
  TYPE
    RegRec = RECORD
               AX, BX, CX, DX : Integer;
               BP, SI, DI     : Integer;
               DS, ES, Flags  : Integer;
             END;
  VAR
    Registers   : RegRec;
  BEGIN
    Registers.AX := GetVidMode SHL 8;
    Intr(BiosVidSvc, Registers);
    VideoMode := Lo(registers.AX);
  END;                        (* VideoMode *)

BEGIN
  VidMode := VideoMode;
  IF VidMode = 7 THEN
    WriteLn('Using MONOCHROME monitor, 80x25 TEXT mode')
  ELSE
    BEGIN
      Write('Using Color/Graphics monitor, ');
      CASE VidMode OF
             0 : WriteLn('40x25 black-and-white TEXT mode');
             1 : WriteLn('40x25 color TEXT mode');
             2 : WriteLn('80x25 black-and-white TEXT mode');
             3 : WriteLn('80x25 color TEXT mode');
          4..6 : WriteLn('CGA graphics mode ',VidMode);
         8..10 : WriteLn('PCjr graphics mode ',VidMode);
         11,12 : WriteLn('UNKNOWN graphics mode ',VidMode);
        13..16 : WriteLn('EGA graphics mode ',VidMode);
      END;
  END;
END.