// TicView.cpp : implementation of the CTicView class
//

#include "stdafx.h"
#include "Tic.h"

#include "TicDoc.h"
#include "TicView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTicView

IMPLEMENT_DYNCREATE(CTicView, CView)

BEGIN_MESSAGE_MAP(CTicView, CView)
	//{{AFX_MSG_MAP(CTicView)
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTicView construction/destruction

CTicView::CTicView()
{
	//
	// Initialize the array of rectangles that form the game grid.
	//
	for (int i=0; i<5; i++) {
		for (int j=0; j<5; j++) {
			int x = (i * 70) + 10;
			int y = -(j * 70) - 10;
			m_rect[i][j].SetRect (x, y, x + 60, y - 60);
			m_rect[i][j].NormalizeRect ();
		}
	}
}

CTicView::~CTicView()
{
}

BOOL CTicView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CTicView drawing

void CTicView::OnDraw(CDC* pDC)
{
	CTicDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	//
	// Set the mapping mode to MM_LOENGLISH, where 1 unit = 0.01 inch.
	//
	pDC->SetMapMode (MM_LOENGLISH);

	//
	// Draw the playing grid.
	//
	for (int i=0; i<5; i++) {
		for (int j=0; j<5; j++) {
			pDC->Rectangle (m_rect[i][j]);
			BYTE bVal = pDoc->GetSquare (i, j);
			if (bVal == 1) // Draw an X
				DrawX (pDC, &m_rect[i][j]);
			else if (bVal == 2) // Draw an O
				DrawO (pDC, &m_rect[i][j]);
		}
	}
}

/////////////////////////////////////////////////////////////////////////////
// CTicView printing

BOOL CTicView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CTicView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CTicView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CTicView diagnostics

#ifdef _DEBUG
void CTicView::AssertValid() const
{
	CView::AssertValid();
}

void CTicView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CTicDoc* CTicView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CTicDoc)));
	return (CTicDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CTicView message handlers

void CTicView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	//
	// Get a pointer to the document.
	//
	CTicDoc* pDoc = GetDocument ();

	//
	// Get a DC and convert point to logical coordinates.
	//
	CClientDC dc (this);
	dc.SetMapMode (MM_LOENGLISH);
	dc.DPtoLP (&point);

	//
	// Hit test the grid and draw an X or O if appropriate.
	//
	BOOL bQuit = FALSE;
	for (int i=0; i<5 && !bQuit; i++) {
		for (int j=0; j<5  && !bQuit; j++) {
			if (m_rect[i][j].PtInRect (point)) {
				if (pDoc->GetSquare (i, j) == 0) {
					if (pDoc->IsItXsTurn ()) {
						pDoc->AddX (i, j);
						DrawX (&dc, &m_rect[i][j]);				
					}
					else {
						pDoc->AddO (i, j);
						DrawO (&dc, &m_rect[i][j]);				
					}
				}
				bQuit = TRUE;
			}
		}
	}

	//
	// Let the base class do its thing.
	//
	CView::OnLButtonDown(nFlags, point);
}

void CTicView::DrawX (CDC* pDC, CRect* pRect)
{
	//
	// Make a local copy of the rectangle and shrink it.
	//
	CRect rect;
	rect.CopyRect (pRect);
	rect.DeflateRect (10, 10);

	//
	// Create a red pen and use it to draw an X.
	//
	CPen pen (PS_SOLID, 10, RGB (255, 0, 0));
	CPen* pOldPen = pDC->SelectObject (&pen);

	pDC->MoveTo (rect.left, rect.top);
	pDC->LineTo (rect.right, rect.bottom);
	pDC->MoveTo (rect.left, rect.bottom);
	pDC->LineTo (rect.right, rect.top);

	pDC->SelectObject (pOldPen);
}

void CTicView::DrawO (CDC* pDC, CRect* pRect)
{
	//
	// Make a local copy of the rectangle and shrink it.
	//
	CRect rect;
	rect.CopyRect (pRect);
	rect.DeflateRect (10, 10);

	//
	// Create a blue pen and use it to draw an O.
	//
	CPen pen (PS_SOLID, 10, RGB (0, 0, 255));
	CPen* pOldPen = pDC->SelectObject (&pen);
	pDC->SelectStockObject (NULL_BRUSH);

	pDC->Ellipse (rect);

	pDC->SelectObject (pOldPen);
}
