
//
// npmciwnd.cpp
//

#include <windows.h>
#include <vfw.h>

#include "npupp.h"
#include "npapi.h"
#include "npmciwnd.h"


//
// Constructor
//
CMCIWnd::CMCIWnd ()
{
	hMCIWnd = hNavigatorWnd = NULL;
}


//
// Destructor
//
CMCIWnd::~CMCIWnd()
{
	if (hMCIWnd)
		MCIWndDestroy (hMCIWnd);
}


//
// GotFileName 
//
void CMCIWnd::GotFileName (const char* fname) 
{
	// Open the MCIWnd file

	if (hMCIWnd = MCIWndCreate (hNavigatorWnd, 0, NULL, fname))
	{
		char DeviceName[256];

		if (!MCIWndGetDevice (hMCIWnd, DeviceName, sizeof(DeviceName)))
			if (!strcmp (DeviceName, "AVIVideo"))
				MCIWndStep (hMCIWnd, 1);  // Step because of a bug in MCIWnd 
	}
}


//
// UpdateWindow 
//
void CMCIWnd::UpdateWindow (HWND hWnd) 
{
	RECT rect;

	SetWindowPos (hWnd, HWND_BOTTOM, 0,0,0,0, SWP_NOMOVE | SWP_NOSIZE);

	GetWindowRect (hWnd, &rect);
	InvalidateRect (hWnd, &rect, TRUE);

	::UpdateWindow (hWnd);
}






