/* MCI REXX Sample #3 */
/* Sample REXX Script */
/* this script shows you how to determine if a CD is in the drive and */
/* if one is in the drive, how to differentiate which disc has been   */
/* inserted.                                                          */
/*                                                                    */
/* Note: unfortunately, there is no current standard to retrieve      */
/* author information (such as titles/artists) etc. from the CD so we */
/* will retrieve the unique identifier for the disc and use this info */
/* to store author specific information.                              */


rc = RXFUNCADD('mciRxInit','MCIAPI','mciRxInit')
InitRC = mciRxInit()

/* Open the CD */

rc = mciRxSendString("open cdaudio alias supercd wait", 'Retst', '0', '0')
rc = mciRxSendString("status supercd media present wait", 'Retst', '0', '0')
If Retst <> 'TRUE' then
     do
     say 'Must have CD inserted to run this command file'
     say 'Please insert'
     rc = mciRxSendString("status supercd media present wait", 'Retst', '0', '0')

       do while Retst <> 'TRUE'
         rc = mciRxSendString("status supercd media present wait", 'Retst', '0', '0')
       End
     End

rc = mciRxSendString("info supercd id wait", 'Retst', '0', '0')
say 'The unique identifier for this CD is ' Retst 
say 'Use this information to save playlists and other setups'



rc = mciRxSendString("close supercd wait", 'Retst', '0', '0')
say 'Finished SuperCD artist setup'
exit


error:
   say 'Error' ErrRC 'at line' sigl ', sourceline:' sourceline(sigl)
   say 'Terminating'
   mciRxSendString("close supercd wait", 'Retst', '0', '0')
   mciRxExit()               /* Tell the DLL we're going away */
   exit ErrRC                /* exit, tell caller things went poorly */

halt:
/*
 * Close all device alias's, in case we previously killed
 * this batch file in the same process.
 */
   say 'Terminating'
   mciRxSendString("close supercd wait", 'Retst', '0', '0')
   mciRxExit()               /* Tell the DLL we're going away */

exit

