;*****************************************************************************
;
; TEE utility for DOS
;
;*****************************************************************************

STDIN       equ       0
STDOUT      equ       1
BLOCKSIZE   equ     512

code    segment
        assume  cs:code, ds:code
        org     100h

Begin:
        cld                             ;Get ready
        mov     si,81h

FindChar:
        lodsb                           ;Find the file name entered on
        cmp     al,20h                  ;the command line
        je      FindChar
        cmp     al,09h
        je      FindChar

        cmp     al,0Dh                  ;Error if no file name
        je      SyntaxError

        mov     dx,si                   ;Save the file name's address
        dec     dx

        mov     di,si                   ;Find the end of the command line
        mov     al,0Dh
        mov     cx,0FFFFh
        repne   scasb
        mov     byte ptr [di-1],0       ;Mark it with a 0

        mov     ah,3Ch                  ;Open the output file
        xor     cx,cx
        int     21h

        jc      OpenError               ;Error if open failed

        mov     Handle,ax               ;Save the file handle
        jmp     short Reset             ;Continue
;
; Error handlers.
;
SyntaxError:
        mov     dx,offset ErrMsg1
        jmp     short Error1

OpenError:
        mov     dx,offset ErrMsg2

Error1:
        mov     ah,09h
        int     21h
        ret
;
; Read/write loop.
;
Reset:
        xor     di,di                   ;Initialize DI

IOLoop:
        mov     ah,3Fh                  ;Read a character from STDIN
        mov     bx,STDIN
        mov     cx,1
        mov     dx,offset Buffer
        add     dx,di
        int     21h

        or      ax,ax                   ;Flush and exit if no more data
        jz      Flush

        mov     ah,40h                  ;Write the character to STDOUT
        mov     bx,STDOUT
        mov     cx,1
        mov     dx,offset Buffer
        add     dx,di
        int     21h

        inc     di                      ;Increment counter and loop if
        cmp     di,BLOCKSIZE            ;the buffer isn't full
        jne     IOLoop

Flush:
        mov     ah,40h                  ;Flush the buffer to disk
        mov     bx,Handle
        mov     cx,di
        jcxz    CloseAndExit            ;Exit now if CX == 0
        mov     dx,offset Buffer
        int     21h

        jc      WriteError              ;Error if carry set on return

        cmp     ax,di                   ;Error if AX != DI (disk full)
        jne     DiskFull

        cmp     di,BLOCKSIZE            ;Loop back for more if the buffer
        je      Reset                   ;was full

CloseAndExit:
        mov     ah,3Eh                  ;Close the output file and exit
        mov     bx,Handle
        int     21h
        ret
;
; More error handlers.
;
WriteError:
        mov     dx,offset ErrMsg3
        jmp     short Error2

DiskFull:
        mov     dx,offset ErrMsg4

Error2:
        mov     ah,09h
        int     21h
        jmp     CloseAndExit

;////////////////////////////////////////////////////////////////////////////

ErrMsg1 db      "Syntax: command | TEE filename$"
ErrMsg2 db      "Unable to create output file$"
ErrMsg3 db      "I/O error on write$"
ErrMsg4 db      "Disk full$"

Handle  dw      ?                       ;Handle for output file
Buffer  label   byte                    ;I/O buffer

;////////////////////////////////////////////////////////////////////////////

code    ends
        end     Begin
