**********************************************************************
* FUNCTION Opendbs                                 FPW 2.6 or VFP 1.0
* This function opens all databases in the requested directory.
* Sample call: =opendbs("x:\deptapps\bss")
**********************************************************************
FUNCTION Opendbs
PARAMETER lcDir
lcDefault = SET("DEFAULT")+SYS(2003)  && Save the current directory
IF !EMPTY(lcDir)                      && If a directory name was passed
   SET DEFAULT TO (lcDir)             && Change to the passed directory
ENDIF
lnError = ADIR(laDBs,"*.dbf")         && Build a list of DBF files
FOR lnCount = 1 TO ALEN(laDBs,1)      && For every file in the list
  lnAt = AT(".",laDBs[lnCount,1]) - 1 && Calc the length of the
                                      && filename portion only
  lcAlias = LEFT(laDBs[lnCount,1],lnAt)  && Extract the filename
  IF !USED(lcAlias)                   && If that alias is not open
     USE (laDBs[lnCount,1]) IN 0      && Open the table in a new area
     WAIT WINDOW RTRIM(laDBs[lnCount,1])+" opened" NOWAIT
  ENDIF
ENDFOR
SET DEFAULT TO (lcDefault)            && Change back to the saved dir
WAIT CLEAR
RETURN
