*********************************************************************
* FUNCTION Isdir(cDir)                        FoxPro for Windows 2.6
* Returns .T. if the passed parameter is a valid directory, where
* valid is defined as acceptable to the SET DEFAULT TO command.
*********************************************************************
FUNCTION Isdir
PARAMETER cDir
PRIVATE lError, cOldErr, cOldDefa
cOldDefa = SYS(5)+SYS(2003)                 && Save old set default
cOldErr = ON("ERROR")                       && Save old on error
lError = .F.                                && Initialize to false
ON ERROR lError = .T.                       && Set up error handler
*
* Attempt to set default to the directory.  If the directory does
* not exist, or if the parameter passed causes an error, lError will
* be set to .T. by the ON ERROR handler.  Otherwise, the directory
* must be valid.
*
SET DEFAULT TO (cDir)                       && Attempt set default

ON ERROR &cOldErr               && Restore original error handler
SET DEFAULT TO (cOldDefa)       && Restore original set default
RETURN IIF(lError, .F., .T.)    && Return .T. if no error occurred
