// dynarray.h RHS 1/7/92

#if !defined(DYNARRAY_H)
#define DYNARRAY_H

#include<stdio.h>
#include<memory.h>

template<class TYPE>
class DynArray
    {
    TYPE   *TArray;
    int size;
    int num;

public:
    void Init(int n)
        {
        TArray = new TYPE[size = n];    
        num = 0;
        }
    DynArray(int n)
        {
        Init(n);
        }
    DynArray(void)
        {
        TArray = NULL;
        num = 0;
        size = 0;
        }
    ~DynArray()                 {   delete[] TArray;    }
    TYPE& operator[](int i)     {   return TArray[i];   }
    NumItems(void)              {   return size;        }
    void ReSize(int newsize);
    void Delete(TYPE t);
    void Add(TYPE t);
    };

template<class TYPE>
void DynArray<TYPE>::Add(TYPE t)
    {
    if(num == size)
        ReSize(size+10);
    TArray[num++] = t;
    }

template<class TYPE>
void DynArray<TYPE>::ReSize(int newsize)
    {
    if(newsize == size)
        return;

    TYPE *temp = new TYPE[newsize];
    if(!temp)
        return;
    memcpy(temp,TArray,
        ( (newsize > size) ? (size*sizeof(TYPE)) : (newsize*sizeof(TYPE)) ));
    delete TArray;
    TArray = temp;
    size = newsize;
    }
        
#endif


