        title   ATOI - ASCII to integer
        page    55,132

; ATOI.ASM --- Convert ASCII string to 16-bit decimal integer.
;
; Copyright (C) 1989 Ray Duncan
; 
; Call with:    DS:SI = address of string,
;               where 'string' is in the form
;                  [whitespace][sign][digits]
;
; Returns:      AX    = result
;               DS:SI = address+1 of terminator 
;
; Destroys:     Nothing
;
; Like the C runtime library function 'atoi', this routine gives no 
; warning of overflow, and terminates on the first invalid character.

blank   equ     20h             ; ASCII blank character
tab     equ     09h             ; ASCII tab character

_TEXT   segment word public 'CODE'

        assume  cs:_TEXT

        public  atoi
atoi    proc    near

        push    bx                      ; save registers
        push    cx
        push    dx

        xor     bx,bx                   ; initialize forming answer
        xor     cx,cx                   ; initialize sign flag

atoi1:  lodsb                           ; scan off whitespace
        cmp     al,blank                ; ignore leading blanks
        je      atoi1
        cmp     al,tab                  ; ignore leading tabs
        je      atoi1

        cmp     al,'+'                  ; if + sign, proceed
        je      atoi2
        cmp     al,'-'                  ; is it - sign?
        jne     atoi3                   ; no, test if numeric
        dec     cx                      ; was - sign, set flag
                                        ; for negative result

atoi2:  lodsb                           ; get next character

atoi3:  cmp     al,'0'                  ; is character valid?
        jb      atoi4                   ; jump if not '0' to '9'
        cmp     al,'9'
        ja      atoi4                   ; jump if not '0' to '9'

        and     ax,0fh                  ; isolate lower four bits

        xchg    bx,ax                   ; previous answer x 10
        mov     dx,10
        mul     dx

        add     bx,ax                   ; add this digit

        jmp     atoi2                   ; convert next digit

atoi4:  mov     ax,bx                   ; put result into AX
        jcxz    atoi5                   ; jump if sign flag clear
        neg     ax                      ; make result negative

atoi5:  pop     dx                      ; restore registers
        pop     cx
        pop     bx
        ret                             ; back to caller

atoi    endp

_TEXT   ends

        end
