***********************************************************************
* DEL1.PRG                                               FoxPro 1.02
* Delete all files specified by a wildcard expression.
*
* Example: DO Del WITH "c:\*.bak"
***********************************************************************
PROCEDURE DEL
PARAMETERS mWild
PRIVATE mPath, mFile

  mPath = LEFT( mWild, RAT("\",mWild) )    && Extract path
  IF ("" = mPath .AND. AT(":",mWild) <> 0) && If drive is specified
    RETURN                                 && Without a full path
  ENDIF                                    && Simply return
                                           && Otherwise
  mFile = SYS( 2000, mWild )               && Find first matching file.
  DO WHILE ! EMPTY( mFile )                && Was a matching file found?
     ERASE ( mPath+mFile )                 &&    Yes, delete it.
     mFile = SYS( 2000, mWild, 1)          &&    Find next matching file.
  ENDDO                                    && Repeat process.

RETURN
