// VECTORS.CPP
// Definitions of Member Functions for Vector Class
// Copyright (C) 1991 Ziff Davis Communications
// PC Magazine * Ray Duncan

#include <math.h>
#include <iostream.h>
#include "vectors.h"


// display magnitude and direction (in degrees) of vector
void VECTOR::display(void)
{
    cout << "magnitude=" << magnitude << " " ;
    cout << "direction=" << rad2deg(direction) << " " ;
}


// initialize magnitude and direction of vector
void VECTOR::set(double magMsg, double dirMsg)
{
    direction = deg2rad(dirMsg);            // initialize direction
    magnitude = magMsg;                     // initialize magnitude
}


// add another vector's magnitude and direction to this vector
void VECTOR::add(double magMsg, double dirMsg)
{
    double angle;                           // scratch storage

    dirMsg = deg2rad(dirMsg);               // convert argument to radians
    angle = dirMsg - direction;             // find angle between vectors

    if (angle == pi)                        // special handling to avoid
    {                                       // overflow for angle=180
        direction = magnitude > magMsg ? direction : dirMsg;
        magnitude = fabs(magnitude - magMsg);
        return;
    }

    if ((magnitude == 0) && (magMsg == 0))  // special handling to avoid
    {                                       // divide by zero exception
        magnitude = 0;                      // if both vectors have 
        direction = 0;                      // zero magnitude
        return;
    }
                                            // calculate resultant vector
    magnitude = sqrt((magnitude * magnitude) + (magMsg * magMsg) +
                     (2 * magnitude * magMsg * cos(angle)));
    direction = direction + asin(((magMsg * sin(angle))/magnitude));
    return;                                 
}


// private member function to convert degress to radians
double VECTOR::deg2rad(double degrees)
{
    return ((degrees * 2 * pi)/360);
}


// private member function to convert radians to degrees
double VECTOR::rad2deg(double radians)
{
    return ((radians * 360)/(2 * pi));
}
