program mdp4;

{Program to accompany article in issue #10 of the Pascal NewsLetter.        }
{Author: Mitch Davis, (3:634/384.6) +61-3-890-2062.                         }

{Reads up to 100 lines from a file specified on the command line, then lets }
{you scroll through it using the +/- keys, and q to quit.  Note this program}
{works by actually reading in the data from the file into a fixed-size array}

uses crt;

const ScreenLen:integer = 24;
      MaxLines  = 100;
      WinTop:integer = 1;

var line:array [1..MaxLines] of string; {This takes 25600 bytes}
    LineCount:integer; {Note must be integer not word}
    loop:byte;
    ch:char;
    f:text;

  function Min (a,b:word):word;

  {returns the smaller of the two parameters}

  begin
    if a < b then Min := a else Min := b;
  end;

  procedure PrLn (var s:string);

  {prints a line truncated to 79 characters - ensures that long lines }
  {don't spoil the layout of the display                              }

  begin
    writeln (copy (s,1,79));
  end;

begin
  {Read in the file}
  write ('Reading...');
  assign (f,paramstr (1));
  reset (f);
  LineCount := 0;
  while not (eof (f) or (LineCount = MaxLines)) do begin
    inc (LineCount);
    readln (f,line [LineCount]);
  end;
  close (f);

  {Draw the initial screen}
  clrscr;
  for loop := 1 to min (ScreenLen,LineCount-WinTop+1) do prLn (line [loop]);
  write ('            Use ''+'' to move forward, ''-'' to move back.  ''q'' to quit.');
  repeat
    ch := readkey;
    case ch of
      '-':if WinTop > 1 then begin
            dec (WinTop);
            gotoxy (1,ScreenLen);
            DelLine;
            gotoxy (1,1);
            InsLine;
            PrLn (Line[WinTop]);
          end;
      '+':if WinTop < LineCount-ScreenLen+1 then begin
            inc (WinTop);
            gotoxy (1,1);
            DelLine;
            gotoxy (1,ScreenLen);
            InsLine;
            PrLn (line[WinTop+ScreenLen-1]);
          end;
      'q':;
      else write (#7);
    end;
    gotoxy (1,ScreenLen+1); write (WinTop:5,'/',LineCount);
  until ch = 'q';
end.
