//******************************************************************
// This program demonstrates the use of the CDONTS.NewMail COM object.
// The CDONTS.NewMail object was created by Microsoft to make
// sending email easy. This object is distributed with IIS, so
// if you are using IIS as your webserver and you want to use it to
// send email you can take a look at this program.
// As you can see using the CDONTS object is very simple, just
// create an instance, set a few properties, call the "send" method,
// and then dispose of the instance.
// NOTE: After you call "send" the instance is invalidated, so don't
//       try calling "send" multiple times with the same instance.
//******************************************************************
program cdonts;
const
   NORMAL = 1;
   //LOW = 0;
   //HIGH = 2;
var
   objMail : object;
   strFrom, strTo, strSubject, strBody : string;
begin
   //Gather information about the message
   write('Enter email address of person to receive this message');
   readln(strTo);
   write('Enter email address of person sending this message');
   readln(strFrom);
   write('Enter subject of this message');
   readln(strSubject);
   write('Enter body of the message');
   readln(strBody);

   //Send the message
   objMail := CreateObject('CDONTS.NewMail');
   objMail.from := strFrom;
   objMail.('to') := strTo;
   objMail.subject := strSubject;
   objMail.Body := strBody;
   objMail.Importance := NORMAL;
   objMail.Send( , , , , );
   dispose(objMail);

   //NOTE: You don't have to set properties to send a message you can
   // do everything in the call to "send", so in the example above
   // the message could have been sent as follows
   (*
   //Send the message
   objMail := CreateObject('CDONTS.NewMail');
   objMail.Send(objFrom , objTo, objSubject, objBody, NORMAL);
   dispose(objMail);
   *)
end.
