program primes(input, output);
type
    PrimeList = packed list of integer;
var
    primes : PrimeList;
    num, i, candidate : integer;

    function IsPrime : boolean;
    var
       i, x : integer;
    begin
       for i := 1 to length(primes) do
          begin
             x := primes[i];
             if candidate mod x = 0 then
                exit(false);
             if primes[i] > trunc(sqrt(candidate)) then
                exit(true)
          end;
       writeln('Overrun');
    end;

    procedure GenPrime;
    begin
       repeat
          candidate := candidate + 2;
          if IsPrime then
             begin
                writeln(candidate);
                insert(candidate, primes, length(primes)+1);
                exit
             end
       until candidate = maxint;
       writeln('Error')
    end;

begin
    write('Enter number of primes to generate ');
    readln(num);
    if (num<3) or (num > 10000) then
       begin
          writeln('primes must be between 3 and 10000');
          exit
       end;
    new(primes);
    insert(2, primes, 1);
    insert(3, primes, 2);
    insert(5, primes, 3);
    writeln(2);
    writeln(3);
    writeln(5);
    candidate := 5;
    for i := 4 to num do
       GenPrime;
    dispose(primes);
end.
