program hex(inf, out);
const
   per_line = 16;
var
   inf : file of char;
   out : text;
   line : string;
   address : integer;

   function printable(c : char) : boolean;
   begin
      if (c >= ' ') and (c <= '~') then
         printable := true
      else
         printable := false
   end;

   procedure readline;
   var
      i : integer;
      c : char;
   begin
      line := "";
      for i := 1 to per_line do
          begin
              if eof(inf) then
                  exit;
              read(inf, c);
              line := line + c;
          end
   end;

   procedure writeline;
   var
      i : integer;
      s : string;
      c : char;

      function prefix(s : string; len : integer) : string;
      var
         i : integer;
      begin
         for i := 1 to len-length(s) do
             s := '0' + s;
         exit(s)
      end;

   begin
      s := prefix(hex(address), 8);
      write(out, s:4, ':');
      for i := 1 to per_line do
         if i <= length(line) then
            begin
               s := hex(ord(line[i]));
               s := prefix(s, 2);
               write(out, s:3);
               if i = 8 then
                  write(out, ' ');
            end
         else
            write(out, ' ':3);

      write(out, " : ");

      for i := 1 to length(line) do
         begin
            c := line[i];
            if printable(c) then
               write(out, c)
            else
               write(out, '.');
            if i = 8 then
               write(out, ' ')
         end;
      writeln(out);
      inc(address, length(line))
   end;

begin
   reset(inf);
   rewrite(out);
   address := 0;
   while not eof(inf) do
      begin
          readline;
          writeline
      end
end.
