/*
	heard.h -- Structure definitions for nodes heard

  Poor Man's Packet (PMP)
  Copyright (c) 1991 by Andrew C. Payne    All Rights Reserved.

  Permission to use, copy, modify, and distribute this software and its
  documentation without fee for NON-COMMERCIAL AMATEUR RADIO USE ONLY is hereby
  granted, provided that the above copyright notice appear in all copies.
  The author makes no representations about the suitability of this software
  for any purpose.  It is provided "as is" without express or implied warranty.
*/

/* MHEARD structures and defines */

#define MAXID	40	/* max length of broadcast ID */
#define MAXHEARD 19	/* maximum stations in mheard list */

struct mheard {
	struct ax25_addr	call;		/* callsign of node */
	time_t			last;		/* time last heard */
	long			count;		/* # packets rec'd */
	long			bytes;		/* # bytes sent */
	byte			flags;		/* node flags */
	byte			id[MAXID];	/* node ID */
};

#define HEARD_DIRECT	1	/* heard direct */
#define HEARD_DIGI	2	/* heard digipeating */
#define HEARD_IP	4	/* heard w/ TCP/IP */
#define HEARD_NETROM	8	/* heard w/ NET/ROM */
#define HEARD_INFO	16	/* heard w/ any info packet */

