{ GMOUSCUR.INC is an include file that defines several graphics     }
{    mouse cursor patterns. All are typed constants.                }
{ This file also contains an event handler called by the mouse      }
{    device driver, and a global event record variable 'theEvents'  }
{ ----------------------------------------------------------------- }

{$F+}                { Force the including program to use far calls }

TYPE   eventRec = record                       { mouse event record }
           flag, button, col, row : WORD;
       END;
       gCursPtr = ^gCurs;                 { pointer to cursor image }
       gCurs = ARRAY [1..32] OF WORD;          { cursor image array }
       gCursRec = record               { graphics cursor descriptor }
           image      : gCursPtr;
           hotX, hotY : WORD;
       END;

{ Check mark image }
CONST  checkIm : gCurs = ($FFF0, $FFE0, $FFC0, $FF81, { screen mask }
                          $FF03, $0607, $000F, $001F,
                          $C03F, $F07F, $FFFF, $FFFF,
                          $FFFF, $FFFF, $FFFF, $FFFF,
                          $0000, $0006, $000C, $0018, { cursor mask }
                          $0030, $0060, $70C0, $1D80,
                          $0700, $0000, $0000, $0000,
                          $0000, $0000, $0000, $0000);

{ Left arrow image }
       LArrIm  : gCurs = ($FE1F, $F01F, $0000, $0000, { screen mask }
                          $0000, $F01F, $FE1F, $FFFF,
                          $FFFF, $FFFF, $FFFF, $FFFF,
                          $FFFF, $FFFF, $FFFF, $FFFF,
                          $0000, $00C0, $07C0, $7FFE, { cursor mask }
                          $07C0, $00C0, $0000, $0000,
                          $0000, $0000, $0000, $0000,
                          $0000, $0000, $0000, $0000);

{ Cross image }
       crossIm : gCurs = ($FC3F, $FC3F, $FC3F, $0000, { screen mask }
                          $0000, $0000, $FC3F, $FC3F,
                          $FC3F, $FFFF, $FFFF, $FFFF,
                          $FFFF, $FFFF, $FFFF, $FFFF,
                          $0000, $0180, $0180, $0180, { cursor mask }
                          $7FFE, $0180, $0180, $0180,
                          $0000, $0000, $0000, $0000,
                          $0000, $0000, $0000, $0000);

{ Pointing hand image }
       handIm  : gCurs = ($E1FF, $E1FF, $E1FF, $E1FF, { screen mask }
                          $E1FF, $E000, $E000, $E000,
                          $0000, $0000, $0000, $0000,
                          $0000, $0000, $0000, $0000,
                          $1E00, $1200, $1200, $1200, { cursor mask }
                          $1200, $13FF, $1249, $1249,
                          $1249, $9001, $9001, $9001,
                          $8001, $8001, $8001, $FFFF);

{ I-beam image }
       iBeamIm : gCurs = ($FFFF, $FFFF, $FFFF, $FFFF, { screen mask }
                          $FFFF, $FFFF, $FFFF, $FFFF,
                          $FFFF, $FFFF, $FFFF, $FFFF,
                          $FFFF, $FFFF, $FFFF, $FFFF,
                          $F00F, $0C30, $0240, $0240, { cursor mask }
                          $0180, $0180, $0180, $0180,
                          $0180, $0180, $0180, $0180,
                          $0240, $0240, $0C30, $F00F);

{ Graphics cursors }
       check : gCursRec = (image : nil; hotX : 6; hotY : 7);
       arrow : gCursRec = (image : nil; hotX : 0; hotY : 3);
       cross : gCursRec = (image : nil; hotX : 7; hotY : 4);
       hand  : gCursRec = (image : nil; hotX : 5; hotY : 0);
       iBeam : gCursRec = (image : nil; hotX : 7; hotY : 7);
{ ----------------------------------------------------------------- }

VAR    theEvents : eventRec;                      { global variable }

PROCEDURE EventHandler
  (Flags, CS, AX, BX, CX, DX, SI, DI, DS, ES, BP : WORD);

     { Mouse event handler called by device driver }

INTERRUPT;

Begin
  theEvents.flag   := AX;
  theEvents.button := BX;
  theEvents.col    := CX;
  theEvents.row    := DX;

  inline (        { Exit processing for far return to device driver }
    $8B/$E5/   { MOV  SP,BP }
    $5D/       { POP  BP }
    $07/       { POP  ES }
    $1F/       { POP  DS }
    $5F/       { POP  DI }
    $5E/       { POP  SI }
    $5A/       { POP  DX }
    $59/       { POP  CX }
    $5B/       { POP  BX }
    $58/       { POP  AX }
    $CB );     { RETF    }
END;
{ --------------------------- }

PROCEDURE InitGCurs;

     { Initialize pointers in graphics cursor descriptors }
     { Pointers can only be initialized at run time }

BEGIN
  check.image := @checkIm;
  arrow.image := @LArrIm;
  cross.image := @crossIm;
  hand.image  := @handIm;
  iBeam.image := @iBeamIm;
END;

{ End of gmouscur.inc }
