//#define DELAY 10000
//#define RATE  10
#include "siren.h"

void siren0(unsigned int delays, unsigned int rate );
void siren1(unsigned int delays, unsigned int rate );
void siren2(unsigned int delays );
void siren3(unsigned int delays );
void frequency(int freq, unsigned int delays );


void siren(int i, unsigned int delays, unsigned int rate  )
{
	switch (i) {
		case 0:
			siren0(delays, rate );
			break;
		case 1:
			siren1(delays, rate );
			break;
		case 2:
			siren2(delays);
			break;
		case 3:
			siren3(delays);
			break;
	}
};

void siren0(unsigned int delays, unsigned int rate )
{
  unsigned i,freq;
  union {
	long	divisior;
	unsigned char c[2];
  } count;
  unsigned char p;

	 p=inportb (97);
	 outportb(97,p | 3 );
	 for (freq=1000; freq<3000; freq +=rate ) {
		count.divisior = 1193280 / freq;
		outportb ( 67, 182);
		outportb ( 66, count.c[0]);
		outportb ( 66, count.c[1]);
//		for (i=0; i<delays; ++i ) ;
		delay ( delays / 1000);
	}

	 for (	; freq> 1000; freq -=rate ) {
		count.divisior = 1193280 / freq;
		outportb ( 67, 182);
		outportb ( 66, count.c[0]);
		outportb ( 66, count.c[1]);
//		for (i=0; i<delays; ++i ) ;
		delay ( delays / 1000);
	}
	outportb (97,p);
}


void siren1(unsigned int delays, unsigned int rate)
// laser blaster
{
  unsigned i,freq;
  union {
	long	divisior;
	unsigned char c[2];
  } count;
  unsigned char p;

	 p=inportb (97);
	 outportb(97,p | 3 );
	 for (freq=3000;freq>1000; freq -=rate ) {
		count.divisior = 1193280 / freq;
		outportb ( 67, 182);
		outportb ( 66, count.c[0]);
		outportb ( 66, count.c[1]);
//		for (i=0; i<delays; ++i ) ;
		delay ( delays / 1000);
	}
	outportb (97,p);
}

void siren2(unsigned int delays )
// random sound , continue
{
  int freq;
	do {
		do {
		freq = rand();
		} while (freq >5000);
		frequency ( freq , delays );
	} while ( !kbhit());
}

void siren3(unsigned int delays )
//  random sound , not continue
{
  int freq;
		do {
		freq = rand();
		} while (freq >5000);
		frequency ( freq , delays );
}


void frequency(int freq, unsigned int delays )
{
  unsigned i;
  union {
	long	divisior;
	unsigned char c[2];
  } count;
  unsigned char p;

	count.divisior = 1193280  / freq;
	outportb ( 67, 182);
	outportb ( 66, count.c[0]);
	outportb ( 66, count.c[1]);

	p=inportb (97);
	outportb (97,p | 3 );

 //	for (i=0; i<delays; ++i ) ;
	delay ( delays / 200);

	outportb (97,p);
}