/***************************************************************************
 *     EMSKILL vers 1.1, DOS                                               *
 *     Releases EMS memory by handle                                       *
 *     12/30/89                                                            *
 *     by James W. Birdsall                                                *
 *                                                                         *
 *     compiles under Turbo C 2.0                                          *
 *                                                                         *
 *   Usage: EMSKILL handle [handle handle ...]                             *
 *   Releases EMS memory associated with each handle specified on the      *
 *   command line. Compatible with all versions of LIM EMS specification   *
 *   3.0 and greater (specifically 3.0, 3.2, and 4.0).                     *
 *                                                                         *
 *   WARNING: THIS PROGRAM CAN KILL EMS MEMORY CURRENTLY IN USE BY ANOTHER *
 *            PROGRAM, SUCH AS A DISK CACHE OR A RAMDISK. BE CERTAIN THAT  *
 *            THE HANDLE YOU INTEND TO KILL DOES NOT BELONG TO SUCH A      *
 *            PROGRAM. EMSKILL WILL NOT ALLOW HANDLE 0 (THE OS HANDLE) TO  *
 *            BE KILLED.                                                   *
 *                                                                         *
 ***************************************************************************/


#include <stdio.h>
#include <io.h>
#include <dos.h>



#define VERSION 1.1



char copyright[] = "Copyright (c) 1989 James W. Birdsall. All Rights Reserved";



int checkEMM(void);



/***************************************************************************
 *     FUNCTION MAIN                                                       *
 ***************************************************************************/
main(int argc, char *argv[])
{
   int loop;
   int handle;
   union REGS r;

   /* if no handles or invalid handle, print usage message and exit */
   for(loop = 1; loop < argc; loop++) {
      if (atoi(argv[loop]) == 0) {
         break;
         }
      }
   if ((loop != argc) || (argc < 2)) {
      printf("\nEMSKILL vers %.1f by James W. Birdsall\n", VERSION);
      printf("   Releases EMS memory by handle.\n");
      printf("   Usage: EMSKILL handle [handle handle ...]\n");
      printf("     handle   number of the EMS handle to be released.\n");
      printf("\n");
      printf("   WARNING: THIS PROGRAM CAN KILL EMS MEMORY CURRENTLY IN\n");
      printf("            USE BY ANOTHER PROGRAM, SUCH AS A DISK CACHE OR\n");
      printf("            A RAMDISK. BE CERTAIN THAT THE HANDLE YOU INTEND\n");
      printf("            TO KILL DOES NOT BELONG TO SUCH A PROGRAM.\n");
      printf("            EMSKILL WILL NOT ALLOW HANDLE 0 (THE OS HANDLE)\n");
      printf("            TO BE KILLED.\n\n");
      exit(3);
      }

   /* check for functioning EMM */
   if (checkEMM() != 1) {
      printf("EMS manager not present or malfunctioning.\n");
      exit(3);
      }
   /* check version */
   r.h.ah = 0x46;
   int86(0x67, &r, &r);
   if (r.h.ah != 0) {
      printf("Error 0x%x talking to EMS manager.\n");
      exit(3);
      }
   if ((r.h.al >> 4) < 3) {
      printf("EMSKILL requires LIM EMS version 3.0 or greater.\n");
      exit(2);
      }

   /* loop through arguments */
   for(loop = 1; loop < argc; loop++) {
      /* get handle number, try to release */
      handle = atoi(argv[loop]);
      r.h.ah = 0x45;
      r.x.dx = handle;
      int86(0x67, &r, &r);
      /* print result */
      if (r.h.ah != 0) {
         printf("Error 0x%x%s releasing handle %d.\n", r.h.ah,
                      ((r.h.ah == 0x83) ? " (invalid handle)" : ""), handle);
         }
        else {
         printf("Handle %d released OK.\n", handle);
         }
      }

   exit(0);
} /* end of function main */



/***************************************************************************
 *     FUNCTION CHECKEMM                                                   *
 *   Checks for function EMM. 1 = OK, 0 = error                            *
 ***************************************************************************/
int checkEMM(void)
{
   FILE *tempfile;
   int temphandle;

   /* check if EMM is present */
   if ((tempfile = fopen("EMMXXXX0","rb")) == NULL)
      return 0;
   /* make sure we've found a device and not a file */
   temphandle = fileno(tempfile);
   if ((ioctl(temphandle, 0) & 0x80) != 0x80)
      return 0;
   /* check status of EMM */
   if (ioctl(temphandle, 7) <= 0)
      return 0;
   /* close and return */
   fclose(tempfile);
   return 1;
} /* end of function checkEMM */


/* end of file EMSKILL.C */