::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
:: RESETUP.BAT - Batchfile to re-setup a corrupted database for Yarn
::
@echo off
if not "%1" == "" goto help
:: the env.vars. HOME and YARN have to be set for import.exe !
if "%yarn%" == "" goto help
if "%home%" == "" goto help

:: some more env.vars. to be used
set resend=%yarn%\resend
set oldtmp=%tmp%
if "%tmp%" == "" set tmp=%yarn%\temp

:: make directory %resend% and %tmp% if neccessary
mkdir %tmp% >& nul
mkdir %resend% >& nul
cdd %resend%

:: we move all database files into a separate directory to reimport them
move %yarn%\news\*. %resend%\*.*

:: Now we're deleting all relevant infofiles of Yarn
if exist %yarn%\*.pag del %yarn%\*.pag > nul
if exist %yarn%\*.dir del %yarn%\*.dir > nul
if exist %yarn%\overview\*.0 del %yarn%\overview\*.0 > nul
:: uncomment, if you wish to forget which newsgroups you've subscribed to
rem if exist %home%\yarn\newsrc del %home%\yarn\newsrc > nul
:: You may uncomment, if you wish to forget what msgs. are read
rem if exist %home%\yarn\readart.pag del %home%\yarn\readart.pag > nul
rem if exist %home%\yarn\readart.dir del %home%\yarn\readart.dir > nul

:: now we resend each of the old database files
for %%a in (*.*) do call resend.bat %%a
cdd %yarn%
if not exist %resend%\*.* rmdir %resend% > nul
goto end

:help
echo.
echo Syntax: RESETUP.BAT
echo ~~~~~~~
echo Re-imports all messages in a Yarn database, e.g. if the database is
echo corrupted.
echo.
echo RESETUP.BAT needs the environment variables %%yarn%% and %%home%% set
echo correctly. The directory %%tmp%% will be used for temporary files.
goto end

:end
set resend=
set tmp=oldtmp
