#define		MAXLPT		3	/* supported under DOS */

enum lpt_state
{
	NONESUCH = 0,
	DISABLED,
	FREE,
	BUSY,
};

struct lpt_info
{
	char		name[MAXLABEL];		/* name of printer */
	char		jobname[MAXLABEL];	/* name of current job */
	enum lpt_state	avail;			/* active? */
	unsigned int	tone;			/* Hz, for this printer */
	int		status;			/* from last biosprint */
	int		hwaddr;			/* port address, != 0 == use */
	struct smbconn	*client;		/* client info struct */
	unsigned char	*largebuf;		/* enough for large xfers */
};

/*
 * Structure for returning print queue info
 * As usual, the designers were too stupid to align the members appropriately
 */

struct queue_info
{
	unsigned short	jobdate;
	unsigned short	jobtime;
	unsigned char	state;
	unsigned char	spoolnumber[2];		/* unaligned */
	unsigned char	spoolsize[4];		/* unaligned */
	unsigned char	reserved;
	unsigned char	clientname[16];
};

#define	QUEUE_INFO_SIZE	28

enum jobstate
{
	J_HELD = 1,
	J_PRINTING,
	J_WAITING,
	J_INTERCEPT,
	J_FERROR,
	J_PERROR,
};

extern int		nlpt;
extern int		notone;
extern int		reinit;
extern int		toconsole;
extern int		measureonly;
extern struct lpt_info	lpt[MAXLPT];

#define	bios_printer_init(i)	biosprint(1,0,i)
#define	bios_printer_status(i)	biosprint(2,0,i)
#define	bios_printer_outch(i,c)	biosprint(0,c,i)

/* printer status bits */
#define	P_TIMEOUT	0x01
#define	P_IOERROR	0x08
#define	P_SELECTED	0x10
#define	P_NOPAPER	0x20
#define	P_ACK		0x40
#define	P_IDLE		0x80

#define	P_CHANGES	(P_TIMEOUT|P_IOERROR|P_SELECTED|P_NOPAPER)
#define	P_READY		(P_SELECTED|P_IDLE)

extern int		find_printer(char *name);
extern void		check_printer_status(int printer, struct lpt_info *p);
extern void		callback_init(void);
extern int		print_data(struct smbconn *client);
