/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       DPUDUMP.C
**     SYSTEM   NAME:       PACKET DISPATCHER
**     ORIGINAL AUTHOR(S):  Ling Thio
**     VERSION  NUMBER:     v1.00
**     CREATION DATE:       1989/11/30
**
** DESCRIPTION: Functions to display a DNPAP logo
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   DPULOGO.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/C600/BEHOLDER/NPD/DPU/VCS/DPULOGO.C_V  $
**              
**                 Rev 1.0   25 Oct 1990 15:26:58   etstjan
**              Initial revision.
*************************************************************************/
#include "dpuinc.h"

static void LogoChar(int row, int col);
static int logocol, logorow;

static void LogoChar(int row, int col)
{
    pw_putcat(pw_win(PWID_BACKGROUND), logorow+row, logocol+col, '');
}

/************************************************************************
** NAME:        DpuLogoDNPAP
** SYNOPSIS:    void DpuLogoDNPAP(row, col, size)
**              int row, col        Position of logo
**              int size            Height of logo
** DESCRIPTION: Displays the DNPAP logo on POWER background.
** RETURNS:     void
*************************************************************************/
void DpuLogoDNPAP(row, col, size)
int row;
int col;
int size;
{
    int i;

    logorow = row-1;
    logocol = col-1;
    for (i=0; i<size+1; i++)
    {
        LogoChar(i, 0);                     /* D */
        LogoChar(i, i);
        LogoChar(size, i);

        LogoChar(i, size+i);                /* N */
        LogoChar(i, size*2);

        LogoChar(0, size*2+i);              /* P */
        LogoChar(i, size*3-i);

        LogoChar(i, size*3+size/2+1-i);     /* A */
        LogoChar(i, size*3+size/2+1);

        LogoChar(0, size*3+size/2+1+i);     /* P */
        LogoChar(i, size*4+size/2+1-i);
    }
    for (i=0; i<size/2+1; i++)
    {
        LogoChar(i, size);                  /* N */
        LogoChar(size/2+1, size*3+size/2-i);/* A */
    }
}
