@ECHO off

:BEGIN

IF "%1" == "" GOTO inst-aud
GOTO %1

                          INSTALL AUDITOR
                          ~~~~~~~~~~~~~~~

PURPOSE:  Report changes made to your system as a result of installing a
          software product.  (Requires DOS 5.0 or later.)

INSTALLATION:  Put this .BAT file ANYWHERE on your system.

               Put the following utility programs in a subdirectory on your
               current path:  ENVSET.COM, GETKEY.COM and @COMPARE.EXE

               (DOS 6+ users can eliminate using GETKEY.COM by insuring that
               DOS' CHOICE.COM is on your current path AND by removing the 
               lines from GETKEY up to but not including CHOICE in this .BAT
               file.)

               Make sure that QBASIC.EXE is also on your path (it is usually
               in C:\DOS) and make sure that there is enough environment space
               (see below).

               Under Windows, use FILE/ITEM and specify this .BAT as the
               command (fully qualified, if it is not installed in a
               sub-directory on your path).  For "Working Directory" enter the
               drive/sub-sirectory where INSTALL AUDITOR should store its data
               and work files (see below).  Either use one of the supplied
               icons or one of your own preference and enter an appropriate
               description.

               Under DOS, you must SET the environment variable WINDIR to be
               equal to the sub-directory that contains your Windows software
               (normally C:\WINDOWS) and you must CHDIR (CD) to the
               sub-directory where INSTALL AUDITOR should store its data and
               work files (see below).

The first time this procedure is run, it creates a sub-directory on your drive
under the CURRENT directory and saves an image of the directories on your
drive(s) and all Windows .INI files.  The second time this procedure runs, it
saves an image of the directories on your drive(s) and compares these
directories and critical Windows .INI files to the saved images.  Then, and on
subsequent executions of this procedure, the user is offered several options
to view the differences produced by the comparison or to remove the data
created by this procedure.

This procedure assumes that it can create the subdirectory INST-AUD.SAV for
its own use and that it can use environment variables INST-AUD-DIRCMD,
INST-AUD-DRVS and INST-AUD-WINDIR.  If you have such a sub-directory or
already use these environment variables, something will have to give.
(Probably easier for you to modify this .BAT file.)  Make sure that you have
enough environment space available for INSTALL AUDITOR;  if necessary specify
a /E: parameter on a SHELL= command in your CONFIG.SYS file to provide enough
environment space.

Documentation is included after the label "DOCUMENTATION" at the end of this
command procedure.


:INST-AUD

CLS
IF EXIST inst-aud.sav\before.dat goto AFTER

ECHO INSTALL AUDITOR
IF not EXIST inst-aud.sav\nul MD inst-aud.sav
CD inst-aud.sav


:GET-DRVS

ECHO.
ECHO Type the letters of the drives to be reviewed by INSTALL AUDITOR.
ECHO Separate the drive letters by a space and press return when done.
ECHO.
ENVSET i-a-drvs.bat inst-aud-drvs 
ECHO.
CALL i-a-drvs.bat
SET inst-aud-dircmd=
FOR %%x IN (%inst-aud-drvs%) DO call %0 CHK-DRVS %%x
IF not "%inst-aud-dircmd%" == "" GOTO get-drvs

ECHO Saving an image of directories and .INI files .....
ECHO.
CALL %0 getdir
REN dirlist.out before.dat
COPY c:\autoexec.bat            >  nul
ECHO.                           >> before.dat
ECHO ---{ AUTOEXEC.BAT }---     >> before.dat
ECHO.                           >> before.dat
COPY before.dat+c:\autoexec.bat >  nul
COPY c:\config.sys              >  nul
ECHO.                           >> before.dat
ECHO ---{ CONFIG.SYS }---       >> before.dat
ECHO.                           >> before.dat
COPY before.dat+c:\config.sys   >  nul
IF exist %windir%\reg.dat COPY %windir%\reg.dat >  nul
IF exist %windir%\*.ini   COPY %windir%\*.ini   >  nul
FOR %%x IN (*.ini) DO call %0 ADDINI --- %windir%\%%x BEFORE.DAT
SET windir=%inst-aud-windir%
SET inst-aud-windir=
ECHO.
ECHO Save of directory info and .INI files complete.
ECHO Procede with the installation of your application.
ECHO.
ECHO Rerun INSTALL AUDITOR again after software installation for a complete report.
ECHO.
CD ..
PAUSE
GOTO end


:AFTER

IF EXIST inst-aud.sav\after.dat GOTO menu

ECHO INSTALL AUDITOR
ECHO.
ECHO Formatting an image of directories and .INI files .....
ECHO.
CD inst-aud.sav
CALL %0 getdir
REN dirlist.out after.dat
ECHO.                           >> after.dat
ECHO ___{ AUTOEXEC.BAT }___     >> after.dat
ECHO.                           >> after.dat
COPY after.dat+c:\autoexec.bat  >  nul
ECHO.                           >> after.dat
ECHO ___{ CONFIG.SYS }___       >> after.dat
ECHO.                           >> after.dat
COPY after.dat+c:\config.sys    >  nul
FOR %%x IN (*.ini) DO CALL %0 ADDINI ___ %windir%\%%x AFTER.DAT
SET windir=%inst-aud-windir%
SET inst-aud-windir=
ECHO.
ECHO Format of directory info and .INI files complete.
CD ..
PAUSE
GOTO menu


:MENU-X
ECHO  Invalid response.  You must choose 1, 2, 3, 4, 5 or 6
PAUSE
CLS

:MENU
ECHO.
ECHO              INSTALL AUDITOR Results Selection Menu
ECHO              ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ECHO.
ECHO              Press the number for one of the following options:
ECHO.
ECHO                1 = Delete all INSTALL AUDITOR data
ECHO                2 = Delete INSTALL AUDITOR's "after" data and rerun
ECHO                3 = View comparison of Before/After data
ECHO                4 = Print comparison of Before/After data
ECHO                5 = Save comparison of Before/After data to a file
ECHO                6 = Exit this procedure
ECHO.

REM  ***********************************************************************
REM  *                                                                     *
REM  * DOS 6.xx users with CHOICE.COM on their current path can opt to use *
REM  * DOS' CHOICE in place of GETKEY.  To do so, remove these lines and   *
REM  * the nine lines of code that immediately follow.  DOS 5.xx users can *
REM  * leave the code for CHOICE here since they never actually execute.   *
REM  *                                                                     *
REM  ***********************************************************************

GETKEY
IF errorlevel 55 GOTO menu-x
IF errorlevel 54 GOTO end
IF errorlevel 53 GOTO menu-5
IF errorlevel 52 GOTO menu-4
IF errorlevel 51 GOTO menu-3
IF errorlevel 50 GOTO menu-2
IF errorlevel 49 GOTO menu-1
GOTO menu-x

CHOICE /C:123456 /N
IF errorlevel  7 GOTO menu-x
IF errorlevel  6 GOTO end
IF errorlevel  5 GOTO menu-5
IF errorlevel  4 GOTO menu-4
IF errorlevel  3 GOTO menu-3
IF errorlevel  2 GOTO menu-2
IF errorlevel  1 GOTO menu-1
GOTO menu-x


:MENU-5
ECHO To avoid mixing the comparison data file with INSTALL AUDIT's data
ECHO specify a full path and file name......
@@COMPARE.EXE /eaf  inst-aud.sav\before.dat inst-aud.sav\after.dat 
GOTO menu

:MENU-4
@@COMPARE.EXE /eahp inst-aud.sav\before.dat inst-aud.sav\after.dat
GOTO menu

:MENU-3
@@COMPARE.EXE /e    inst-aud.sav\before.dat inst-aud.sav\after.dat
PAUSE
GOTO menu

:MENU-2
DEL inst-aud.sav\after.dat
GOTO after

:MENU-1
ECHO Removing the INSTALL AUDIT sub-directory and all INSTALL AUDIT files....
DEL inst-aud.sav\*.*
IF EXIST inst-aud.sav\before.dat GOTO menu
RD inst-aud.sav
GOTO end


:GETDIR

IF exist DIRLIST.INP del DIRLIST.INP
SET inst-aud-dircmd=%dircmd%
SET dircmd=
CALL i-a-drvs.bat
FOR %%x IN (%inst-aud-drvs%) DO if EXIST %%x:\nul CALL %0 RUNDIR %%x
SET dircmd=%inst-aud-dircmd%
SET inst-aud-dircmd=
SET inst-aud-drvs=

:MAKE-PGM

ECHO OPEN "windir.bat" FOR OUTPUT AS #1                        >  inst-aud.bas
ECHO PRINT #1, "set WINDIR="; ENVIRON$("windir")               >> inst-aud.bas
ECHO OPEN "dirlist.inp" FOR INPUT AS #2                        >> inst-aud.bas
ECHO OPEN "dirlist.out" FOR OUTPUT AS #3                       >> inst-aud.bas
ECHO LET drives = 0                                            >> inst-aud.bas
ECHO DO WHILE NOT EOF(2)                                       >> inst-aud.bas
ECHO      LINE INPUT #2, text$                                 >> inst-aud.bas
ECHO      GOSUB proc                                           >> inst-aud.bas
ECHO      LOOP                                                 >> inst-aud.bas
ECHO CLOSE #1, #2, #3                                          >> inst-aud.bas
ECHO PRINT                                                     >> inst-aud.bas
ECHO PRINT "Total Drives Processed: ";drives                   >> inst-aud.bas
ECHO SYSTEM                                                    >> inst-aud.bas
ECHO.                                                          >> inst-aud.bas
ECHO proc:                                                     >> inst-aud.bas
ECHO.                                                          >> inst-aud.bas
ECHO IF LEN(text$) = 0 THEN RETURN                             >> inst-aud.bas
ECHO IF LEFT$(text$, 2) = "*{" THEN                            >> inst-aud.bas
ECHO     LET drives = drives + 1                               >> inst-aud.bas
ECHO     LET dirs   = -1                                       >> inst-aud.bas
ECHO     LET fils   = 0                                        >> inst-aud.bas
ECHO     RETURN                                                >> inst-aud.bas
ECHO END IF                                                    >> inst-aud.bas
ECHO IF LEFT$(text$, 2) = "*}" THEN                            >> inst-aud.bas
ECHO     PRINT "Drive ";MID$(text$, 7, 1); " has"; dirs;       >> inst-aud.bas
ECHO     PRINT "sub-directories and"; fils-dirs; "files"       >> inst-aud.bas
ECHO     RETURN                                                >> inst-aud.bas
ECHO END IF                                                    >> inst-aud.bas
ECHO IF LEFT$(text$, 1) = " " THEN RETURN                      >> inst-aud.bas
ECHO IF LEFT$(text$, 1) = "." THEN RETURN                      >> inst-aud.bas
ECHO IF LEFT$(text$, 1) = "*" THEN RETURN                      >> inst-aud.bas
ECHO IF LEFT$(text$, 16) = "Total files list" THEN RETURN      >> inst-aud.bas
ECHO IF LEFT$(text$, 17) = "INST-AUD SAV <DIR" THEN RETURN     >> inst-aud.bas
ECHO IF LEFT$(text$, 13) = "Directory of " THEN                >> inst-aud.bas
ECHO     LET dir$ = MID$(text$, 13)                            >> inst-aud.bas
ECHO     IF NOT RIGHT$(dir$, 12) = "INST-AUD.SAV" THEN         >> inst-aud.bas
ECHO         LET dirs = dirs + 1                               >> inst-aud.bas
ECHO     END IF                                                >> inst-aud.bas
ECHO ELSEIF NOT RIGHT$(dir$, 12) = "INST-AUD.SAV" THEN         >> inst-aud.bas
ECHO       PRINT #3, text$; "  <="; dir$                       >> inst-aud.bas
ECHO       LET fils = fils + 1                                 >> inst-aud.bas
ECHO END IF                                                    >> inst-aud.bas
ECHO RETURN                                                    >> inst-aud.bas

QBASIC /RUN inst-aud
DEL inst-aud.bas
DEL dirlist.inp
set inst-aud-windir=%windir%
CALL windir.bat
IF "%windir%" == "" set windir=%inst-aud-windir%
DEL windir.bat
GOTO end


:RUNDIR

ECHO *{Begin %2: drive >> dirlist.inp
DIR %2:\*.* /A /O /S   >> dirlist.inp
ECHO *}End %2: drive   >> dirlist.inp
GOTO end


:ADDINI

ECHO.                  >> %4
ECHO %2{ %3 }%2        >> %4
ECHO.                  >> %4
IF exist %3 COPY %4+%3 >  nul
GOTO end


:CHK-DRVS

IF exist %2:\nul GOTO end
ECHO Drive %2: does not exist.
SET inst-aud-dircmd=XXX
GOTO end


:DOCUMENTATION

BEGIN:     The entry point for this procedure.  Rather than create multiple
           procedures for INSTALL AUDITOR, the main procedure actually calls
           itself (%0 from the DOS perspective).  "BEGIN" checks the first
           parameter passed to this procedure to see if it is a subsequent
           (recursive) call.  If a parameter is supplied, it must be one of
           the labels contained in this procedure.  Each of these labels end
           by going to the end of the end of the procedure (GOTO the end
           label) so that DOS returns to the instruction immediately following
           the CALL. 

INST_AUD:  The normal starting point for this procedure.  Test to see if this
           is the first time INSTALL AUDITOR is being executed.  IF it has
           been run before ("BEFORE.DAT" exists), then jump to the second pass
           logic ("AFTER").  Otherwise, create the subdirectory for INSTALL
           AUDITOR's data.

GET-DRVS:  Prompt the user to tell us what drives should be involved in the
           audit.  Use the ENVSET utility to capture the answer in a .BAT file
           which, in turn, sets an environment variable for this procedure to
           use.  Edit the drive letters entered and, if they are not valid, 
           repeat the request for entry of the drive letters.  (See CHK-DRVS)

           Call this procedure (recursive call with an appropriate parameter)
           to do the logic whereby a "snapshot" of the directories on the
           specified drives is taken.  The "snapshot" is processed by a
           short BASIC program to facilitate reporting on files/programs
           added/deleted/changed in subsequent executions.  This "processed
           snapshot" is saved in the file BEFORE.DAT.

           Append copies of appropriate .INI files to BEFORE.DAT and insert a
           "seperator" into BEFORE.DAT before each file with an ECHO command.
           Also save separate copies of these files along with AUTOEXEC.BAT,
           CONFIG.SYS and Windows' REG.DAT (to make backout of the installed
           software easier).

AFTER:     Check to see if this is a rerun ("AFTER.DAT" exists).  If it is a
           rerun (third execution or more) jump to the post-processing menu.

           Otherwise, run processes similar to the pre-install logic above to
           save a current "snapshot" of directories and .INI files into a file
           called "AFTER.DAT".  When inserting the "separator" entries into
           the "snapshot" file before each .INI file, use a slightly different
           format than in the first run.  Although this causes @COMPARE to
           show them as differences, it at least lets the user know where the
           differences exist.

MENU:      (MENU-X, MENU-1, MENU-2, MENU-3, MENU-4, MENU-5)  A poor man's way
           of presenting a menu of several options to the user.  (Not overly
           slick but it gets the job done.)  Use the GETKEY utility which
           accepts a single keystroke from the keyboard and sets the DOS
           ERRORLEVEL to the ASCII value of the keystroke.  Users of DOS 6.0
           and above can substitute DOS' CHOICE by removing the lines from
           GETKEY up to but not including CHOICE.

GETDIR:    One of the recursive call points in INSTALL AUDITOR.  Save the
           environment variable DIRCMD, call the .BAT file created by ENVSET
           when we started and, if each of the drives does exist, run the DOS
           DIR command to take the first step of creating the snapshot of the
           files on the system.  After running the DOS DIR command(s), 
           "restore" the DIRCMD environment variable.  Then create, run and
           delete a BASIC program (see MAKE-PGM below).  Finally, make the
           WINDIR environment variable available and do some final cleanup.

MAKE-PGM:  Create the BASIC program to "clean up" the output from DOS's DIR
           command.  This program esentially does four things:

           Create a .BAT file so that we can use the "windir" environment
           variable set by WIN.COM.  Microsoft did a nice one here:  Windows
           sets this variable in lower case so that you can't use it.  (The
           SET command shows it to you but you can't do anything with it.)

           Process the DIR command output to give us a file equivalent to that
           produced by DIR's /B switch but with file sizes, dates and times.

           Exclude the directory created by INSTALL AUDITOR as it would only
           confuse things to report our work areas as changes.

           Display a brief statistics summary for each drive.  By showing
           this, the user might get a hint of any problems with the response
           to the prompt for drives to be included in the audit.

           If you modify the BASIC program, beware of using the DOS pipe
           symbol and the DOS redirection symbols (since ECHO statements are
           used to make the BASIC source program0.  This effectively
           eliminates the ability to test "<>", "<" and ">".

RUNDIR:    Another of the recursive call points in INSTALL AUDITOR.  The
           DOS 5.0 manual says that you can use redirection in conjunction
           with "FOR" but this doesn't really work out.  As long as we have to
           make another recursive call, we can insert a "separator" for each
           drive into the output file created by the DIR command to make
           things a bit easier for the BASIC program above.

ADDINI:    Another of the recursive call points in INSTALL AUDITOR.  The "FOR"
           command in the INST-AUD and AFTER logic identifies each of the .INI
           files saved into the INST-AUD.SAV directory during the INST-AUD
           process.  These four lines of code insert a seperator into the
           comparison data file followed by the contents of the windows .INI
           file.

CHK-DRVS:  Another of the recursive call points in INSTALL AUDITOR.  Like
           ADD-INI, above, this allows INSTALL AUDITOR to execute several
           lines of logic for each of the parameters "in" a "FOR" command.

           If one of the drive letters entered by the user is incorrect of if
           more than just the dirve letter was entered, this check detects it,
           sets environment variable INST-AUD-DIRCMD as a flag to the GET-DRVS
           (because the DIR command will not work) and writes a message to the
           screen.


:END
