/*
 *	gputs.c  -- print a string in graphic mode
 *
 *	8 may  1989  Olle
 */

#include <graphics.h>


void gputs( register char *string )
{
int chw, chh;
struct fillsettingstype fis;

/* print a string in graphic mode */
/* assume TOP_TEXT & LEFT_TEXT justification */

/* get string size for erase */
chw = textwidth( string );
chh = textheight( string );

/* get fill settings */
getfillsettings( &fis );

/* setup for character erase */
setfillstyle( SOLID_FILL, getbkcolor() );

/* fill with the background color */
bar( getx(), gety(), getx() + chw - 1, gety() + chh - 1 );

/* print the string */
outtext( string );

/* restore fill settings */
setfillstyle( fis.pattern, fis.color );
}

