/*                        Sprite & Scrolling Engine                         */
/*           Copyright (c) Genesoft 1996.  All rights reserved.             */
/*                                                                          */
/*                       Keyboard Handler Header File                       */

#ifndef _SSEKEYB_H_INCLUDED

/*  C++ compatibility  */

#ifdef __cplusplus
extern "C" {
#endif

extern volatile char keyPauseFlag;    /* Toggled each time pause is pressed */

extern volatile char keyTable[ 128 ]; /* Stores keypress info (see below) */

void keyInstallHandler( void );

void keyRestoreHandler( void );


/* Table locations for checking if keys are pressed */

/* First Row */
#define ESC_PRESSED           ( keyTable[ 0x01 ] )
#define F1_PRESSED            ( keyTable[ 0x3B ] )
#define F2_PRESSED            ( keyTable[ 0x3C ] )
#define F3_PRESSED            ( keyTable[ 0x3D ] )
#define F4_PRESSED            ( keyTable[ 0x3E ] )
#define F5_PRESSED            ( keyTable[ 0x3F ] )
#define F6_PRESSED            ( keyTable[ 0x40 ] )
#define F7_PRESSED            ( keyTable[ 0x41 ] )
#define F8_PRESSED            ( keyTable[ 0x42 ] )
#define F9_PRESSED            ( keyTable[ 0x43 ] )
#define F10_PRESSED           ( keyTable[ 0x44 ] )
#define F11_PRESSED           ( keyTable[ 0x57 ] )
#define F12_PRESSED           ( keyTable[ 0x58 ] )
#define PRINT_SCREEN_PRESSED  ( keyTable[ 0x77 ] )
#define SCROLL_LOCK_PRESSED   ( keyTable[ 0x46 ] )
#define PAUSE_PRESSED      ( keyTable[ 0x65 ] ) /* use keyPauseFlag instead.*/

/* Second Row */
#define TILDE_PRESSED         ( keyTable[ 0x29 ] )
#define MAIN_ONE_PRESSED      ( keyTable[ 0x02 ] )
#define MAIN_TWO_PRESSED      ( keyTable[ 0x03 ] )
#define MAIN_THREE_PRESSED    ( keyTable[ 0x04 ] )
#define MAIN_FOUR_PRESSED     ( keyTable[ 0x05 ] )
#define MAIN_FIVE_PRESSED     ( keyTable[ 0x06 ] )
#define MAIN_SIX_PRESSED      ( keyTable[ 0x07 ] )
#define MAIN_SEVEN_PRESSED    ( keyTable[ 0x08 ] )
#define MAIN_EIGHT_PRESSED    ( keyTable[ 0x09 ] )
#define MAIN_NINE_PRESSED     ( keyTable[ 0x0A ] )
#define MAIN_ZERO_PRESSED     ( keyTable[ 0x0B ] )
#define MAIN_MINUS_PRESSED    ( keyTable[ 0x0C ] )
#define EQUALS_PRESSED        ( keyTable[ 0x0D ] )
#define BACKSPACE_PRESSED     ( keyTable[ 0x0E ] )
#define MAIN_INSERT_PRESSED   ( keyTable[ 0x72 ] )
#define MAIN_HOME_PRESSED     ( keyTable[ 0x67 ] )
#define MAIN_PAGE_UP_PRESSED  ( keyTable[ 0x69 ] )
#define NUM_LOCK_PRESSED      ( keyTable[ 0x45 ] )
#define NUM_FORWARD_SLASH_PRESSED ( keyTable[ 0x75 ] )
#define NUM_ASTERISK_PRESSED  ( keyTable[ 0x37 ] )
#define NUM_MINUS_PRESSED     ( keyTable[ 0x4A ] )

/* Third Row */
#define TAB_PRESSED           ( keyTable[ 0x0F ] )
#define Q_PRESSED             ( keyTable[ 0x10 ] )
#define W_PRESSED             ( keyTable[ 0x11 ] )
#define E_PRESSED             ( keyTable[ 0x12 ] )
#define R_PRESSED             ( keyTable[ 0x13 ] )
#define T_PRESSED             ( keyTable[ 0x14 ] )
#define Y_PRESSED             ( keyTable[ 0x15 ] )
#define U_PRESSED             ( keyTable[ 0x16 ] )
#define I_PRESSED             ( keyTable[ 0x17 ] )
#define O_PRESSED             ( keyTable[ 0x18 ] )
#define P_PRESSED             ( keyTable[ 0x19 ] )
#define OPEN_BRACE_PRESSED    ( keyTable[ 0x1A ] )
#define CLOSE_BRACE_PRESSED   ( keyTable[ 0x1B ] )
#define BACK_SLASH_PRESSED    ( keyTable[ 0x2B ] )
#define MAIN_DELETE_PRESSED    ( keyTable[ 0x73 ] )
#define MAIN_END_PRESSED       ( keyTable[ 0x6F ] )
#define MAIN_PAGE_DOWN_PRESSED ( keyTable[ 0x71 ] )
#define NUM_HOME_PRESSED      ( keyTable[ 0x47 ] )
#define NUM_UP_PRESSED        ( keyTable[ 0x48 ] )
#define NUM_PAGE_UP_PRESSED   ( keyTable[ 0x49 ] )
#define NUM_PLUS_PRESSED      ( keyTable[ 0x4E ] )

/* Fourth Row */
#define CAPS_LOCK_PRESSED     ( keyTable[ 0x3A ] )
#define A_PRESSED             ( keyTable[ 0x1E ] )
#define S_PRESSED             ( keyTable[ 0x1F ] )
#define D_PRESSED             ( keyTable[ 0x20 ] )
#define F_PRESSED             ( keyTable[ 0x21 ] )
#define G_PRESSED             ( keyTable[ 0x22 ] )
#define H_PRESSED             ( keyTable[ 0x23 ] )
#define J_PRESSED             ( keyTable[ 0x24 ] )
#define K_PRESSED             ( keyTable[ 0x25 ] )
#define L_PRESSED             ( keyTable[ 0x26 ] )
#define SEMICOLON_PRESSED     ( keyTable[ 0x27 ] )
#define APOSTROPHY_PRESSED    ( keyTable[ 0x28 ] )
#define MAIN_ENTER_PRESSED    ( keyTable[ 0x1C ] )
#define NUM_LEFT_PRESSED      ( keyTable[ 0x4B ] )
#define NUM_CENTER_PRESSED    ( keyTable[ 0x4C ] )
#define NUM_RIGHT_PRESSED     ( keyTable[ 0x4D ] )

/* Fifth Row */
#define LEFT_SHIFT_PRESSED    ( keyTable[ 0x2A ] )
#define Z_PRESSED             ( keyTable[ 0x2C ] )
#define X_PRESSED             ( keyTable[ 0x2D ] )
#define C_PRESSED             ( keyTable[ 0x2E ] )
#define V_PRESSED             ( keyTable[ 0x2F ] )
#define B_PRESSED             ( keyTable[ 0x30 ] )
#define N_PRESSED             ( keyTable[ 0x31 ] )
#define M_PRESSED             ( keyTable[ 0x32 ] )
#define COMMA_PRESSED         ( keyTable[ 0x33 ] )
#define MAIN_PERIOD_PRESSED   ( keyTable[ 0x34 ] )
#define MAIN_FORWARD_SLASH_PRESSED ( keyTable[ 0x35 ] )
#define RIGHT_SHIFT_PRESSED   ( keyTable[ 0x36 ] )
#define MAIN_UP_PRESSED       ( keyTable[ 0x68 ] )
#define NUM_END_PRESSED       ( keyTable[ 0x4F ] )
#define NUM_DOWN_PRESSED      ( keyTable[ 0x50 ] )
#define NUM_PAGE_DOWN_PRESSED ( keyTable[ 0x51 ] )
#define NUM_ENTER_PRESSED     ( keyTable[ 0x7C ] )
                           
/* Sixth Row */
#define LEFT_CTRL_PRESSED     ( keyTable[ 0x1D ] )
#define LEFT_ALT_PRESSED      ( keyTable[ 0x38 ] )
#define SPACE_PRESSED         ( keyTable[ 0x39 ] )
#define RIGHT_ALT_PRESSED     ( keyTable[ 0x78 ] )
#define RIGHT_CTRL_PRESSED    ( keyTable[ 0x7D ] )
#define MAIN_LEFT_PRESSED     ( keyTable[ 0x6B ] )
#define MAIN_DOWN_PRESSED     ( keyTable[ 0x70 ] )
#define MAIN_RIGHT_PRESSED    ( keyTable[ 0x6D ] )
#define NUM_INSERT_PRESSED    ( keyTable[ 0x52 ] )
#define NUM_DELETE_PRESSED    ( keyTable[ 0x53 ] )

/* Common Replacements */
#define ASTERISK_PRESSED      NUM_ASTERISK_PRESSED
#define PLUS_PRESSED          NUM_PLUS_PRESSED
#define NUM_ZERO_PRESSED      NUM_INSERT_PRESSED
#define NUM_ONE_PRESSED       NUM_END_PRESSED
#define NUM_TWO_PRESSED       NUM_DOWN_PRESSED
#define NUM_THREE_PRESSED     NUM_PAGE_DOWN_PRESSED
#define NUM_FOUR_PRESSED      NUM_LEFT_PRESSED
#define NUM_FIVE_PRESSED      NUM_CENTER_PRESSED
#define NUM_SIX_PRESSED       NUM_RIGHT_PRESSED
#define NUM_SEVEN_PRESSED     NUM_HOME_PRESSED
#define NUM_EIGHT_PRESSED     NUM_UP_PRESSED
#define NUM_NINE_PRESSED      NUM_PAGE_UP_PRESSED
#define NUM_PERIOD_PRESSED    NUM_DELETE_PRESSED

/* Combinations */
#define SHIFT_PRESSED         ( LEFT_SHIFT_PRESSED | RIGHT_SHIFT_PRESSED )
#define ALT_PRESSED           ( LEFT_ALT_PRESSED | RIGHT_ALT_PRESSED )
#define CTRL_PRESSED          ( LEFT_CTRL_PRESSED | RIGHT_CTRL_PRESSED )
#define MINUS_PRESSED         ( MAIN_MINUS_PRESSED | NUM_MINUS_PRESSED )
#define FORWARD_SLASH_PRESSED ( MAIN_FORWARD_SLASH_PRESSED | NUM_FORWARD_SLASH_PRESSED )
#define ENTER_PRESSED         ( MAIN_ENTER_PRESSED | NUM_ENTER_PRESSED )
#define HOME_PRESSED          ( MAIN_HOME_PRESSED | NUM_HOME_PRESSED )
#define UP_PRESSED            ( MAIN_UP_PRESSED | NUM_UP_PRESSED )
#define PAGE_UP_PRESSED       ( MAIN_PAGE_UP_PRESSED | NUM_PAGE_UP_PRESSED )   
#define LEFT_PRESSED          ( MAIN_LEFT_PRESSED | NUM_LEFT_PRESSED )
#define RIGHT_PRESSED         ( MAIN_RIGHT_PRESSED | NUM_RIGHT_PRESSED )
#define END_PRESSED           ( MAIN_END_PRESSED | NUM_END_PRESSED )
#define DOWN_PRESSED          ( MAIN_DOWN_PRESSED | NUM_DOWN_PRESSED )
#define PAGE_DOWN_PRESSED     ( MAIN_PAGE_DOWN_PRESSED | NUM_PAGE_DOWN_PRESSED )
#define INSERT_PRESSED        ( MAIN_INSERT_PRESSED | NUM_INSERT_PRESSED )
#define DELETE_PRESSED        ( MAIN_DELETE_PRESSED | NUM_DELETE_PRESSED )
#define ZERO_PRESSED          ( MAIN_ZERO_PRESSED | NUM_ZERO_PRESSED )
#define ONE_PRESSED           ( MAIN_ONE_PRESSED | NUM_ONE_PRESSED )
#define TWO_PRESSED           ( MAIN_TWO_PRESSED | NUM_TWO_PRESSED )
#define THREE_PRESSED         ( MAIN_THREE_PRESSED | NUM_THREE_PRESSED )
#define FOUR_PRESSED          ( MAIN_FOUR_PRESSED | NUM_FOUR_PRESSED )
#define FIVE_PRESSED          ( MAIN_FIVE_PRESSED | NUM_FIVE_PRESSED )
#define SIX_PRESSED           ( MAIN_SIX_PRESSED | NUM_SIX_PRESSED )
#define SEVEN_PRESSED         ( MAIN_SEVEN_PRESSED | NUM_SEVEN_PRESSED )
#define EIGHT_PRESSED         ( MAIN_EIGHT_PRESSED | NUM_EIGHT_PRESSED )
#define NINE_PRESSED          ( MAIN_NINE_PRESSED | NUM_NINE_PRESSED )
#define PERIOD_PRESSED        ( MAIN_PERIOD_PRESSED | NUM_PERIOD_PRESSED )



#define _SSEKEYB_H_INCLUDED
#ifdef __cplusplus
};
#endif
#endif
