/* ------------------------------------------------------------------------ */
/* Pslib.c (C) CopyLeft Bill Buckels 1991-1999                              */
/* All Rights Reversed.                                                     */
/*                                                                          */
/* Licence Agreement                                                        */
/* -----------------                                                        */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* If you don't agree, remove this source code from your computer now.      */
/*                                                                          */
/* Written by   : Bill Buckels                                              */
/*                589 Oxford Street                                         */
/*                Winnipeg, Manitoba, Canada R3M 3J2                        */
/*                                                                          */
/* Email: bbuckels@escape.ca                                                */
/* WebSite: http://www.escape.ca/~bbuckels                                  */
/*                                                                          */
/* Purpose      : Library Utility for Old Printshop                         */
/* Revision     : 2.0 Last Release                                          */
/* ------------------------------------------------------------------------ */
/* Written in Large Model Microsoft C Version 6.00a                         */
/* ------------------------------------------------------------------------ */

#include <fcntl.h>
#include <stdio.h>
#include <malloc.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>

unsigned char far *buffer, *packbuffer;


unsigned char pchead[]={
0x0A, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 
0xAF, 0x00, 0x33, 0x00, 0xB0, 0x00, 0x34, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x01, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

int checkforpcx(unsigned char *pcxheader)
{
  int invalid = - 1, valid = 0, status = valid;
  
  /* read the file header */
  
  if(pchead[0] != pcxheader[0])status = invalid;
  if(pchead[2] != pcxheader[2])status = invalid;
  if(pchead[3] != pcxheader[3])status = invalid;
  
  if(pchead[4] != pcxheader[4])status = invalid;
  if(pchead[5] != pcxheader[5])status = invalid;
  if(pchead[6] != pcxheader[6])status = invalid;
  if(pchead[7] != pcxheader[7])status = invalid;
  
  if(pchead[8] != pcxheader[8])status = invalid;
  if(pchead[9] != pcxheader[9])status = invalid;
  if(pchead[10] != pcxheader[10])status = invalid;
  if(pchead[11] != pcxheader[11])status = invalid;
  
  if(pchead[65] != pcxheader[65])status = invalid;
  if(pchead[66] != pcxheader[66])status = invalid;
  if(pchead[67] != pcxheader[67])status = invalid;
  
  return status;
  
}

unsigned BSIZE = 1156;
unsigned csize = 1148;
unsigned char bheader[]={0xFD, 0x00, 0xB8, 0x00, 0x00, 0x7C, 0x04};
unsigned char picheader[]={0xB0, 0x00, 0x34, 0x00};


int memoryload(unsigned char far *in, unsigned char far *out, int sz)
{
  unsigned int byteoff = 0,packet,width = 0;
  unsigned char byte,bytecount;
  long wordcount = 0,target;
  
  
  target = 1l*sz;
  
  do
  {
    bytecount = 1;                     /* start with a seed count */
    byte = in[wordcount];
    wordcount++;
    /* check to see if its raw */
    if(0xC0 == (0xC0 &byte))
    {
      /* if its not, run encoded */
      bytecount = 0x3f &byte;
      byte = in[wordcount];
      wordcount++;
    }
    for(packet = 0;packet < bytecount;packet++)
    {
      out[byteoff] = byte;
      byteoff++;
    }
  }while(wordcount < target);
  return(0);
}




int fragin(unsigned char *frag, unsigned char *lib)
{
  FILE *fp;
  unsigned char pcxheader[128];
  
  unsigned char libname[66], listname[66];
  unsigned char scratch[66], picname[66], fragment[66];
  unsigned char *ptr, *bptr;
  unsigned char c,d,temp;
  
  int fh;
  int i;
  unsigned int buffersize;
  
  
  strcpy(scratch, frag);
  bptr = strtok(scratch, " .\\:*");
  sprintf(fragment, "%s.PCC", scratch);
  
  if((fp = fopen(fragment, "rb")) != NULL)
  {
    buffersize = filelength(fileno(fp)) - 128;
    fclose(fp);
    buffer = _fmalloc(csize);
    packbuffer = _fmalloc(buffersize);
    fh = open(fragment, O_RDONLY | O_BINARY);
    read(fh, pcxheader, 128);
    if(checkforpcx(pcxheader))
    {
      close(fh);
      _ffree(buffer);
      _ffree(packbuffer);
      printf("File %s has invalid header info...\n", fragment);
    }
    read(fh, packbuffer, buffersize);
    close(fh);
    memoryload(packbuffer, buffer, buffersize);
    _ffree(packbuffer);
  }
  else
  {
    strcpy(scratch, frag);
    bptr = strtok(scratch, " .\\:*");
    sprintf(fragment, "%s.PIC", scratch);
    
    if((fp = fopen(fragment, "rb")) == NULL)
    {
      perror(fragment);
    }
    
    buffersize = filelength(fileno(fp));
    fclose(fp);
    
    if(buffersize > BSIZE || buffersize < csize)
    {
      printf("Sorry... only 88 x 52 PIC or PCC files are supported.\n");
      exit(0);
    }
    
    buffer = _fmalloc(buffersize);
    
    fh = open(fragment, O_RDONLY | O_BINARY);
    
    if(buffersize == BSIZE)read(fh, buffer, 7);
    read(fh, buffer, 4);
    for(i = 0;i < 4;i++)
    {
      if(buffer[i] != picheader[i])
      {
        close(fh);
        printf("Invalid Header Data in Pic File...\n");
        _ffree(buffer);
        exit(0);
      }
    }
    read(fh, buffer, buffersize);
    close(fh);
  }
  
  
  i = 0;
  ptr = (unsigned char *)&buffer[0];
  
  strcpy(scratch, lib);
  scratch[8] = 0;
  bptr = strtok(scratch, " .\\:*");
  c = toupper(lib[0]);
  d = toupper(lib[1]);
  if(c == 'G' && d == 'R')
  {
    sprintf(libname, "%s.DAT", scratch);
    sprintf(listname, "%s.NAM", scratch);
  }
  else
  {
    scratch[6] = 0;
    sprintf(libname, "GR%s.DAT", scratch);
    sprintf(listname, "GR%s.NAM", scratch);
  }
  strcpy(scratch, fragment);
  bptr = strtok(scratch, " .\\:*");
  sprintf(picname, "%s                ", scratch);
  picname[15] = 0;
  
  
  if((fp = fopen(libname, "ab")) == NULL)
  {
    perror(libname);
    _ffree(buffer);
    exit(0);
  }
  
  while(i < 1144)
  {
    c = 0;
    
    temp = *ptr;
    *ptr++;
    if((temp&192) >> 6)c |= 1;  c <<= 1;
    if((temp&48) >> 4) c |= 1;  c <<= 1;
    if((temp&12) >> 2) c |= 1;  c <<= 1;
    if(temp&3)c |= 1;         c <<= 1;
    
    
    temp = *ptr;
    *ptr++;
    if((temp&192) >> 6)c |= 1;  c <<= 1;
    if((temp&48) >> 4) c |= 1;  c <<= 1;
    if((temp&12) >> 2) c |= 1;  c <<= 1;
    if(temp&3)c |= 1;
    
    fputc(c^0xff, fp);
    i += 2;
  }
  fclose(fp);
  _ffree(buffer);
  
  if((fp = fopen(listname, "ab")) == NULL)
  {
    perror(listname);
    exit(0);
  }
  
  for(i = 0;i < 16;i++)
    fputc(picname[i], fp);
  
  fclose(fp);
  printf("Graphics Files %s and %s now include %s\n", 
    libname, listname, fragment);
  return 0;
  
}

main(int argc, char *argv[])
{
  char buffer[66],buffer2[66];
  char temp[66];
  
  puts("PSLIB(C) by Bill Buckels 1991");
  
  if(argc == 3)
    fragin(argv[1], argv[2]);
  else
  {
    system("Dir *.p* /W");
    printf("Please Enter Choice (PIC or PCC filename ) : ");
    gets(buffer);
    system("cls");
    puts("listing of DAT files in the current directory...");
    system("Dir *.DAT /W");
    printf("Please Enter Choice :  GR");
    gets(buffer2);
    system("cls");
    fragin(buffer, buffer2);
  }
  
  puts("Done !");
  exit(0);
  
}







