/*****************************************************************************
* Definitions for the EEDRAW program:					     *
*****************************************************************************/

#ifndef PROGRAM_H
#define PROGRAM_H

#define LayerPointer EEActiveWindow->Layer

#define EEDRAW_VERSION	"Version 2.4"

#define PROGRAM_NAME	"EEdraw"

#include "intr_lib.h"
#include "intr_gr.h"

typedef int		BooleanType;
typedef unsigned char	ByteType;

#if !defined(FLOAT) && !defined(DOUBLE)
#define DOUBLE
typedef	double		RealType;
#endif /* !FLOAT && !DOUBLE */

#ifdef VoidPtr
#undef VoidPtr
#endif /* VoidPtr */

#ifdef NO_VOID_PTR
#define VoidPtr		char *
#else
#define VoidPtr		void *
#endif /* NO_VOID_PTR */

#ifndef	NULL
#define	NULL	0
#endif

#ifndef	TRUE
#define	TRUE	1
#define	FALSE	0
#endif

#ifndef LINE_LEN
#define LINE_LEN_LONG	1024
#define LINE_LEN	255
#define LINE_LEN_SHORT	81
#define FULL_PATH_LEN	81
#define FILE_NAME_LEN	14
#define MAX_PIN_INFO	10
#endif

#define EE_ERASE_COLOR  (IntrAllocColor(EEActvWndwBackColor, INTR_INTENSITY_HIGH))
#define EE_DRAW_COLOR  (IntrAllocColor(EEActvWndwForeColor, INTR_INTENSITY_VHIGH))
#define EE_HIGHLIGHT_COLOR  (IntrAllocColor(EEHighLightColor, INTR_INTENSITY_VHIGH))

#define SIGN(x)		((x) > 0 ? 1 : ((x) < 0 ? -1 : 0))
#define ABS(y)		((y) > 0 ? (y) : (-(y)))
#define SQR(y)		((y) * (y))
#define SGN(x)		((x) > 0 ? 1 : ((x) == 0 ? 0 : -1))
#define MIN(x, y)	((x) > (y) ? (y) : (x))
#define MAX(x, y)	((x) > (y) ? (x) : (y))
#define BOUND(x, Min, Max) (MIN(MAX((x), (Min)), (Max)))
#define GEN_COPY(Dest, Src, Size)       memcpy(Dest, Src, Size)

#define INFINITY	1e6
#define EPSILON		1e-6

#define DEG2RAD(Deg)	((Deg) * M_PI / 180.0)
#define RAD2DEG(Rad)	((Rad) * 180.0 / M_PI)

#define BSPACE	8
#define TAB	9
#define LF	10
#define CR	13
#define ESC	27

#define PAGE_A4_XSIZE	1000	     /* Regular page size (8" Epson printer) */
#define PAGE_A4_YSIZE	640

/* Note the snap distance is also the scaler for libraries loaded in. */
#define DEFAULT_SNAP_DISTANCE	16		/* Distance to snap a point. */

#define DEFAULT_ZOOM_FACTOR	-2	         /* Zoom out by factor of 4. */
#define DEFAULT_ZOOM(v)		((v) >> 2)
#define DEFAULT_INV_ZOOM(v)	((v) << 2)

/* Macros to control coordinate to gird snapping in drawing space. */
#define EE_SNAP(x)		(((x + EESnapDistance / 2) / EESnapDistance) \
							   * EESnapDistance)

#define BOUNDARY_WIDTH		30

typedef enum {
    DRAW_POLYLINE_STRUCT_TYPE,
    DRAW_CONNECTION_STRUCT_TYPE,
    DRAW_TEXT_STRUCT_TYPE,
    DRAW_LIB_ITEM_STRUCT_TYPE,
    DRAW_PICK_ITEM_STRUCT_TYPE
} DrawStructureType;

typedef enum {
    TEXT_ORIENT_NON = -1,
    TEXT_ORIENT_HORIZ = GR_HORIZ_DIR,
    TEXT_ORIENT_VERT = GR_VERT_DIR
} TextOrientationType;

typedef struct DrawGenericStruct {
    DrawStructureType StructType;
    struct DrawGenericStruct *Pnext;
} DrawGenericStruct;

typedef struct DrawPolylineStruct {
    DrawStructureType StructType;
    struct DrawGenericStruct *Pnext;
    char Layer;
    char name[0x8];		/* If Wire conection, Name, else attrib */
    int NX,NY,Mode;		/* Name X,Y + Mode data for conection */
    int Flags;
    int Width;
    int NumOfPoints;		      /* Number of XY pairs in Points array. */
    int *Points;			/* XY pairs that forms the polyline. */
} DrawPolylineStruct;

typedef struct DrawConnectionStruct {
    DrawStructureType StructType;
    struct DrawGenericStruct *Pnext;
    char Layer;
    int PosX, PosY;			    /* XY coordinates of connection. */
} DrawConnectionStruct;

typedef struct DrawTextStruct {
    DrawStructureType StructType;
    struct DrawGenericStruct *Pnext;
    char Layer;
    int PosX, PosY, Scale;		    /* XY coordinates of connection. */
    TextOrientationType Orient;
    char *Text;
} DrawTextStruct;

typedef struct DrawLibItemStruct {
    DrawStructureType StructType;
    struct DrawGenericStruct *Pnext;
    TextOrientationType PartNameOrient, ChipNameOrient;
    char *PartName;      /* Name of part, i.e. "Op. Amp. 21". Not Chip Name. */
    char *ChipName;	   /* Key to look for in the library, i.e. "74LS00". */
    int PartNameX, PartNameY;		    /* Where PartName should be put. */
    int ChipNameX, ChipNameY;		    /* Where ChipName should be put. */
    int Multi;			 /* In multi unit chip - which unit to draw. */
    int Transform[2][2];       /* The rotation/mirror transformation matrix. */
    int PosX, PosY;				  /* Exact position of part. */
    int BBoxMinX, BBoxMaxX, BBoxMinY, BBoxMaxY;     /* BBox around the part. */
} DrawLibItemStruct;

typedef struct DrawPickedStruct { /* Holds structures picked by pick events. */
    DrawStructureType StructType;
    struct DrawPickedStruct *Pnext;
    DrawGenericStruct *PickedStruct;
} DrawPickedStruct;

typedef struct EEWindowStruct {
    int IntrLibWindowID;
    int PageXSize, PageYSize;
    BooleanType Modified;
    BooleanType IsFullSize;
    char FileName[FULL_PATH_LEN + FILE_NAME_LEN];
    char StatusL[0x18],StatusR[0x18];
    IntrBBoxStruct BBox;
    DrawGenericStruct *EEDrawList;       /* All objects of this file/window. */
    struct LayerStruct *Layer;
    struct EEWindowStruct *Pnext;
} EEWindowStruct;


typedef struct LayerStruct {
	char LayerNames[45][8];
	int  LayerColor[45];
	char LayerStatus[45];
	int  NumberOfLayers;
	int CurrentLayer;
	int CurrentWidth;
	int CommonColor;
	int Flags;
}LayerStruct;

typedef struct NetListStruct {
    char Pin[LINE_LEN_SHORT];
    struct NetListStruct *Pnext;
} NetListStruct;

extern int EEPageSizeX, EEPageSizeY; /* Clipping boundaries of current page. */
extern int EESnapDistance;       /* Distance to snap a point to current one. */
extern int EETextScale;		  /* Scaling factor for text string drawing. */
extern int EEWindowsFrameWidth;			   /* Width of all drawings. */
extern int EEListNumDisplayed;
extern int EERootWindowID;	    /* Intr_lib ID of the back ground color. */
extern int EERootWndwFrameColor;
extern int EERootWndwForeColor;
extern int EERootWndwBackColor;
extern int EERootWndwXorColor;
extern int EEPopUpFrameColor;         /* Color for the pop up menus/queries. */
extern int EEPopUpBackColor;
extern int EEPopUpForeColor;
extern int EEPopUpXorColor;
extern int EEActvWndwFrameColor;
extern int EEActvWndwForeColor;
extern int EEActvWndwBackColor;
extern int EEPsvWndwFrameColor;
extern int EEPsvWndwForeColor;
extern int EEPsvWndwBackColor;
extern int EEHighLightColor;
extern int EELayerWire;
extern int EELayerBus;
extern int EELayerGate;
extern int EELayerIEEE;
extern int EELayerPinFun;
extern int EELayerPinNam;
extern int EELayerPinNum;
extern int EELayerRefDes;
extern int EELayerAttr;
extern int EELayerDevice;
extern int EELayerNotes;
extern int EELayerNetNam;
extern int EELayerPin;
extern BooleanType EESubName; /* Control the sub naming of devices */
extern BooleanType EEAutoPan; /* Control auto panning in creation/placement. */
extern BooleanType EEHVLineDrawing;  /* Draw only horizontal/vertical lines. */
extern EEWindowStruct *EEActiveWindow, *EEWindowsList;
extern IntrBBoxStruct *EEActiveBBox;
/* extern LayerStruct *LayerPointer;	/* pointer in eelayer.h */

void PutCursorInActiveWindow(void);
VoidPtr MyMalloc(unsigned size);
void MyFree(VoidPtr);
void MyExit(int ExitCode);
void FatalError(char *ErrMsg);

#endif PROGRAM_H
