/*****************************************************************************
* VIRTRSTR.H - implementation of black and white virtual raster device.	     *
*									     *
* This program implements a virtual raster device of any size up to memory   *
* limit.								     *
*									     *
* Written by:  Gershon Elber				Ver 1.1, Aug. 1990   *
*****************************************************************************/

#ifndef VIRTRSTR_H
#define VIRTRSTR_H

#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif /* TRUE */

/******************************************************************************
* The following attributes must be consistent with TC graphics.h:	      *
* #define HORIZ_DIR	0						      *
* #define VERT_DIR	1						      *
* enum text_just {							      *
*	LEFT_TEXT	= 0,						      *
*	CENTER_TEXT	= 1,						      *
*	RIGHT_TEXT	= 2,						      *
*									      *
*	BOTTOM_TEXT	= 0,						      *
*       CENTER_TEXT	= 1,  already defined above.			      *
*	TOP_TEXT	= 2						      *
* };									      *
* enum line_widths {	Line widths for get/setlinestyle		      *
*	NORM_WIDTH  = 1,						      *
*	THICK_WIDTH = 3,						      *
* };									      *
******************************************************************************/

typedef enum {
    TEXT_ORIENT_NON  = -1,
    TEXT_ORIENT_HORIZ = 0,
    TEXT_ORIENT_VERT = 1
} TextOrientationType;

typedef enum {
    TEXT_X_LEFT    = 0,
    TEXT_X_CENTER  = 1,
    TEXT_X_RIGHT   = 2
} TextHorizJustifyType;

typedef enum {
    TEXT_Y_BOTTOM  = 0,
    TEXT_Y_CENTER  = 1,
    TEXT_Y_TOP     = 2
} TextVertJustifyType;

typedef enum {
    NORM_WIDTH	= 1,
    THICK_WIDTH	= 3
} TextWidthType;

int VirtInit(int x, int y);
void VirtClear(void);
void VirtClose(void);
void VirtMoveTo(int x, int y);
void VirtMoveRelTo(int x, int y);
void VirtLineTo(int x, int y);
void VirtLineRelTo(int x, int y);
void VirtLine(int x1, int y1, int x2, int y2);
void VirtBar(int x1, int y1, int x2, int y2);
void VirtCirc(int x, int y, int r);
void VirtArc(int x, int y, int r, int Angle1, int Angle2);
void VirtSetColor(int Color);
void VirtTextFormat(TextOrientationType Orient, int Scale,
		    TextHorizJustifyType XCenter, TextVertJustifyType YCenter);
void VirtText(char *Str);
int VirtTextWidth(char *Str);
int VirtTextHeight(char *Str);
int VirtGetPixel(int x, int y);
void VirtSetPixel(int x, int y);
void VirtGetBlock(int x1, int y1, int x2, int y2, char *Buffer);

#endif /* VIRTRSTR_H */
