/***************************************************************************/
/*           Vector.Hpp : The class Vector, which encapsulates             */
/*                        basic functioning of a Vector. Lots of           */
/*                        overloaded operators, very useful too.           */
/*                                                                         */
/*           By : Nikhil V.                     Dt. : 9/23/1997.           */
/***************************************************************************/
#ifndef VECTOR
#define VECTOR

#include <math.h>

class Vector {
	protected:
		double x, y, z;              // The components of the Vector.
	public:
		Vector() {                   // "Null" Constructor.
			x = y = z = 0;
			}

		Vector(double x1, double y1, double z1) {
			x = x1;                 // Initializes the instance to known
			y = y1;                 // values of the components.
			z = z1;
			}

		Vector(Vector &arg) {        // Initializes the instance to be
			x = arg.x;              // equal to another Vector.
			y = arg.y;
			z = arg.z;
			}

		double X() {                 // Returns the x component.
			return x;
			}

		double Y() {                 // Returns the y component.
			return y;
			}

		double Z() {                 // Returns the z component.
			return z;
			}

		double mod() {               // Returns the distance of that Vector
			return sqrt(x*x + y*y + z*z); // from the origin.
			}

		Vector operator =(Vector &arg) {
			x = arg.x;              // Equates 2 vectors.
			y = arg.y;
			z = arg.z;
			return *this;
			}

		Vector operator +(Vector &arg) {
			Vector temp;            // Adds 2 Vectors.
			temp.x = x + arg.x;
			temp.y = y + arg.y;
			temp.z = z + arg.z;
			return temp;
			}

		Vector operator -(Vector &arg) {
			Vector temp;            // Subtracts one Vector from another.
			temp.x = x - arg.x;
			temp.y = y - arg.y;
			temp.z = z - arg.z;
			return temp;
			}

		Vector operator *(double arg) {
			Vector temp(*this);     // Scaling.
			temp.x *= arg;
			temp.y *= arg;
			temp.z *= arg;
			return temp;
			}

		double operator *(Vector &arg) {
			double temp = 0;        // Scalar multiplication.
			temp += x*arg.x;
			temp += y*arg.y;
			temp += z*arg.z;
			return temp;
			}

		Vector operator ^(Vector &arg) {
			Vector temp;            // Vector Multiplication.
			temp.x = y*arg.z - z*arg.y;
			temp.y = z*arg.x - x*arg.z;
			temp.z = x*arg.y - y*arg.x;
			return temp;
			}

		Vector Normalize() {         // Normalizing the present instance.
			Vector temp;
			double len = sqrt(x*x + y*y + z*z);
			if(len) {
				temp.x = x/len;
				temp.y = y/len;
				temp.z = z/len;
				}
			return temp;
			}

		Vector operator !() {        // Negation.
			Vector temp;
			temp.x = -x;
			temp.y = -y;
			temp.z = -z;
			return temp;
			}
	};

#endif
/***************************************************************************/
