/***************************************************************************/
/*            Project.Cpp : Trying the classes out with a sample           */
/*                         program that also shows the way (which          */
/*                         is not exactly elegant) of using the            */
/*                         classes. Could have been much better.           */
/*                                                                         */
/*               By : Nikhil V.                  Dt. : 9/23/1997.          */
/***************************************************************************/

#include "mouse.h"
#include "utils.h"
#include "cube.hpp"
#include "window.hpp"

void help() {
	char string[80];
	restorecrtmode();
	FILE *HelpFile = fopen("HELP.TXT", "r");
	textcolor(YELLOW);
	textbackground(BLUE);
	clrscr();
	printf("Cube Magic v1.0 by Nikhil V.\n\n");
	while(!feof(HelpFile)) {
		fgets(string, 80, HelpFile);
		printf("%s", string);
		}
	fclose(HelpFile);
	getch();
	setgraphmode(getgraphmode());
	}

int main(void) {
	int gdriver = VGA, gmode = VGAHI, errorcode;
	initgraph(&gdriver, &gmode, "");  // Initialize the BGI graphics mode.
	errorcode = graphresult();
	if (errorcode != grOk) {
		printf("Graphics error: %s\n", grapherrormsg(errorcode));
		printf("Press any key to halt:");
		getch();
		exit(1);
		}

	if(!m_init()) {                   // Initialize the mouse driver.
		printf("Check the Mouse...\n");
		return -1;
		}

	struct palettetype pal;
	getpalette(&pal);
	setrgbpalette(pal.colors[M_BLACK], 0, 0, 0);

	// These are the changing parameters which define the position of the
	// viewer & position of the light.
	int Xang, Yang, Zang, Rot = 205, Tilt = 30, dist = 750;
	Xang = Yang = Zang = 0;
	int lightX = -100, lightY = 200, lightZ = 100;
	int Phi = 270 - Rot;
	int Theta = 90 - Tilt;
	Eye = Vector(sin(Theta*M_PI/180.0)*cos(Phi*M_PI/180.0),
			   sin(Theta*M_PI/180.0)*sin(Phi*M_PI/180.0),
			   cos(Theta*M_PI/180.0));
	Eye = Eye.Normalize();
	Light = Vector(lightX, lightY, lightZ);
	Light = Light.Normalize();

	// The screen window. defines the entire screen.
	Window Screen(0, 0, getmaxx(), getmaxy(), M_DARKGRAY, M_LIGHTGRAY);
	// Window showing the scene(the cube with axes)
	Window CubeWin(100, 50, 500, 450, BACKGROUND, M_BLACK);

	//TOP
	Button Exit(600, 10, 20, "X");         // 'Exit' button Windows style.

	Button Help(20, 10, 20, "Help F1");
	Button XRot(130, 10, 20, "X Axis");    // Rotation about X axis.
	Button YRot(230, 10, 20, "Y Axis");    // Rotation about Y axis.
	Button ZRot(330, 10, 20, "Z Axis");    // Rotation about Z axis.
	Button Rotate(440, 10, 20, "Viewer Rotate");    // Rotates the viewer.

	//LEFT
	Button Close(10, 100, 20, "CloseUp");
	Button Back(10, 150, 20, "Go Back");
	Button Up(20, 200, 20, "Go Up");
	Button Down(20, 250, 20, "Down");

	//RIGHT
	Button chLightXup(540, 100, 20, "Light X+");
	Button chLightXdn(540, 150, 20, "Light X-");    // Light position
	Button chLightYup(540, 200, 20, "Light Y+");    // changing buttons.
	Button chLightYdn(540, 250, 20, "Light Y-");
	Button chLightZup(540, 300, 20, "Light Z+");
	Button chLightZdn(540, 350, 20, "Light Z-");

	Screen << CubeWin;                // Insert all the objects belonging to
	Screen << Exit;                   // Screen into it.
	Screen << Help;
	Screen << XRot;
	Screen << YRot;
	Screen << ZRot;
	Screen << Rotate;

	Screen << Close;
	Screen << Back;
	Screen << Up;
	Screen << Down;

	Screen << chLightXup;
	Screen << chLightXdn;
	Screen << chLightYup;
	Screen << chLightYdn;
	Screen << chLightZup;
	Screen << chLightZdn;

	Cube c(6);                        // The cube to be displayed.

	Face f1(face1, 2, 4, dist);
	Face f2(face2, 3, 4, dist);
	Face f3(face3, 4, 4, dist);             // Define faces to be included in the
	Face f4(face4, 5, 4, dist);             // cube.
	Face f5(face5, 6, 4, dist);
	Face f6(face6, 9, 4, dist);
	c << f1;
	c << f2;
	c << f3;                          // Insert the faces into the cube.
	c << f4;
	c << f5;
	c << f6;

	Point p1(Vector(0, 0, 0));
	Point p2(Vector(300, 0, 0));      // To show the axes.
	Point p3(Vector(0, 300, 0));
	Point p4(Vector(0, 0, 300));

	Screen.show();                    // Display the screen.

	CubeWin.activate();               // Activate the cube window
	showaxes(p1, p2, p3, p4);         // show the axes &
	c.show();                         // the cube.
	CubeWin.deactivate();

	m_show();                         // Now show the mouse pointer.
	int x, y;                         // used to get the mouse position.

	double XM[3][3];                  // The transform matrices.

	while(1) {                        // Rudimentory event handler. Rather
		if(kbhit()) {                // than being pure event-driven,
			char ch = getch();      // this handler polls for the events.
			if(ch) break;           // In case of keyboard activity, quits
			ch = getch();           // if User doesnot want help.
			if(ch != 59) break;
			m_hide();
			help();
			setrgbpalette(pal.colors[M_BLACK], 0, 0, 0);
			Screen.show();                    // Display the screen.
			CubeWin.activate();               // Activate the cube window
			showaxes(p1, p2, p3, p4);         // show the axes &
			c.show();                         // the cube.
			CubeWin.deactivate();
			m_show();
			continue;
			}
		m_butt butt = (m_butt)m_status(x, y);
		if((Exit.click(x, y))&&(butt == LEFT)) {  // If mouse on the button
			m_hide();                            // & user has pressed the
			Exit.press();                        // left mouse button, then
			delay(100);                          // show the button pressed
			Exit.release();                      // & then release it after
			m_show();                            // waiting for 100 ms.
			break;
			}
		if((Help.click(x, y))&&(butt == LEFT)) {  // User wants help.
			m_hide();
			Help.press();
			delay(50);
			help();
			setrgbpalette(pal.colors[M_BLACK], 0, 0, 0);
			Screen.show();                    // Display the screen.
			CubeWin.activate();               // Activate the cube window
			showaxes(p1, p2, p3, p4);         // show the axes &
			c.show();                         // the cube.
			CubeWin.deactivate();
			Help.release();
			m_show();
			continue;
			}
		if((XRot.click(x, y))&&(butt == LEFT)) {  // The course of action is
			m_hide();                         // identical as far as
			XRot.press();                     // button is concerned.
			CubeWin.activate();               // Now, the transform matrix
			makeXMatrix(XAXIS, -Xang, XM);    // is created & the cube is
			c.update(XM);                     // transformed into a new
			Xang++;                           // position, with first
			makeXMatrix(XAXIS, Xang, XM);     // anticlockwise direction
			c.update(XM);                     // then clockwise direction.
			CubeWin.deactivate();
			CubeWin.show();                   // Showing the CubeWin erases
			CubeWin.activate();               // its earlier contents & now
			showaxes(p1, p2, p3, p4);         // ready to show new contents.
			c.show();                         // Draw the axes, & show the
			CubeWin.deactivate();             // cube with appropriate
			delay(25);                        // viewing parameters.
			XRot.release();
			m_show();
			continue;
			}
		if((YRot.click(x, y))&&(butt == LEFT)) {
			m_hide();
			YRot.press();
			CubeWin.activate();
			makeXMatrix(YAXIS, -Yang, XM);     // Ditto for rotation about
			c.update(XM);                      // Y axis.
			Yang++;
			makeXMatrix(YAXIS, Yang, XM);
			c.update(XM);
			CubeWin.deactivate();
			CubeWin.show();
			CubeWin.activate();
			showaxes(p1, p2, p3, p4);
			c.show();
			CubeWin.deactivate();
			delay(25);
			YRot.release();
			m_show();
			continue;
			}
		if((ZRot.click(x, y))&&(butt == LEFT)) {
			m_hide();
			ZRot.press();
			CubeWin.activate();
			makeXMatrix(ZAXIS, -Zang, XM);     // Again ditto for rotation
			c.update(XM);                      // Z axis.
			Zang++;
			makeXMatrix(ZAXIS, Zang, XM);
			c.update(XM);
			CubeWin.deactivate();
			CubeWin.show();
			CubeWin.activate();
			showaxes(p1, p2, p3, p4);
			c.show();
			CubeWin.deactivate();
			delay(25);
			ZRot.release();
			m_show();
			continue;
			}
		if((Rotate.click(x, y))&&(butt == LEFT)) {
			Rot++;                       // This changes the position of
			m_hide();                    // the viewer. The viewer goes
			Rotate.press();              // round the cube in anticlockwise
			CubeWin.activate();          // direction.
			c.changeAng(Rot, Tilt);
			CubeWin.deactivate();
			CubeWin.show();              // Erase previous window.
			CubeWin.activate();
			p1.changeAng(Rot, Tilt);
			p2.changeAng(Rot, Tilt);     // Change the orientation of the
			p3.changeAng(Rot, Tilt);     // axes.
			p4.changeAng(Rot, Tilt);
			c.changeAng(Rot, Tilt);      // Change the cube as well.
			int Phi = 270 - Rot;
			int Theta = 90 - Tilt;
			Eye = Vector(sin(Theta*M_PI/180.0)*cos(Phi*M_PI/180.0),
					   sin(Theta*M_PI/180.0)*sin(Phi*M_PI/180.0),
					   cos(Theta*M_PI/180.0));
			Eye = Eye.Normalize();
			showaxes(p1, p2, p3, p4);
			c.show();                    // Display new scene.
			CubeWin.deactivate();
			delay(20);
			Rotate.release();
			m_show();
			continue;
			}
		if((Up.click(x, y))&&(butt == LEFT)) {
			if(Tilt < 90) Tilt++;        // This changes the position of
			m_hide();                    // the viewer. The viewer goes
			Up.press();                  // Upward direction.
			CubeWin.activate();
			c.changeAng(Rot, Tilt);
			CubeWin.deactivate();
			CubeWin.show();              // Erase previous window.
			CubeWin.activate();
			p1.changeAng(Rot, Tilt);
			p2.changeAng(Rot, Tilt);     // Change the orientation of the
			p3.changeAng(Rot, Tilt);     // axes.
			p4.changeAng(Rot, Tilt);
			c.changeAng(Rot, Tilt);      // Change the cube as well.
			int Phi = 270 - Rot;
			int Theta = 90 - Tilt;
			Eye = Vector(sin(Theta*M_PI/180.0)*cos(Phi*M_PI/180.0),
					   sin(Theta*M_PI/180.0)*sin(Phi*M_PI/180.0),
					   cos(Theta*M_PI/180.0));
			Eye = Eye.Normalize();
			showaxes(p1, p2, p3, p4);
			c.show();                    // Display new scene.
			CubeWin.deactivate();
			delay(20);
			Up.release();
			m_show();
			continue;
			}
		if((Down.click(x, y))&&(butt == LEFT)) {
			if(Tilt > 0) Tilt--;         // This changes the position of
			m_hide();                    // the viewer. The viewer goes
			Down.press();                // in downward direction.
			CubeWin.activate();
			c.changeAng(Rot, Tilt);
			CubeWin.deactivate();
			CubeWin.show();              // Erase previous window.
			CubeWin.activate();
			p1.changeAng(Rot, Tilt);
			p2.changeAng(Rot, Tilt);     // Change the orientation of the
			p3.changeAng(Rot, Tilt);     // axes.
			p4.changeAng(Rot, Tilt);
			c.changeAng(Rot, Tilt);      // Change the cube as well.
			int Phi = 270 - Rot;
			int Theta = 90 - Tilt;
			Eye = Vector(sin(Theta*M_PI/180.0)*cos(Phi*M_PI/180.0),
					   sin(Theta*M_PI/180.0)*sin(Phi*M_PI/180.0),
					   cos(Theta*M_PI/180.0));
			Eye = Eye.Normalize();
			showaxes(p1, p2, p3, p4);
			c.show();                    // Display new scene.
			CubeWin.deactivate();
			delay(20);
			Down.release();
			m_show();
			continue;
			}
		if((Close.click(x, y))&&(butt == LEFT)) {
			if(dist > 250) dist -= 10;   // This takes the viewer closer
			m_hide();                    // to the cube.
			Close.press();
			CubeWin.activate();
			CubeWin.deactivate();
			CubeWin.show();              // Erase previous window.
			CubeWin.activate();
			p1.chDist(dist);  //
			p2.chDist(dist);  //angeAng(Rot, Tilt);     // Change the orientation of the
			p3.chDist(dist);  //angeAng(Rot, Tilt);     // axes.
			p4.chDist(dist);  //angeAng(Rot, Tilt);
			c.chDist(dist);  //ngeAng(Rot, Tilt);      // Change the cube as well.
			showaxes(p1, p2, p3, p4);
			c.show();                    // Display new scene.
			CubeWin.deactivate();
			delay(20);
			Close.release();
			m_show();
			continue;
			}
		if((Back.click(x, y))&&(butt == LEFT)) {
			if(dist < 1000) dist += 10;  // This takes the viewer closer
			m_hide();                    // to the cube.
			Back.press();
			CubeWin.activate();
			CubeWin.deactivate();
			CubeWin.show();              // Erase previous window.
			CubeWin.activate();
			p1.chDist(dist);  //
			p2.chDist(dist);  //angeAng(Rot, Tilt);     // Change the orientation of the
			p3.chDist(dist);  //angeAng(Rot, Tilt);     // axes.
			p4.chDist(dist);  //angeAng(Rot, Tilt);
			c.chDist(dist);  //ngeAng(Rot, Tilt);      // Change the cube as well.
			showaxes(p1, p2, p3, p4);
			c.show();                    // Display new scene.
			CubeWin.deactivate();
			delay(20);
			Back.release();
			m_show();
			continue;
			}
		if((chLightXup.click(x, y))&&(butt == LEFT)) {
			lightX += 10;
			Light = Vector(lightX, lightY, lightZ);
			Light = Light.Normalize();
			m_hide();
			chLightXup.press();          // Changes the light position in
			CubeWin.show();              // the positive X direction.
			CubeWin.activate();
			showaxes(p1, p2, p3, p4);
			c.show();
			CubeWin.deactivate();
			delay(20);
			chLightXup.release();
			m_show();
			continue;
			}
		if((chLightXdn.click(x, y))&&(butt == LEFT)) {
			lightX -= 10;                // Ditto in negetive X direction.
			Light = Vector(lightX, lightY, lightZ);
			Light = Light.Normalize();
			m_hide();
			chLightXdn.press();
			CubeWin.show();
			CubeWin.activate();
			showaxes(p1, p2, p3, p4);
			c.show();
			CubeWin.deactivate();
			delay(20);
			chLightXdn.release();
			m_show();
			continue;
			}
		if((chLightYup.click(x, y))&&(butt == LEFT)) {
			lightY += 10;                // Ditto in positive Y direction.
			Light = Vector(lightX, lightY, lightZ);
			Light = Light.Normalize();
			m_hide();
			chLightYup.press();
			CubeWin.show();
			CubeWin.activate();
			showaxes(p1, p2, p3, p4);
			c.show();
			CubeWin.deactivate();
			delay(20);
			chLightYup.release();
			m_show();
			continue;
			}
		if((chLightYdn.click(x, y))&&(butt == LEFT)) {
			lightY -= 10;                // Ditto in negetive Y direction.
			Light = Vector(lightX, lightY, lightZ);
			Light = Light.Normalize();
			m_hide();
			chLightYdn.press();
			CubeWin.show();
			CubeWin.activate();
			showaxes(p1, p2, p3, p4);
			c.show();
			CubeWin.deactivate();
			delay(20);
			chLightYdn.release();
			m_show();
			continue;
			}
		if((chLightZup.click(x, y))&&(butt == LEFT)) {
			lightZ += 10;                // Ditto in positive Z direction.
			Light = Vector(lightX, lightY, lightZ);
			Light = Light.Normalize();
			m_hide();
			chLightZup.press();
			CubeWin.show();
			CubeWin.activate();
			showaxes(p1, p2, p3, p4);
			c.show();
			CubeWin.deactivate();
			delay(20);
			chLightZup.release();
			m_show();
			continue;
			}
		if((chLightZdn.click(x, y))&&(butt == LEFT)) {
			lightZ -= 10;                // Ditto in negetive Z direction.
			Light = Vector(lightX, lightY, lightZ);
			Light = Light.Normalize();
			m_hide();
			chLightZdn.press();
			CubeWin.show();
			CubeWin.activate();
			showaxes(p1, p2, p3, p4);
			c.show();
			CubeWin.deactivate();
			delay(20);
			chLightZdn.release();
			m_show();
			continue;
			}
		}

	closegraph();
	return 0;
	}

/***************************************************************************/
