;Output a string to StdErr.
;Program Author: David Kirschbaum, Toad Hall
;
;Declare as follows:
;	{$F+}
;	{$L STDERR}
;	PROCEDURE Write_StdErr(S : STRING); EXTERNAL;
;
;Courtesy of Toad Hall


;Total stack (caller's plus work stack)
cstk	STRUC
bpsave	dw	0			;save BP here
retaddr	dd	0			;points to return address
straddr	dd	0			;points to string address
cstk	ENDS

PARAMSIZE	EQU SIZE straddr	;size of parameter list

PUBLIC	Write_StdErr			;procedure name declaration

CODE	SEGMENT PARA PUBLIC 'CODE'
	ASSUME	CS:CODE

;Entry point to PosCH function

Write_StdErr	proc	FAR
	push	bp
	mov	bp,sp

	mov	di,DS			;save caller's DS

	cld
	lds	si,[bp.straddr]		;string
	xor	ah,ah			;clear msb
	lodsb				;length byte, bump SI
	mov	cx,ax			;length into CX
	jcxz	No_Write		;empty string, forget it

	mov	dx,si			;DS:DX -> DTA
	mov	bx,2			;STDERR
	mov	ah,40H			;Write to file/device
	int	21H

No_Write:
	mov	DS,di			;restore caller's DS

	mov	sp,bp			;recover last stack psn
	pop	bp			;recover BP
	ret	PARAMSIZE

Write_StdErr	ENDP

CODE	ENDS
	END
