@echo off
goto 00_Start
###############################################################################

DEMO.BAT - demonstrate CMP software with the supplied sample files

To execute this demo, the sample files must be in the current directory.
Usage:
        DEMO
or:
        DEMO filename
If a filename is specified, the demo will run non-interactively and output will
be written to the named file. This is part of the actual regression tests.

2001-02-26  author: Stan Brown, Oak Road Systems
2001-02-27  Check free environment space and display a useful message.
            Offer the option to rerun each part of the demo.
2001-03-01  Allow an optional first parameter for redirecting all output.
2001-04-08  Add a demo of debugging output.
2001-12-16  Pause between command and output in demo #2.

                 Copyright 2001   Stan Brown, Oak Road Systems
                           http://oakroadsystems.com
###############################################################################
:00_Start
set X=01234567890123456789012345678901234567890123456789
if "%X%" == "01234567890123456789012345678901234567890123456789" goto 01_EnvOK
set X=
echo.
echo This demo needs about 50 bytes of free environment space, but
echo less than that is available. Try running it in a secondary shell
echo and specifying environment space, like this:
echo           %%comspec%% /e:8192 /c %0
echo The figure of 8192 is just an example. Use a large enough number,
echo which depends on how much environment space you are already using.
echo If you have a SHELL statement in C:\CONFIG.SYS use that number
echo plus 50 or so; otherwise try /e:1024.
echo.
goto 99_Exit
:01_EnvOK
if "%2" == "" goto 02_ParamsOK
echo.
echo You invoked this batch file with two or more parameters. In normal
echo use it takes no parameters; the only optional parameter is a file
echo name for output.
echo.
goto 99_Exit
:02_ParamsOK
echo Welcome to this demo of the CMP program from Oak Road Systems.
if not "%1" == "" goto 03_CheckDir
echo.
echo You need about 100 KB (kilobytes, not megabytes) free space on
echo your disk. Also, the DOS program MORE.COM needs to be somewhere
echo in your PATH. If you have a normal DOS or WINDOWS installation,
echo the MORE program is already present in the right place.
:03_CheckDir
if not exist ALICE1 goto 09_WrongDir
if not exist ALICE2 goto 09_WrongDir
if not exist ALICE3 goto 09_WrongDir
if exist CMP16.EXE goto 10_CorrectDir
if exist ..\CMP16.EXE copy ..\CMP16.EXE >nul
if exist CMP16.EXE goto 10_CorrectDir
echo Can't find CMP16.EXE. Please make sure you are running from the
echo right directory (the one that contains the demo files). If you
echo have moved files after unpacking the zip file, please copy
echo CMP16.EXE to the current directory and run this demo again.
echo.
goto 99_Exit
:09_WrongDir
echo Before running this demo, you must first issue a 'CD' command to
echo get to the directory that contains the supplied demo files.
echo.
goto 99_Exit
:10_CorrectDir
if not exist CMPTEMP\* goto 15_MakeDir
echo The subdirectory CMPTEMP exists, probably left over from a
echo previous demo that was stopped in the middle.
choice /c:ny /n "Is it okay to delete it? "
if not errorlevel 2 goto 99_Exit
echo y|del CMPTEMP >nul
goto 16_CopyFiles
:15_MakeDir
md CMPTEMP
:16_CopyFiles
copy ALICE1 CMPTEMP\ALICE2 >nul
copy ALICE2 CMPTEMP\ALICE1 >nul
if "%1" == "" goto 20_BeginDemo
echo Output of "%0 %1" >%1
echo ====================================================================== >>%1
echo.>>%1
echo. | date >>%1
echo.>>%1
cmp16 -d- >>%1
echo.>>%1
echo.>>%1
:20_BeginDemo

if not "%1" == "" goto Demo1
echo.
echo.
echo NOTE: Every CMP command in this demo uses the /z option. That's
echo always a good idea in a batch file, so that any setting of the
echo environment variable is disregarded and the options in effect are
echo only those on the command line.
echo.
echo CMP options are marked with a leading / or - character, and can be
echo specified in capitals or lower case.
echo.
echo.
echo.
echo DEMO #1 (of 6 parts): A few differences in traditional and UNIX formats.
choice /c:ny /n "Do you want to see this part of the demo? "
if not errorlevel 2 goto End1
:Demo1
set X=cmp16 -z alice1 alice2
if "%1" == "" goto Mid1A
echo ====================================================================== >>%1
echo %X% >>%1
echo ====================================================================== >>%1
%X% >>%1
echo. >>%1
echo. >>%1
goto :Mid1B
:Mid1A
echo %X%
pause
%X%|more
echo.
echo The above was traditional format, with line numbers on each line
echo reported. Now for UNIX format, which shows groups of lines as
echo added, changed, or deleted.
echo.
:Mid1B
set X=%X% -u
if "%1" == "" goto Mid1C
echo ====================================================================== >>%1
echo %X% >>%1
echo ====================================================================== >>%1
%X% >>%1
echo. >>%1
echo. >>%1
goto Demo2
:Mid1C
echo %X%
pause
%X%|more
choice /c:ny /n "Do you want to repeat this part of the demo? "
if errorlevel 2 goto Demo1
:End1

echo.
echo DEMO #2 (of 6 parts): multiple file compare
choice /c:ny /n "Do you want to see this part of the demo? "
if not errorlevel 2 goto End2
:Demo2
set X=cmp16 -z alice* CMPTEMP /a2f3
if "%1" == "" goto Mid2A
echo ====================================================================== >>%1
echo %X% >>%1
echo ====================================================================== >>%1
%X% >>%1
echo. >>%1
echo. >>%1
goto Demo3
:Mid2A
echo.
echo The /a2 option is used to limit reports to the first two differences.
echo The /f3 option displays line numbers right justified in 4 columns, so
echo that the reported lines all line up vertically.
echo.
echo %X%
echo.
pause
echo.
%X%|more
choice /c:ny /n "Do you want to repeat this part of the demo? "
if errorlevel 2 goto Demo2
:End2

echo.
echo DEMO #3 (of 6 parts): binary file compare /R with formatting options
choice /c:ny /n "Do you want to see this part of the demo? "
if not errorlevel 2 goto End3
:Demo3
set X=cmp16 -z alice1 alice3 /rw40 /if4 /2
if "%1" == "" goto Mid3A
echo ====================================================================== >>%1
echo %X% >>%1
echo ====================================================================== >>%1
%X% >>%1
echo. >>%1
echo. >>%1
goto Demo4
:Mid3A
echo.
echo The /r option specifies comparing in binary mode. (It so happens that
echo the sample files are text, so the /R option disregards line boundaries.)
echo The /w40 option specifies blocks of 40 characters.
echo The /i opton suppresses differences between capitals and lower case.
echo The /f4 option displays line numbers right justified in 4 columns, so
echo that the reported lines all line up vertically.
echo The /2 option says to make the older file file 1 and the newer one file 2.
echo.
echo Non-printing characters will be shown as hex values in angle brackets.
echo.
echo %X%
pause
%X%|more
choice /c:ny /n "Do you want to repeat this part of the demo? "
if errorlevel 2 goto Demo3
:End3

echo.
echo DEMO #4 (of 6 parts): resync /L,__
choice /c:ny /n "Do you want to see this part of the demo? "
if not errorlevel 2 goto End4
:Demo4
set X=cmp16 -z alice1 alice2 -u
if "%1" == "" goto Mid4A
echo ====================================================================== >>%1
echo %X% >>%1
echo ====================================================================== >>%1
%X% >>%1
echo. >>%1
echo. >>%1
goto Mid4B
:Mid4A
echo.
echo The resync value (second parameter on the /L option) can have a great
echo impact on the quality of the difference reports. Here is an illustration
echo of how the same compare can look different with different resync values.
echo (The user guide goes into a lot of detail about how you can set the resync
echo threshold to make more meaningful comparisons.)
echo.
echo First let's look at a compare with the default resync of 2. This value
echo is used by CMP unless you specify otherwise, and it's usually a
echo reasonable choice.
echo.
echo %X%
pause
%X%|more
echo.
echo Notice that the differences were reported in 9 difference blocks.
echo.
echo Now let's try that again with a resync of 1 (/L,1 option). (This is
echo how CMP behaved up through release 4.3.) Note that you will get a lot of
echo smaller difference blocks, 18 of them in fact.
echo.
:Mid4B
set X=%X% /L,1
if "%1" == "" goto Mid4C
echo ====================================================================== >>%1
echo %X% >>%1
echo ====================================================================== >>%1
%X% >>%1
echo. >>%1
echo. >>%1
goto Demo5
:Mid4C
echo %X%
pause
%X%|more
echo.
echo For these particular files, the default resync of 2 was a better choice.
echo For other files, a different resync may be better. See the user guide
echo section "Difference Blocks and Look-Ahead" for more discussion of this
echo point.
choice /c:ny /n "Do you want to repeat this part of the demo? "
if errorlevel 2 goto Demo4
:End4

echo.
echo DEMO #5 (of 6 parts): comparison options /B, /E, /I
choice /c:ny /n "Do you want to see this part of the demo? "
if not errorlevel 2 goto End5
:Demo5
set X=cmp16 -z alice1 alice2 -u
if "%1" == "" goto Mid5A
echo ====================================================================== >>%1
echo %X% >>%1
echo ====================================================================== >>%1
%X% >>%1
echo. >>%1
echo. >>%1
goto Mid5B
:Mid5A
echo.
echo Ordinarily, CMP compares files for exact equality. But you can tell it
echo to disregard added or deleted blank lines (/e option), differences of
echo capitals and lower case (/i option), and different runs of blanks or
echo tabs within a line (/b option). Depending on the file contents, this
echo will often cause CMP to report fewer differences.
echo.
echo First look at an exact comparison.
echo.
echo %X%
pause
%X%|more
echo.
echo You see there were 9 difference blocks, and the report was four screens
echo long (assuming a 25-line screen).
echo.
echo Now let's try that again with the /b, /e, and /i options.
:Mid5B
set X=%X% /bei
if "%1" == "" goto Mid5C
echo ====================================================================== >>%1
echo %X% >>%1
echo ====================================================================== >>%1
%X% >>%1
echo. >>%1
echo. >>%1
goto Mid5D
:Mid5C
echo %X%
pause
%X%|more
echo.
echo This time you see that there were only 7 difference blocks, and
echo the report was about 25%% shorter. If it's appropriate for your
echo application, these options (or any of them) will suppress
echo nonessential differences.
echo.
echo.
echo When files compare identical and you've used an option to suppress
echo some kinds of differences, you get a different summary message. To
echo illustrate this, let's compare a file to itself, first without /E and
echo then with that option. Look at the different equality messages:
echo.
pause
:Mid5D
set X=cmp16 -z alice1 alice1
if "%1" == "" goto Mid5E
echo ====================================================================== >>%1
echo %X% >>%1
echo ====================================================================== >>%1
%X% >>%1
echo. >>%1
echo. >>%1
goto Mid5F
:Mid5E
echo %X%
%X%
echo.
echo.
:Mid5F
set X=%X% /E
if "%1" == "" goto Mid5G
echo ====================================================================== >>%1
echo %X% >>%1
echo ====================================================================== >>%1
%X% >>%1
echo. >>%1
echo. >>%1
goto Demo6
:Mid5G
echo %X%
%X%
echo.
echo As you can see, when you have an option to suppress some
echo differences CMP says that the files are "effectively identical"
echo rather than "identical".
echo.
choice /c:ny /n "Do you want to repeat this part of the demo? "
if errorlevel 2 goto Demo5
:End5

echo.
echo DEMO #6 (of 6 parts): debugging output (long)
choice /c:ny /n "Do you want to see this part of the demo? "
if not errorlevel 2 goto End6
:Demo6
set X=cmp16 -z alice1 alice2 /ib /d-
if "%1" == "" goto Mid6A
echo ====================================================================== >>%1
echo %X% >>%1
echo ====================================================================== >>%1
%X% >>%1
echo. >>%1
echo. >>%1
goto Demo7
:Mid6A
echo.
echo The /d option turns on debugging output, to display the values of all
echo options, the files found (or expected but not found), and the internals
echo of the comparison process. To reduce the number of differences found
echo we'll use the /I option (ignore case) and the /B option (all runs of
echo blanks and tabs are equal).
echo.
echo Look for the messages "resync aborted". That is where, after a difference
echo between the two files, CMP finds two lines that match, but then another
echo difference within the resync threshold. (The user guide goes into a lot
echo of detail about how you can set the resync threshold to make more
echo meaningful comparisons, and there were more examples in Demo #4.)
echo.
echo %X%
pause
%X%|more
choice /c:ny /n "Do you want to repeat this part of the demo? "
if errorlevel 2 goto Demo6
:End6

:Demo7

if not "%1" == "" goto 90_Cleanup
echo.
echo.
echo This concludes the demo of CMP. Thanks for viewing!
echo.
echo The user guide should answer most of your questions, but if you can't
echo find your answers there please feel free to write to
echo                    support@oakroadsystems.com
echo Everyone's questions will be answered, but registered users receive
echo priority in support.
echo.

:90_Cleanup
set X=
if exist ..\CMP16.EXE del CMP16.EXE >nul
if not exist CMPTEMP\* goto 99_Exit
echo y | del CMPTEMP >nul
rd CMPTEMP
:99_Exit
rem :: vim: ic tw=0 comments=n\:\:\:,n\:echo,n\:rem
