{                 Alternative viewer for Norton Commander 4.0                 }
{                                                                             }
{       Copyright (C) 1994, 1995 Tom Hajn, XHajT03@vse.cz on Internet      }
{                                                                             }
{  Unit Spawno (swapping itself from conventional memory when calling viewer; }
{  only approximately 400 bytes remains !!!) Copyright (C) 1990-2 Ralf Brown, }
{    ralf@cs.cmu.edu - many thanks for this. Source code (C and assembler)    }
{              available on Simtel and its mirrors (directory C).             }
{                                                                             }
{      Original compilation with BP 7.0 and a fast replacement library,       }
{      Copyright (C) 1988-1994 Norbert Juffa, norbert@iit.com - thanks.       }
{         Available on Simtel and its mirrors (directory TurboPas).           }
{                                                                             }
{   You may freely use and distribute this program. If you wish to modify it, }
{ you must let the user know that the code has been changed and you must keep }
{ my name here. You can't sell neither the program nor anything based on my   }
{ code. (Do you like FSF's rules? Me too - they're great!)                    }
{   Everybody distributing the program must be able to distribute this source }
{ file as well.                                                               }
{   This program is a solution for users of NC 4.0, as well as for users of   }
{ some archive viewers those call one viewer for every file in the archive.   }
{   Feel free to use e-mail adress above if you have any questions, problems  }
{ or suggestions.                                                             }
{                                                                             }
{      1) Installation                                                        }
{                                                                             }
{   The program breaks the limit of 10 viewers for NC 4.0. You simply remove  }
{ one of the viewers in your NC.CFG file (you don't lose this viewer, because }
{ you can write it later into the ALTVIEW.CFG), then write new section for    }
{ this 'viewer' (~ALTVIEW.EXE) AFTER (!) wpview.exe (i.e. it will be the last }
{ one except two graphic viewers) and move the $*.* specification from the    }
{ section of ~WPVIEW.EXE to this new section. The program (like other viewers }
{ in NC 4.0) must reside in the directory of NC, as well as the configuration }
{ file, i.e. file with the same name and the extension .CFG.                  }
{                                                                             }
{      2) Configuration file                                                  }
{                                                                             }
{   The structure of the configuration file is similar as in NC.CFG of NC 4.0 }
{ (i.e. it's a text file editable by any editor). Every line not beginning    }
{ with '~', '$', '%', '+' or '&' is ignored. Characters '~' and '%' must be   }
{ immediately followed with a name of the viewer (without spaces and path!).  }
{ The following line(s) starting with characters '$', '+' and '&' up to       }
{ another '~' or '%' characters are the patterns of files for this viewer     }
{ (e.g. $*.ext). If there is more than one pattern matching the viewed file,  }
{ the first one is used; the exception is the case of '&' at the begin of the }
{ line - then you can select one of all viewers having pattern matching the   }
{ viewed file. Use a '%' before a viewer name when you use it from NC 4.0 and }
{ the viewer doesn't have enough memory - normally viewers are called from    }
{ NCMAIN.EXE; in case of '%', a temporary batch file is created and then      }
{ called from command line - this causes NCMAIN.EXE to be terminated (not     }
{ NC.EXE) and then reloaded. If you use a '+' character before the pattern,   }
{ only a file name is given to the viewer, not full path (e.g. MODPLAY needs  }
{ this - don't ask me why). The last viewer should be WPVIEW.EXE with pattern }
{ $*.* for files not matching any other pattern.                              }
{                                                                             }
{      3) Limitations                                                         }
{                                                                             }
{   Yes, there are problems (known). If compiled with SPAWNO, it is no longer }
{ possible to use Quick view (in NC); it's a bug in SPAWNO and I can't do     }
{ anything against that. As well, NC doesn't know, it should load another     }
{ viewer when Quick view is open and you move the cursor from one to another  }
{ file and both are handled by ALTVIEW, i.e. it uses the same viewer for all  }
{ files as long as you don't move the cursor to the file handled by another   }
{ viewer (but I don't know viewers able to handle Quick view except the       }
{ original ones - if you do, let me know about them) or to the directory. It  }
{ is NC's behaving - not ALTVIEW's. Another not very pleasant thing is that   }
{ after viewing a file with a viewer called from temporary batch file         }
{ (viewers which need more memory) the cursor isn't more on its original      }
{ position but goes to the top of the directory. The only way how to change   }
{ this is creating the batch file in some directory on the path (e.g. in the  }
{ directory of NC as it was in previous release) - then there would be no     }
{ need to change the current directory and this wouldn't occur; but I feel it }
{ is not very 'clear' to write temporary files into directory of executables  }
{ and in many cases this directory may be read only (e.g. on LANs, or when    }
{ somebody has set Disk Manager partitions read only). That's why I think     }
{ it's better to do this this way - if you think something else about this    }
{ (or have other idea how to solve this), send me an e-mail message. And,     }
{ last, but not least, I know there is a 'limitation' in my English and there }
{ are many mistakes in this documentation - excuse me for that.               }
{                                                                             }
{      4) Changes in this version (from 1.40, first "official" release)       }
{                                                                             }
{ - You can press ESC or F10 to end the selection of the viewer and exit      }
{  immediately.                                                               }
{ - Fixed a (possible, but very unlikely) problem with temporary file set to  }
{  Read only.                                                                 }
{ - Fixed a bug with naming of temporary batch file; '{' is used when viewed  }
{  file has no extension.                                                     }
{ - The batch file is now created in temporary (or current if neither TEMP    }
{  nor TMP system variables are set) directory, not in that of ALTVIEW. (Have }
{  someone already told you, it is good to have at least one of these         }
{  variables set to select a directory for all temporary files, and to delete }
{  the contents of it - files possibly staying here - every time you start up }
{  your computer - i.e. from AUTOEXEC? Useful not only for Altview, but       }
{  generally - NC uses this variable as well, DOS too; ... well, YOU probably }
{  knew it, but there could be somebody ...).                                 }
{ - It is checked if all writes to batch file were succesful - if not (e.g.   }
{  due not enough space on the disk), the batch file is erased.               }
{ - Color and other settings from NC now used when selecting a viewer.        }
{ - Fixed a small bug in searching for configuration file.                    }
{ - Better checking if it is safe to use "raw" extended memory (without XMS)  }
{  for swapping, i.e. if not under MS Windows.                                }
{ - It is now possible to specify a batch file as a viewer in ALTVIEW.CFG     }
{  (but there is no way how to give all parameters including the color setup  }
{  and Quick view status from NC to the viewer called from the batch file -   }
{  well, of course there is a way, but it's very very dirty); if your viewer  }
{  called from the batch files needs these parameters, it's better to write   }
{  a small program, which does everything what should do the batch file, and  }
{  then executes the viewer with all its parameters.                          }
{ - You doesn't have to specify the extension of the viewer any more - in     }
{  this case the normal DOS order of searching for the executables is used    }
{  (COM, EXE, BAT).                                                           }
{ - Made it possible to specify additional parameters for the viewer after    }
{  its name.                                                                  }
{ - Added support for mouse (when selecting a viewer).                        }
{                                                                             }
{                                                     That's all.             }
{                                                                             }
{ Of course, there is no warranty, either express or implied, about this      }
{ program and you use it at your own risk. (Stupid message, but who knows...) }

program AltView;
{ $DEFINE QUICKVIEW} (* if you delete the space before '$', the program will *)
                     (* have less memory to execute viewers, but it will be  *)
                     (* able to use Quick view in NC - see above             *)
{$IFNDEF QUICKVIEW}
{$M 4096,73000,73000}
{$ELSE}
{$M 4096,98000,98000}
{$ENDIF}
(* so much memory allocated to ensure, at least wpview can be started;       *)
(* you can change this number if you use another text viewer - but be sure   *)
(* to have enough memory for handling dynamically allocated variables, i.e.  *)
(* the list of viewers possible for particular file extension                *)

{$G+,A+,R-,S-,B-,F-,L-,V-}
{$D-}

uses
{$IFNDEF QUICKVIEW}
 Spawno,
{$ENDIF}
 Crt, Dos, Memory;
(* procedure SetMemTop (allocates and deallocates heap memory) is in unit   *)
(* Memory from Turbo Vision; if you replace this routine, you don't need    *)
(* this unit and you can compile the program with TP prior to version 6.0   *)
(* (but at least 5.0 - I think, TP 4.0 doesn't have environment handling)   *)

type
 FileStr = string [12];
 PVRec = ^VRec;
 VRec = record
  VName: FileStr;
  Next: PVRec;
  Pars: string [20];
  Big: boolean;
 end;
 TPB = ^byte;
 CRec = record
  TF, TB, CF, CB, FF: byte;
 end;

var
 VideoMode: byte absolute 0:$0449;
 R: Registers;
 Cfg: text;
 B: text;
 T: file;
 TPath, TName: PathStr;
 Pars: string [20];
 ODir: DirStr;
 CfgName: PathStr;
 Dir, OwnDir: DirStr;
 Name: NameStr;
 Ext, VExt: ExtStr;
 Viewer: PathStr;
 I, J, Y: byte;
 SR: SearchRec;
 EnvPath: string;
 Pattern: string;
 FName: PathStr;
 VName: PathStr;
 BV: PathStr;
 VA: array [1..5] of FileStr;
 OldX, OldY, OldC, OldB: byte;
 XX: string;
 Status: integer;
 ParP: pointer;
 PB: TPB absolute ParP;
 ContStr2: string [2];

const
 Found: boolean = false;
 Sec: boolean = false;
 Params: string = '';
 Line: string = '';
 ContStr1: string [3] = '$&+';
 ViewStr: string [2] = '~%';
 EditStr: string [1] = '@';
 VNum: word = 0;
 First: PVRec = nil;
 Act: PVRec = nil;
 Big: boolean = false;
 Direct: boolean = false;
 ExtKey: char = #0;
 IsMouse: boolean = false;
 Button: byte = 1;
 CI: byte = 1;
 CArray: array [0..3] of CRec = ((TF:  7; TB: 0; CF:  0; CB: 7; FF: 15),
                                 (TF: 11; TB: 1; CF:  0; CB: 3; FF: 14),
                                 (TF:  7; TB: 0; CF:  0; CB: 7; FF: 15),
                                 (TF: 15; TB: 1; CF: 15; CB: 3; FF: 10));
                              (* ^^^ four color combinations from NC 4.0 *)

function ExtKeyPressed: boolean;   (* 'key' is here as well e.g. a shift *)
var
 Is: boolean;
 Shifts1: byte absolute $40:$17;   (* shift status as set by BIOS *)
 Shifts2: byte absolute $40:$18;   (* (extended and normal)       *)
begin
 Is := false;
 asm
  mov ah, 11h
  int 16h
  jz @@1
  mov [Is], true
  mov ah, 10h
  int 16h
@@1:
 end;
 ExtKeyPressed := Is or (Shifts1 and $0F <> 0) or (Shifts2 <> 0);
end;

procedure LookT;
var
 DW, HS: word;
 DT: DateTime;
 L, M: Longint;
begin
 if ((WhereX = (Lo (WindMax) div 2) + 2) or (WhereX = 1)) and
            (WhereY = Hi (WindMax) - 1) or (Length (Params) >= 18) and
                                         (Params [18] = '(') then Sec := true;
{$I-}                           (* ^^^ started as Quick view ^^^ *)
 Reset (T);
 if IOResult = 0 then           (* there is already a temporary file *)
 begin
  GetFTime (T, L);
  with DT do
  begin
   GetDate (Year, Month, Day, DW);
   GetTime (Hour, Min, Sec, HS);
  end;
  PackTime (DT, M);
  if M - L > 4096 then   (* temporary file older than 4 hours - it must have *)
  begin                  (* remained after a system crash or a forced ending *)
   TName [byte (TName [0]) + 1] := #0;           (* of some previous calling *)
   Inc (TName [0]);                              (* - rewrite or reuse it    *)
   asm
    mov dx, OFFSET TName      (* setting attribute of the old temporary file *)
    mov ah, 43h               (* to normal; for the case, somebody has set   *)
    mov al, 1                 (* it read only - maybe a small joke or        *)
    mov cx, 0                 (* an inadvertancy                             *)
    int 21h
   end;
   Dec (TName [0]);
   if Sec = true then
   begin
    Close (T);
    Erase (T);
   end else SetFTime (T, M);
  end else Sec := true;
  Close (T);
 end else
 begin
  if Sec = false then
  begin
   Rewrite (T);
   Close (T);
  end;
 end;
 L := IOResult;
{$I+}
end;

procedure WriteStrDos (X: string);       (* enables redirection - WriteLn *)
begin                                    (* handled by Crt unit           *)
 XX := X + '$';
 asm
  mov ah, 9
  mov dx, OFFSET XX
  inc dx
  int 21h
 end;
end;

procedure NoCfg;
begin
 WriteStrDos ('Cannot open ' + CfgName);
 WriteLn;
 repeat until (ExtKeyPressed);
 Halt (3);
end;

procedure DelT;
begin
 if not (Sec) then
 {$I-}
 Erase (T);
 {$I+}
end;

procedure Disp;                     (* disposing allocated memory - if any *)
begin
 while First <> nil do
 begin
  Act := First^.Next;
  Dispose (First);
  First := Act;
 end;
end;

{$IFNDEF QUICKVIEW}
function SwapType: byte;
begin
 R.AX := $1600;
 Intr ($2F, R);
 if R.AL <> 0 then SwapType := Swap_All xor Swap_Ext else
 begin
  R.AX := $160A;                 (* cannot use swapping into "raw" extended *)
  R.BX := 0;                     (* memory (without XMS) under MS Windows   *)
  Intr ($2F, R);
  if (R.AX = 0) and (R.BH <> 0) then SwapType := Swap_All xor Swap_Ext
                                                    else SwapType := Swap_All;
 end;
end;
{$ENDIF}

function Which: FileStr;           (* manual selection of the right viewer *)
var
 Y1: byte;
 C: char;

 procedure ShowMouse; assembler;
 asm
  mov ax, 1
  int 33h
 end;

 procedure HideMouse; assembler;
 asm
  mov ax, 2
  int 33h
 end;

 function ExtReadKey: char;
 var
  Pressed: boolean;
  MX, MY: byte;
 begin
  if not (IsMouse) then ExtReadKey := ReadKey else
  begin
   if ExtKey <> #0 then
   begin
    ExtReadKey := ExtKey;
    ExtKey := #0;
   end else
   begin
    Pressed := false;
    while not (Pressed) do
    begin
     if KeyPressed then
     begin
      ExtReadKey := ReadKey;
      Pressed := true;
     end else
     begin
      R.AX := 3;
      Intr ($33, R);
      if R.BX and Button <> 0 then
      begin
       Pressed := true;
       MX := R.CX div 8 + 1;
       MY := R.DX div 8 + 1;
       if (MX < 35) or (MX > 46) or (MY < 7 - J) or (MY > 8) then
                                                         ExtReadKey := #27 else
       if (MY > 7 - J) and (MY < 8) then
       begin
        ExtReadKey := #13;
        Y := MY + J - 7;
       end else
       begin
        ExtReadKey := #0;
        if MY = 8 then ExtKey := #81 else ExtKey := #73;
       end
      end;
     end;
    end;
   end;
  end;
 end;

begin
 if VNum > 5 then J := 5 else J := VNum;
 Act := First;
 TextBackground (CArray [CI].TB);
 TextColor (CArray [CI].FF);
 if IsMouse then HideMouse;
 GotoXY (34, 7 - J);
 Write ('ͻ');
 for I := 1 to J do
 begin
  VA [I] := Copy (Act^.VName + '            ', 1 , 12);
  Act := Act^.Next;
  GotoXY (34, 7 - J + I);
  Write ('            ');
 end;
 GotoXY (34, 8);
 Write ('ͼ');
 if IsMouse then ShowMouse;
 Y := 1;
 Y1 := 0;
 TextColor (CArray [CI].TF);
 repeat
  if IsMouse then HideMouse;
  for I := 1 to J do
  begin
   GotoXY (35, 7 - J + I);
   Write (VA [I]);
  end;
  TextColor (CArray [CI].CF);
  TextBackground (CArray [CI].CB);
  GotoXY (35, 7 - J + Y);
  Write (VA [Y]);
  TextColor (CArray [CI].FF);
  TextBackground (CArray [CI].TB);
  GotoXY (45, 7 - J);
  if Y1 > 0 then Write (#24) else Write (#205);       (* some viewers above? *)
  GotoXY (45, 8);
  if Y1 + J < VNum then Write (#25) else Write (#205); (* even more viewers? *)
  TextColor (CArray [CI].TF);
  if IsMouse then ShowMouse;
  C := ExtReadKey;
  if C = #0 then
  begin
   C := ExtReadKey;
   case C of         
    #68: C := #27;  (* F10 acts the same way as Escape - quit the selection  *)
    #61: C := #13;  (* F3 acts the same way as Enter; this makes it possible *)
                    (* to select the first viewer when this key is held down *)
    #72: if Y > 1 then Dec (Y) else if Y1 > 0 then Dec (Y1) else     (* Up   *)
         begin
          Y := J;
          Y1 := VNum - J;
         end;
    #80: if Y < J then Inc (Y) else if Y + Y1 < VNum then            (* Down *)
                                                      Inc (Y1) else
         begin
          Y1 := 0;
          Y := 1;
         end;
    #71: begin                                                       (* Home *)
          Y1 := 0;
          Y := 1;
         end;
    #79: begin                                                       (* End  *)
          Y := J;
          Y1 := VNum - J;
         end;
    #73: if Y + Y1 <= J then                                         (* PgUp *)
         begin
          Y1 := 0;
          Y := 1;
         end else if Y1 >= J then Dec (Y1, J) else
         begin
          Dec (Y, J - Y1);
          Y1 := 0;
         end;
    #81: if VNum - Y - Y1 < J then                                   (* PgDn *)
         begin
          Y := J;
          Y1 := VNum - J;
         end else if VNum - Y1 >= 2 * J then Inc (Y1, J) else
         begin
          Inc (Y, 2 * J - VNum + Y1);
          Y1 := VNum - J;
         end else C := #0;
   end;
   if C > #0 then              (* redraw *)
   begin
    I := 0;
    Act := First;
    while I < Y1 do
    begin
     Act := Act^.Next;
     Inc (I);
    end;
    for I := 1 to J do
    begin
     VA [I] := Copy (Act^.VName + '            ', 1 , 12);
     Act := Act^.Next;
    end;
   end;
  end;
 until (C = #13) or (C = #27);
 if C = #27 then
 begin
  Disp;
  DelT;
  Halt (0);
 end;
 I := 1;
 Act := First;
 while I < Y + Y1 do
 begin
  Act := Act^.Next;
  Inc (I);
 end;
 VName := Act^.VName;
 Which := VName;
 Big := Act^.Big;
 Pars := Act^.Pars;
 TextColor (OldC);
 TextBackground (OldB);
end;

begin
 if Lo (DosVersion) < 3 then Viewer := 'ALTVIEW.EXE' else
 begin
  Viewer := FExpand (ParamStr (0));
  ParP := Ptr (PrefixSeg, $80);         (* get the string of parameters      *)
  Move (ParP^, Params, PB^ + 1);        (* from PSP (Program Segment Prefix) *)
  I := Pos (#0, Params);
  if I = 0 then Params := '' else
                          Params := Copy (Params, I, Length (Params) - I + 1);
 end;
 if Length (Params) >= 10 then
 begin
  CI := byte (Params [10]);
{$IFNDEF QUICKVIEW}
  if ((CI = 1) or (CI = 3)) and (VideoMode = 2) then VideoMode := 3;
{$ENDIF}
 end else if (VideoMode = 0) or (VideoMode = 2) or (VideoMode = 7) then
                                                                       CI := 0;
 if Length (Params) >= 14 then
 begin
  IsMouse := boolean (Params [14]);
  Button := byte (Params [13]) + 1;
 end else
 begin
  R.AX := 0;
  Intr ($33, R);
  if R.AX = $FFFF then IsMouse := true;
 end;
 GetDir (0, ODir);
 FSplit (Viewer, OwnDir, Name, Ext);
 CfgName := Dir + Name + '.CFG';
 FindFirst (CfgName, $27, SR);
 if DosError <> 0 then
 begin
  EnvPath := GetEnv ('PATH');
  if EnvPath = '' then NoCfg;
  Dir := '';
  I := 1;
  J := 0;
  while (Dir = '') and (I > 0) do
  begin
   I := Pos (';', Copy (EnvPath, J + 1, Length (EnvPath) - J));
   if I > 0 then
   begin
    Dir := Copy (EnvPath, J + 1, I - 1) + '\';
    FindFirst (Dir + Name + '.CFG', $27, SR);
    if DosError <> 0 then Dir := '';
   end;
   J := J + I;
  end;
  if Dir = '' then NoCfg;
 end;
 CfgName := Dir + Name + '.CFG';
 Assign (Cfg, CfgName);
 TPath := GetEnv ('TEMP');
 if TPath = '' then
 begin
  TPath := GetEnv ('TMP');
  if TPath = '' then TPath := '.';
 end;
{$IFNDEF QUICKVIEW}
 Init_SpawnO (TPath, SwapType, 20, 0);
{$ENDIF}
 TPath := FExpand (TPath);
 TName := TPath + '\' + Name + '.TMP';
 Assign (T, TName);
 {$I-}
 Reset (Cfg);
 if IOResult <> 0 then NoCfg;
 LookT;
 {$I+}
 FName := ParamStr (1);
 FName [2] := UpCase (FName [2]);          (* well - 'undocumented' option;  *)
 if (FName = '/E') or (FName = '-E') then  (* this makes it possible to use  *)
 begin                                     (* ALTVIEW to start an editor for *)
  FName := ParamStr (2);                   (* specific file pattern or to    *)
  ContStr2 := EditStr;                     (* have another set of vievers;   *)
 end else ContStr2 := ViewStr;             (* this needs special ALTVIEW.CFG *)
 FName := FExpand (FName);
 FSplit (FName, Dir, Name, Ext);
 while not (Found) and not (Eof (Cfg)) do
 begin
  while not (Eof (Cfg)) and (Pos (Copy (Line, 1, 1), ContStr2) = 0) do
                                                         ReadLn (Cfg, Line);
  if Eof (Cfg) then Viewer := '' else
  begin
   Big := false;
   Pars := '';
   J := Pos (' ', Line);
   if J = 0 then J := Length (Line) + 1 else
   begin
    while Line [Length (Line)] = ' ' do Dec (Line [0]);
    if Length (Line) - J > 20 then Line [0] := char (J + 20);
    Pars := Copy (Line, J + 1, Length (Line) - J) + ' ';
   end;
   VName := Copy (Line, 2, J - 2);
   Viewer := OwnDir + VName;
   if (Line [1] = '%') and not (Sec) then Big := true;
  end;
  if Viewer <> '' then
  begin
   repeat
    repeat ReadLn (Cfg, Line) until Eof (Cfg)
                        or (Pos (Line [1], ContStr1 + ViewStr + EditStr) > 0);
    if (Pos (Line [1], ContStr1) > 0) then
    begin
     Pattern := Copy (Line, 2, Length (Line) - 1);
     FindFirst (Dir + Pattern, $27, SR);
     I := VNum;
     while (DosError = 0) and (VNum = I) and not (Found) do
     begin
      if SR.Name = Name + Ext then
      begin
       if Line [1] = '&' then
       begin
        if VNum = 0 then
        begin
         Inc (VNum);
         New (First);
         First^.VName := VName;
         First^.Big := Big;
         First^.Pars := Pars;
         First^.Next := nil;
        end else
        begin
         Act := First;
         I := 0;
         while (I < VNum) do
         begin
          if Act^.VName = VName then I := VNum + 1 else
          begin
           Inc (I);
           if Act^.Next <> nil then Act := Act^.Next;
          end;
         end;
         if I = VNum then
         begin
          New (Act^.Next);
          Act := Act^.Next;
          Act^.VName := VName;
          Act^.Big := Big;
          Act^.Pars := Pars;
          Act^.Next := nil;
          Inc (VNum);
         end;
        end;
       end else
       if VNum = 0 then
       begin
        if Line [1] = '+' then Direct := true;
        Found := true;
        Disp;
       end;
      end;
      FindNext (SR);
     end;
    end;
   until Eof (Cfg) or (Pos (Line [1], ViewStr) > 0) or Found;
  end;
 end;
 Close (Cfg);
 OldX := WhereX;
 OldY := WhereY;
 OldC := TextAttr and $8f;
 OldB := (TextAttr and $70) div 16;
 if Direct then
 begin
  FName := Name + Ext;
  ChDir (Copy (Dir, 1, Length (Dir) - 1));
 end;
 FName := Pars + FName;
 if (VNum > 0) and not (Found) then
 begin
  if VNum > 1 then Viewer := OwnDir + Which else
  begin
   VName := First^.VName;
   Big := First^.Big;
   Pars := First^.Pars;
   Viewer := OwnDir + VName;
  end;
  Disp;
  Found := true;
 end;
 if Found then
 begin
  GotoXY (OldX, OldY);
  if not (Sec) and (ContStr2 = ViewStr) then
  begin
   WriteStrDos (Copy (VName + '           ', 1, 12));
   GotoXY (OldX, OldY);
  end;
  SetMemTop (HeapPtr);
  VExt := Copy (Viewer, Length (Viewer) - 3, 4);
  for I := 2 to 4 do VExt [I] := UpCase (VExt [I]);
  if not (Big) then
  begin
   SwapVectors;
{$IFNDEF QUICKVIEW}
   if VExt = '.BAT' then Status := Spawn (GetEnv ('COMSPEC'), '/C ' + Viewer +
     ' ' + FName + Params, 0) else Status := Spawn (Viewer, FName + Params, 0);
   if (Status = -1) and (Spawno_error = -2) and (Pos ('.', VExt) = 0) then
      Status := Spawn (GetEnv ('COMSPEC'), '/C ' + Viewer + '.BAT ' + FName +
                                                                    Params, 0);
   if Status = -1 then
{$ELSE}
   if Pos ('.', VExt) = 0 then
   begin
    Exec (Viewer + '.COM', FName + Params);
    if DosError <> 0 then
    begin
     Exec (Viewer + '.EXE', FName + Params);
     if DosError <> 0 then Exec (GetEnv ('COMSPEC'), '/C' + Viewer + '.BAT ' +
                                                               FName + Params);
    end;
   end else
   if VExt = '.BAT' then Exec (GetEnv ('COMSPEC'), '/C ' + Viewer + ' ' +
                            FName + Params) else Exec (Viewer, FName + Params);
   if DosError <> 0 then
{$ENDIF}
   begin
    WriteStrDos ('Cannot execute ' + Viewer + '!!');
    WriteLn;
    repeat until (ExtKeyPressed);
{$IFNDEF QUICKVIEW}
    Status := Spawn (OwnDir + 'WPVIEW.EXE', Dir + Name + Ext + Params, 0);
    if Status = -1 then
{$ELSE}
    Exec (OwnDir + 'WPVIEW.EXE', Dir + Name + Ext + Params);
    if DosError <> 0 then
{$ENDIF}
    begin
     SwapVectors;
     DelT;
     Halt (8);
    end;
   end else ChDir (ODir);
   SwapVectors;
   DelT;
  end else
  begin
   BV := Copy (Ext, 2, 3);
   if BV = '' then BV := '{';
   BV := BV + '.BAT';
   GetDir (byte (TPath [1]) - 64, XX);
   Assign (B, TPath + '\' + BV);
{$I-}
   Rewrite (B);
   WriteLn (B, '@ECHO OFF');
   WriteLn (B, 'CD ' + XX);
   WriteLn (B, Copy (ODir, 1, 2));
   if VExt = '.BAT' then WriteLn (B, 'CALL ' + Viewer + ' ' + FName) else
                                             WriteLn (B, Viewer + ' ' + FName);
   WriteLn (B, 'DEL ' + TName);
   Write (B, 'DEL ' + TPath + '\' + BV);
   if IOResult <> 0 then
   begin
    Close (B);
    Erase (B);
   end else Close (B);
{$I+}
   asm
@1:
    mov ah, 11h
    int 16h
    jz @2
    mov ah, 10h
    int 16h
    jmp @1
@2:
   end;
   Dec (BV [0], 4);
   BV := BV + ' ' + Name;
   for I := 1 to Length (BV) do
   begin
    R.AH := 5;
    R.CL := Ord (BV [I]);
    Intr ($16, R);
   end;
   R.AH := 5;
   R.CL := 13;
   R.CH := $1C;
   Intr ($16, R);
   ChDir (TPath);
  end;
 end else
 begin
  WriteStrDos ('No matching pattern found!!');
  WriteLn;
  repeat until (ExtKeyPressed);
  DelT;
  Halt (2);
 end;
end.