                                                         
/*
**  Definitions Of Instructions And Addressing Modes For 6809 CPU.
**
**  Copyright 1993-97 by Paul D. Burgin. All rights reserved.
*/

/* Bit size type. */
typedef enum { B8, B16 } instr_bits;

/* Addressing mode type. */
typedef enum {	IMMEDIATE,	DIRECT,		INDEXED,	RELATIVE,
				EXTENDED,	INHERENT,	NO_MODE } instr_mode;

/* Instruction type (ordering important). */
typedef enum
{
	ABX,	ADC,	ADD8,	ADD16,	AND,	ASR,	BIT,	CLR,	CMP8,
	CMP16,	COM,	CWAI,	DAA,	DEC,	EOR,	EXG,	INC,	JMP,
	LD8,	LD16,	LEA,	LSL,	LSR,	MUL,	NEG,	NOP,	OR,
	PSH,	PUL,	ROL,	ROR,	RTI,	RTS,	SBC,	SEX,	ST8,
	ST16,	SUB8,	SUB16,	SWI,	SYNC,	TFR,	TST,	_RESET,	ORCC,
	ANDCC,	_DOIO,	ILLEGAL
} instr_type;

/* Branch types (ordering important). */
typedef enum
{
 /* BRA */	BRN,	BHI,	BLS,	BHS,	BLO,	BNE,	BEQ,
	BVC,	BVS,	BPL,	BMI,	BGE,	BLT,	BGT,	BLE
} branch_type; /* Preceed with EXT1 for long types (add 1 to len). */

/* Miscellaneous opcodes. */
#define EXT1	0x10
#define EXT2	0x11

#define BRA		0x20
#define BSR		0x8d
#define LBRA	0x16
#define LBSR    0x17

/* Misc definitions relating to opcodes. */
#define JSR_MIN	0x90 /* Any jump opcode above this is JSR, not JMP. */

/*
		EXT modifiers (page 1 and page 2 instructions):

		The SWI is SWI2 with EXT1 set, SWI3 with EXT2 set
		Any SUBD is CMPD with EXT1 set, CMPU with EXT2 set
		Any U_REG opcode is S_REG with EXT1 set
		Any X_REG opcode is Y_REG with EXT1 set
							S_REG with EXT2 set
*/

/* Register type (ordering important). */
typedef enum {	D_REG,	X_REG,	Y_REG,	U_REG,	S_REG,
				PC_REG,
					TO_MEM, /* Rogue value used for extended addressing. */
					NO_REG, /* Rogue value used for inherent addressing. */
				A_REG,	B_REG,	CC_REG,	DP_REG } __register;

/* Offset register type (ordering important). */
typedef enum {	OFF_X,		OFF_Y,		OFF_U,
				OFF_S,		OFF_PCR,	OFF_NONE } offset_register;

/* Type used in the instruction structure. */
typedef unsigned char ins_t;

/* Instruction type. */
typedef struct
{
	ins_t	_type;		/* Category/type of instruction. */
	ins_t	_mode;		/* Addressing mode of instruction. */
	ins_t	_register;	/* Implicit register operand. */
	ins_t	_time;		/* Number of t-states to execute. */
	ins_t	_size;		/* Initial number of bytes in instruction. */
} instruction;

extern ins_t i_table[256 * sizeof(instruction)];

/*
**	6809 Registers
*/

/* 8 bit registers, signed and unsigned values. */
typedef union
{
	unsigned char	u_value;
	signed char		s_value;
} reg8;

/* 16 bit registers, signed and unsigned values. */
typedef union
{
	unsigned int	u_value;
	signed int		s_value;
} reg16;

/*
**	Misc Definitions
*/

/* Execution time for illegal instructions. */
#define _F			1
