#include <string.h>
#include <dos.h>
#include <ctype.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>

 /* NORMAL(): Sets text mode to default */
 extern void normal(void) {
  _setcursortype(_NORMALCURSOR);
  window(1,1,80,25);
  textcolor(LIGHTGRAY);
  textbackground(BLACK);
  clrscr();
  return;
 }


 /* READ(): Reads text files */

 extern void read(char filename[])
 {
  FILE *fp;
  int i, a, endline=1, end=1, position=1;
  char ch;
  struct find_t ffblk;

  normal();
  _setcursortype(_NOCURSOR);
  textcolor(WHITE);
  gotoxy(1,25);
  cprintf("Commands:   Q= 'page up', A= 'page down', X= 'return to menu' ");
  window(1,1,80,24);
  textcolor(BLACK);
  textbackground(CYAN);
  clrscr();


  if(_dos_findfirst (filename,_A_NORMAL,&ffblk)!=0) {
   normal();
   gotoxy(1,25);
   printf("'%s' file is missing. Press any key to return to menu...",filename);
   getch();
   return;
  }
  if((fp=fopen(filename,"r"))==NULL) {
   normal();
   printf("ERROR: Cannot open %s file\n",filename);
   exit(1);
  }

  for(;;) {
   for(i=1;end;i++) {
    for(a=1;a<81;a++){
     ch=fgetc(fp);
     if(ch==EOF) {
      end=0;
      endline=i+1;
      break;
     }
     if(i>=position && i<position+24) putchar(ch);
     if(ch=='\n') break;

    }
   }
   Repeat:
   while(kbhit()) getch();
   do {
    ch=getch();
   } while(tolower(ch)!='q'&&tolower(ch)!='a'&&tolower(ch)!='x');
   if(tolower(ch)=='q') {
    if(position>24) position=position-24;
    else goto Repeat;
   }
   if(tolower(ch)=='a') {
    if(position<endline-24) position=position+24;
    else goto Repeat;
   }
   if(tolower(ch)=='x') {
    fclose(fp);
    normal();
    return;
   }
   end=1;
   clrscr();
   rewind(fp);
  }
 }

 /* READinst(): Reads instructions */

 extern void readinst(char filename[])
 {
  FILE *fp;
  int i, a, endline=1, end=1, position=1;
  char ch;
  struct find_t ffblk;

  normal();
  _setcursortype(_NOCURSOR);
  textcolor(WHITE);
  clrscr();
  gotoxy(32,1);
  printf("**INSTRUCTIONS**");
  gotoxy(1,25);
  cprintf("Commands:  A-next page  Q-previous page  X-start practice trials");
  window(1,2,80,24);
  textcolor(BLACK);
  textbackground(LIGHTGRAY);
  clrscr();


  if(_dos_findfirst (filename,_A_NORMAL,&ffblk)!=0) {
   normal();
   gotoxy(1,25);
   printf("'%s' file is missing. Press any key to exit...",filename);
   getch();
   normal();
   exit(0);
  }
  if((fp=fopen(filename,"r"))==NULL) {
   normal();
   printf("ERROR: Cannot open %s file\n",filename);
   exit(1);
  }

  for(;;) {
   for(i=1;end;i++) {
    for(a=1;a<81;a++){
     ch=fgetc(fp);
     if(ch==EOF) {
      end=0;
      endline=i+1;
      break;
     }
     if(i>=position && i<position+23) putchar(ch);
     if(ch=='\n') break;

    }
   }
   Repeat:
   while(kbhit()) getch();
   do {
    ch=getch();
    if(tolower(ch)=='h') {
     sound(900);delay(200);nosound();
    }
    if(tolower(ch)=='m') {
     sound(200);delay(200);nosound();
    }
    if(tolower(ch)=='l') {
     sound(50);delay(200);nosound();
    }

   } while(tolower(ch)!='q'&&tolower(ch)!='a'&&tolower(ch)!='x');
   if(tolower(ch)=='q') {
    if(position>23) position=position-23;
    else goto Repeat;
   }
   if(tolower(ch)=='a') {
    if(position<endline-23) position=position+23;
    else goto Repeat;
   }
   if(tolower(ch)=='x') {
    fclose(fp);
    normal();
    return;
   }

   end=1;
   clrscr();
   rewind(fp);
  }
 }

 /* QSORT */
 extern int sort_function( const void *a, const void *b)
 {
  return( strcmp((char *)a,(char *)b) );
 }

 /*READDATA(): Reads data files */
 extern void readdata(char ext[])
 {
  char buffer[4096];
  struct find_t ffblk;
  int done, b=0, c,stop;
  char string[120][13], name[120][9];
  FILE *fp;
  int i, a, endline=1, end=1, position=1, fileno;
  char ch, str[80];
  char fname[20]="*";

  normal();

  strcat(fname,ext);
  done = _dos_findfirst(fname,_A_NORMAL,&ffblk);
  while (!done) {
   strcpy(string[b],ffblk.name);

   for(c=0;c<9;c++) {
    if(string[b][c]=='.') {
     name[b][c]=0;
     break;
    }
    name[b][c]=string[b][c];
   }

   b++;
   done = _dos_findnext(&ffblk);
  }
  stop=b-1;

  if(stop>119) stop=119;

  qsort((void *)name, stop+1, sizeof(name[0]), sort_function);
  clrscr();
  window(1,1,13,25);
  textcolor(LIGHTGREEN);
  clrscr();
  for(b=0;b<24&&b<=stop;b++) cprintf("%3d. %s\r\n",b+1,name[b]);
  window(17,1,29,25);
  textcolor(LIGHTGREEN);
  clrscr();
  for(;b<48&&b<=stop;b++) cprintf("%3d. %s\r\n",b+1,name[b]);
  window(33,1,45,25);
  textcolor(LIGHTGREEN);
  clrscr();
  for(;b<72&&b<=stop;b++) cprintf("%3d. %s\r\n",b+1,name[b]);
  window(49,1,61,25);
  textcolor(LIGHTGREEN);
  clrscr();
  for(;b<96&&b<=stop;b++) cprintf("%3d. %s\r\n",b+1,name[b]);
  window(65,1,77,25);
  textcolor(LIGHTGREEN);
  clrscr();
  for(;b<120&&b<=stop;b++) cprintf("%3d. %s\r\n",b+1,name[b]);

  window(1,1,80,25);
  gettext(1, 1, 80, 25, buffer);

  do {
   puttext(1,1,80,25,buffer);
   gotoxy(1,25);
   textcolor(LIGHTRED);
   if(stop<0) {
    cprintf("NO FILES FOUND! Press any key to return to menu...");
    getch();
    return;
   }
   cprintf("Enter the number of a file (1-%d):",stop+1);
   gets(str);
   if(strlen(str)==0) return;
   fileno=atoi(str);
  } while(fileno<1||fileno>stop+1);




  normal();
  _setcursortype(_NOCURSOR);
  textcolor(WHITE);
  gotoxy(1,25);
  cprintf("Commands:   Q= 'page up', A= 'page down', X= 'return to main menu' ");
  window(1,1,80,24);
  textcolor(LIGHTGREEN);
  clrscr();


  strcat(name[fileno-1],ext);
  if((fp=fopen(name[fileno-1],"r"))==NULL) {
   normal();
   printf("Cannot open %s file\n",name[fileno-1]);
   exit(1);
  }

  for(;;) {
   for(i=1;end;i++) {
    for(a=1;a<81;a++){
     ch=fgetc(fp);
     if(ch==EOF) {
      end=0;
      endline=i+1;
      break;
     }
     if(i>=position && i<position+24) putchar(ch);
     if(ch=='\n') break;

    }
   }
   Repeat:
   while(kbhit()) getch();
   do {
    ch=getch();
   } while(tolower(ch)!='q'&&tolower(ch)!='a'&&tolower(ch)!='x');
   if(tolower(ch)=='q') {
    if(position>24) position=position-24;
    else goto Repeat;
   }
   if(tolower(ch)=='a') {
    if(position<endline-24) position=position+24;
    else goto Repeat;
   }
   if(tolower(ch)=='x') {
    fclose(fp);
    normal();
    return;
   }
   end=1;
   clrscr();
   rewind(fp);
  }
 }
//about practicals

extern void about(void)
{
 char choice;
 normal();
 _setcursortype(_NOCURSOR);
 clrscr();
 window(9,9,71,20);
 textbackground(LIGHTRED);
 textcolor(WHITE);
 clrscr();
 gotoxy(30,1);
 printf("ABOUT");

 window(10,10,70,19);
 textcolor(WHITE);
 textbackground(LIGHTGRAY);
 clrscr();
 gotoxy(16,2);
 printf("COGNITIVE PSYCHOLOGY PRACTICALS");
 gotoxy(25,3);
 printf("Version 1.1");
 gotoxy(12,6);
 printf("Copyright (c) 1996 by D. Nakarada-Kordic");
 gotoxy(12,9);
 printf(" Licensed to Psychology Department, U.Z.");
 getch();
}

  /* WHITE(): Sets text mode to white */
void white(void) {
  _setcursortype(_NORMALCURSOR);
  window(1,1,80,25);
  textcolor(BLACK);
  textbackground(LIGHTGRAY);
  clrscr();
  return;
}

