/****************************************************************************
 *
 *      Program name : FPRTIN.C
 *
 *	Written By : Eng-Huat Ong and Kian-Mong Low.
 *
 *      This program reads the ON and DC arrays from the input data file and
 *      writes them to the output file.
 *
 * --------------------------------------------------------------------------
 *	Copyright (c) 1992. All Rights Reserved. Nanyang Technological
 *	University.
 *
 *	You are free to use, copy and distribute this software and its
 *	documentation providing that:
 *
 *		NO FEE IS CHARGED FOR USE, COPYING OR DISTRIBUTION.
 *
 *		IT IS NOT MODIFIED IN ANY WAY.
 *
 *		THE COPYRIGHT NOTICE APPEAR IN ALL COPIES.
 *
 *	This program is provided "AS IS" without any warranty, expressed or
 *	implied, including but not limited to fitness for any particular
 *	purpose.
 *
 *	If you find NTUMIN fast, easy, and useful, a note or comment would be
 *	appreciated. Please send to:
 *
 *		Boon-Tiong Tan or Othman Bin Ahmad
 *		School of EEE
 *		Nanyang Technological University
 *		Nanyang Avenue
 *		Singapore 2263
 *		Republic of Singapore
 *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>

void           fprtin(in, out, ondc)
unsigned char  ondc;
FILE           *in, *out;

{
   unsigned short  i=0, p;
   unsigned char   n, *cube;


   if (ondc==0)                                        /* ON array */
      fscanf(in, "%d", &n);                            /* no. of variables */

   fscanf(in, "%d", &p);          		       /* no. of cubes */

   cube = (unsigned char *) malloc(n+1);               /* space for cube + 1 */
   if (cube==0)
      {
	 printf("Out of memory -- FPRTIN, *cube\n");
	 printf("Program terminated - 1\n");
	 exit(0);
      }

   while (++i <= p)                                     /* copy all cubes  */
      {                                                 /*                 */
	 fscanf(in, "%s", cube);                        /* from input file */
	 fprintf(out, "%s\n", cube);                    /*                 */
      }                                                 /* to output file  */
   free(cube);                                          /* free pointer    */
}
