/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1996 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                 Email:             M.Hessling@qut.edu.au
 * PO Box 203                    Phone:                    +617 3849 7731
 * Bellara                       http://www.gu.edu.au/gwis/the/markh.html
 * QLD 4507                      **** Maintainer PDCurses & REXX/SQL ****
 * Australia                     ************* Author of THE ************
 */

/*
$Id: proto.h 2.1 1995/06/24 16:30:47 MH Rel MH $
*/

#ifdef HAVE_PROTO
                                                         /* commutil.c */
CHARTYPE *get_key_name(int);
CHARTYPE *get_key_definition(int,bool,bool);
short function_key(int,int);
CHARTYPE *build_default_key_definition(int, CHARTYPE *);
short display_all_keys(void);
short command_line(CHARTYPE *,bool);
void cleanup_command_line(void);
void split_command(CHARTYPE *,CHARTYPE *,CHARTYPE *);
short param_split(CHARTYPE *,CHARTYPE *[],short,CHARTYPE *,CHARTYPE,CHARTYPE *);
short command_split(CHARTYPE *,CHARTYPE *[],short,CHARTYPE *,CHARTYPE *);
LINETYPE get_true_line(void);
void print_line(bool ,LINETYPE,LINETYPE ,short ,CHARTYPE *,CHARTYPE *);
#if defined(OS2)
void print_shadow_line(HFILE ,CHARTYPE *,LINETYPE);
#else
void print_shadow_line(FILE *,CHARTYPE *,LINETYPE);
#endif
CHARTYPE next_char(LINE *,long *,LENGTHTYPE);
short add_define(int,CHARTYPE *);
short remove_define(int);
short append_define(DEFINE **,DEFINE **,int,short,CHARTYPE *);
int find_key_value(CHARTYPE *);
short find_command(CHARTYPE *,bool);
void init_command(void);
void add_command(CHARTYPE *);
CHARTYPE *get_next_command( short );
bool valid_command_to_save(CHARTYPE *);
bool is_tab_col(LENGTHTYPE);
LENGTHTYPE find_next_tab_col(LENGTHTYPE);
LENGTHTYPE find_prev_tab_col(LENGTHTYPE);
short tabs_convert(LINE *,bool,bool,bool,bool);
short convert_hex_strings(CHARTYPE *);
short marked_block(bool);
short suspend_curses(void);
short resume_curses(void);
short restore_THE(void);
short execute_set_sos_command(bool,CHARTYPE *);
short valid_command_type(bool,CHARTYPE *);
short allocate_temp_space(unsigned short,CHARTYPE);
void free_temp_space(CHARTYPE);
CHARTYPE calculate_actual_row(CHARTYPE,short,CHARTYPE,bool);
short get_valid_macro_file_name(CHARTYPE *,CHARTYPE *,short *);
bool define_command(CHARTYPE *);
int find_key_name(CHARTYPE *);
int readv_cmdline(CHARTYPE *);
                                                           /* target.c */
short split_change_params(CHARTYPE *,CHARTYPE **,CHARTYPE **,TARGET *,LINETYPE *,LINETYPE *);
short parse_target(CHARTYPE *,LINETYPE,TARGET *,short,bool,bool,bool);
void initialise_target(TARGET *);
void free_target(TARGET *);
short find_target(TARGET *,LINETYPE,bool,bool);
short find_column_target(CHARTYPE *,LENGTHTYPE,TARGET *,LENGTHTYPE,bool,bool);
LINE *find_named_line(CHARTYPE *,LINETYPE *,bool);
short find_string_target(LINE *,RTARGET *);
bool find_rtarget_target(LINE *,TARGET *,LINETYPE,LINETYPE,LINETYPE *);
bool find_rtarget_column_target(CHARTYPE *,LENGTHTYPE,TARGET *,LENGTHTYPE,LENGTHTYPE,LINETYPE *);
LINETYPE find_next_in_scope(VIEW_DETAILS *,LINE *,LINETYPE,short);
LINETYPE find_last_not_in_scope(VIEW_DETAILS *,LINE *,LINETYPE,short);
short validate_target(CHARTYPE *,TARGET *,short,LINETYPE,bool,bool);
bool in_scope(VIEW_DETAILS *,LINE *);
void calculate_scroll_values(short *,LINETYPE *,LINETYPE *,bool *,bool *,bool *,short);
short find_first_focus_line(unsigned short *);
short find_last_focus_line(unsigned short *);
CHARTYPE find_unique_char(CHARTYPE *);
                                                         /* reserved.c */
short add_reserved_line(CHARTYPE *,CHARTYPE *,short,short,COLOUR_ATTR *);
RESERVED *find_reserved_line(CHARTYPE,bool,ROWTYPE,short,short);
short delete_reserved_line(short,short);
                                                              /* box.c */
void box_operations(short ,CHARTYPE ,bool ,CHARTYPE );
short box_delete(BOXP *);
short box_move(BOXP *,bool);
short box_fill(BOXP *,CHARTYPE);
                                                          /* execute.c */
short execute_os_command(CHARTYPE *,bool ,bool );
short execute_change_command(CHARTYPE *,bool );
short selective_change(CHARTYPE *,short,CHARTYPE *,short,LINETYPE ,LINETYPE ,short );
short insert_new_line(CHARTYPE *,short,LINETYPE,LINETYPE,bool,bool,CHARTYPE);
short execute_makecurr(LINETYPE);
short execute_shift_command(short,short,LINETYPE,LINETYPE,bool);
short execute_change_case(CHARTYPE *,CHARTYPE);
short change_case(CHARTYPE *,short,short,CHARTYPE);
short rearrange_line_blocks(CHARTYPE,CHARTYPE,LINETYPE,LINETYPE,LINETYPE,short,VIEW_DETAILS*,VIEW_DETAILS*,bool);
short execute_set_point(CHARTYPE *,LINETYPE ,bool);
short execute_wrap_word(unsigned short);
short execute_split_join(short,bool);
short execute_put(CHARTYPE *,bool);
short execute_macro(CHARTYPE *,bool);
short execute_set_on_off(CHARTYPE *,bool *);
short execute_set_row_position(CHARTYPE *,short *,short *);
short processable_line(VIEW_DETAILS *,LINETYPE,LINE *);
short execute_expand(CHARTYPE *,bool,bool,bool);
short execute_move_cursor(LENGTHTYPE);
short execute_find_command(CHARTYPE *,short);
short execute_modify_command(CHARTYPE *);
LENGTHTYPE calculate_rec_len(short,LENGTHTYPE,LENGTHTYPE,LINETYPE);
                                                          /* default.c */
void set_global_defaults(void);
void set_file_defaults(FILE_DETAILS *);
void set_view_defaults(VIEW_DETAILS *);
short get_profile(CHARTYPE *,CHARTYPE *);
short defaults_for_first_file(void);
short defaults_for_other_files(VIEW_DETAILS *);
short default_file_attributes(FILE_DETAILS *);
void set_screen_defaults(void);
void set_defaults(void);
short set_THE_defaults(int,int);
short set_XEDIT_defaults(int,int);
short set_KEDIT_defaults(int,int);
                                                             /* edit.c */
void editor(void);
int process_key(int);
                                                            /* error.c */
void display_error(unsigned short ,CHARTYPE *,bool);
void clear_msgline(void);
void display_prompt(CHARTYPE *);
void expose_msgline(void);
                                                             /* file.c */
short get_file(CHARTYPE *);
LINE *read_file(FILE *,LINE *,CHARTYPE *,LINETYPE,LINETYPE);
LINE *read_fixed_file(FILE *,LINE *,CHARTYPE *,LINETYPE,LINETYPE);
short save_file(FILE_DETAILS *,CHARTYPE *,bool,LINETYPE,LINETYPE,bool,LENGTHTYPE,LENGTHTYPE,bool,bool);
short increment_alt(FILE_DETAILS *);
CHARTYPE *new_filename(CHARTYPE *,CHARTYPE *,CHARTYPE *,CHARTYPE *);
short remove_aus_file(FILE_DETAILS *);
short free_view_memory(bool);
void free_a_view(void);
short free_file_memory(bool);
short read_directory(void);
VIEW_DETAILS *find_file(CHARTYPE *,CHARTYPE *);
short execute_command_file(FILE *);
short process_command_line(CHARTYPE *,short);
                                                            /* getch.c */
#if !defined(DOS) && !defined(OS2)
int my_getch (WINDOW *);
#endif
                                                          /* nonansi.c */
short file_readable(CHARTYPE *);
short file_writable(CHARTYPE *);
short file_exists(CHARTYPE *);
short remove_file(CHARTYPE *);
short splitpath(CHARTYPE *);
#ifndef HAVE_RENAME
short rename(CHARTYPE *,CHARTYPE *);
#endif
#ifdef OS2
bool LongFileNames(CHARTYPE *);
#endif
                                                           /* prefix.c */
short execute_prefix_commands(void);
void clear_pending_prefix_command(PPC *,LINE *);
PPC *delete_pending_prefix_command(PPC *,FILE_DETAILS *,LINE *);
void add_prefix_command(LINE *,LINETYPE,bool);
short add_prefix_synonym(CHARTYPE *,CHARTYPE *);
CHARTYPE *find_prefix_synonym(CHARTYPE *);
CHARTYPE *find_prefix_oldname(CHARTYPE *);
CHARTYPE *get_prefix_command(LINETYPE);
                                                             /* show.c */
void show_heading(CHARTYPE);
void show_footing(void);
void clear_footing(void);
void build_screen(CHARTYPE);
void display_screen(CHARTYPE);
void show_marked_block(void);
void redraw_window(WINDOW *);
void repaint_screen(void);
void touch_screen(CHARTYPE);
void refresh_screen(CHARTYPE);
void redraw_screen(CHARTYPE);
bool line_in_view(CHARTYPE,LINETYPE);
bool column_in_view(CHARTYPE,LENGTHTYPE);
LINETYPE find_next_current_line(LINETYPE,short);
short get_row_for_focus_line(CHARTYPE,LINETYPE,short);
LINETYPE get_focus_line_in_view(CHARTYPE,LINETYPE,unsigned short);
LINETYPE calculate_focus_line(LINETYPE,LINETYPE);
void get_current_position(CHARTYPE,LINETYPE *,LENGTHTYPE *);
void calculate_new_column(COLTYPE,LENGTHTYPE,LENGTHTYPE,COLTYPE *,LENGTHTYPE *);
short prepare_view(CHARTYPE);
short advance_view(VIEW_DETAILS *,short);
short THE_Resize(void);
                                                           /* scroll.c */
short scroll_page(short,LINETYPE,bool);
short scroll_line(short,LINETYPE,bool,bool);
                                                              /* the.c */
void init_colour_pairs(void);
int setup_profile_files(CHARTYPE *);
void cleanup(void);
                                                             /* util.c */
short memreveq(CHARTYPE *,CHARTYPE ,short );
short memrevne(CHARTYPE *,CHARTYPE ,short );
CHARTYPE *meminschr(CHARTYPE *,CHARTYPE ,short ,short ,short );
CHARTYPE *meminsmem(CHARTYPE *,CHARTYPE *,short ,short ,short ,short );
CHARTYPE *memdelchr(CHARTYPE *,short ,short,short );
short strzne(CHARTYPE *,CHARTYPE );
CHARTYPE *my_strdup(CHARTYPE *);
short memne(CHARTYPE *,CHARTYPE ,short );
short strzrevne(CHARTYPE *,CHARTYPE );
short strzreveq(CHARTYPE *,CHARTYPE );
CHARTYPE *strtrunc(CHARTYPE *);
CHARTYPE *MyStrip(CHARTYPE *,char,char);
short memfind(CHARTYPE *,CHARTYPE *,short ,short ,bool ,bool ,CHARTYPE ,CHARTYPE);
short memcmpi(CHARTYPE *,CHARTYPE *,short );
CHARTYPE *make_upper(CHARTYPE *);
unsigned short equal(CHARTYPE *,CHARTYPE *,short );
short valid_integer(CHARTYPE *);
short valid_positive_integer(CHARTYPE *);
short strzeq(CHARTYPE *,CHARTYPE );
CHARTYPE *strtrans(CHARTYPE *,CHARTYPE,CHARTYPE);
LINE *add_line(LINE *,LINE *,CHARTYPE *,LENGTHTYPE,SELECTTYPE);
LINE *append_line(LINE *,CHARTYPE *,LENGTHTYPE);
LINE *delete_line(LINE *,LINE *,short);
void put_string(WINDOW *,short ,short ,CHARTYPE *,short);
void put_char(WINDOW *,chtype ,CHARTYPE );
short set_up_windows(short);
short draw_divider(void);
short create_statusline_window(void);
void pre_process_line(VIEW_DETAILS *,LINETYPE,LINE *);
short post_process_line(VIEW_DETAILS *,LINETYPE,LINE *);
bool blank_field(CHARTYPE *);
void adjust_marked_lines(bool ,LINETYPE ,LINETYPE );
void adjust_pending_prefix(VIEW_DETAILS *,bool ,LINETYPE ,LINETYPE );
CHARTYPE case_translate(CHARTYPE );
void add_to_recovery_list(CHARTYPE *,LENGTHTYPE);
void get_from_recovery_list(short );
void free_recovery_list(void);
short my_wmove(WINDOW *,short ,short ,short ,short );
short get_row_for_tof_eof(short,CHARTYPE);

#if THIS_APPEARS_TO_NOT_BE_USED
WINDOW *adjust_window(WINDOW *,short ,short ,short ,short );
#endif

void draw_cursor(bool);
short my_wclrtoeol(WINDOW *);
short my_wdelch(WINDOW *);
short get_word(CHARTYPE *,LENGTHTYPE,LENGTHTYPE,LENGTHTYPE *,LENGTHTYPE *);
                                                           /* linked.c */
void *ll_add(void *,void *,unsigned short );
void *ll_del(void *,void *,short );
void ll_free(void *);
void *ll_find(void *,LINETYPE );
LINE *lll_add(LINE *,LINE *,unsigned short );
LINE *lll_del(LINE **,LINE **,LINE *,short );
LINE *lll_free(LINE *);
LINE *lll_find(LINE *,LINE *,LINETYPE,LINETYPE);
VIEW_DETAILS *vll_add(VIEW_DETAILS *,VIEW_DETAILS *,unsigned short );
VIEW_DETAILS *vll_del(VIEW_DETAILS **,VIEW_DETAILS **,VIEW_DETAILS *,short );
DEFINE *dll_add(DEFINE *,DEFINE *,unsigned short );
DEFINE *dll_del(DEFINE **,DEFINE **,DEFINE *,short );
DEFINE *dll_free(DEFINE *);
PPC *pll_add(PPC *,PPC *,unsigned short );
PPC *pll_del(PPC **,PPC **,PPC *,short );
PPC *pll_free(PPC *);
PPC *pll_find(PPC *,LINETYPE);
RESERVED *rll_add(RESERVED *,RESERVED *,unsigned short );
RESERVED *rll_del(RESERVED **,RESERVED **,RESERVED *,short );
RESERVED *rll_free(RESERVED *);
RESERVED *rll_find(RESERVED *,short);
                                                             /* rexx.c */
short initialise_rexx(void);
short finalise_rexx(void);
short execute_macro_file(CHARTYPE *,CHARTYPE *);
short set_rexx_variable(CHARTYPE *,CHARTYPE *,short,short);
                                                           /* os2eas.c */
#if defined(OS2)
bool ReadEAs(CHARTYPE *);
bool WriteEAs(CHARTYPE *);
#endif
                                                            /* query.c */
short find_item(CHARTYPE *,CHARTYPE);
short show_status(void);
short save_status(CHARTYPE *);
short set_extract_variables(short);
short get_item_values(short,CHARTYPE *,CHARTYPE,LINETYPE,CHARTYPE *,LINETYPE);
                                                         /* directry.c */
short set_dirtype(CHARTYPE *);
                                                          /* fnmatch.c */
int fnmatch(CHARTYPE *,CHARTYPE *,int);
                                                             /* sort.c */
short execute_sort(CHARTYPE *);
                                                           /* cursor.c */
short cursor_cmdline(short);
short cursor_column(void);
short cursor_down(bool);
short cursor_file(LINETYPE,LENGTHTYPE);
short cursor_home(bool);
short cursor_left(bool,bool);
short cursor_right(bool,bool);
short cursor_up(bool);
short cursor_move(bool,short,short);
long where_now(void);
long what_current_now(void);
long what_other_now(void);
long where_next(long,long,long);
long where_before(long,long,long);
bool enterable_field(long);
short go_to_new_field(long,long);
void get_cursor_position(long*,long*,long*,long*);
short advance_focus_line(LINETYPE);
short advance_current_line(LINETYPE);
                                                           /* colour.c */
short parse_colours(CHARTYPE *,COLOUR_ATTR *,CHARTYPE **,bool,bool*);
chtype set_colour(COLOUR_ATTR *);
void set_up_default_colours(FILE_DETAILS *,COLOUR_ATTR *,int);
CHARTYPE *get_colour_strings(COLOUR_ATTR *);
                                                           /* column.c */
short column_command(CHARTYPE *,int);
                                                            /* mouse.c */
short THEMouse(CHARTYPE *);
short get_mouse_info(int *,int *,int *);
                                                            /* comm*.c */
short Add(CHARTYPE *);
short All(CHARTYPE *);
short Arbchar(CHARTYPE *);
short Autosave(CHARTYPE *);
short Backup(CHARTYPE *);
short Backward(CHARTYPE *);
short BeepSound(CHARTYPE *);
short Bottom(CHARTYPE *);
short Cappend(CHARTYPE *);
short Cancel(CHARTYPE *);
short Case(CHARTYPE *);
short Ccancel(CHARTYPE *);
short Cdelete(CHARTYPE *);
short Cfirst(CHARTYPE *);
short Change(CHARTYPE *);
short Cinsert(CHARTYPE *);
short Clast(CHARTYPE *);
short Clearscreen(CHARTYPE *);
short Clocate(CHARTYPE *);
short Clock(CHARTYPE *);
short Cmatch(CHARTYPE *);
short Cmdarrows(CHARTYPE *);
short Cmdline(CHARTYPE *);
short Cmsg(CHARTYPE *);
short Colour(CHARTYPE *);
short Compat(CHARTYPE *);
short Compress(CHARTYPE *);
short THECommand(CHARTYPE *);
short Control_char(CHARTYPE *);
short Copy(CHARTYPE *);
short Coverlay(CHARTYPE *);
short Creplace(CHARTYPE *);
short Curline(CHARTYPE *);
short Cursor(CHARTYPE *);
short CursorStay(CHARTYPE *);
short Define(CHARTYPE *);
short DeleteLine(CHARTYPE *);
short Directory(CHARTYPE *);
short Dirinclude(CHARTYPE *);
short Display(CHARTYPE *);
short Duplicate(CHARTYPE *);
short Emsg(CHARTYPE *);
short Enter(CHARTYPE *);
short Etmode(CHARTYPE *);
short Eolout(CHARTYPE *);
short Expand(CHARTYPE *);
short Extract(CHARTYPE *);
short Ffile(CHARTYPE *);
short File(CHARTYPE *);
short Fillbox(CHARTYPE *);
short Find(CHARTYPE *);
short Findup(CHARTYPE *);
short Forward(CHARTYPE *);
short Get(CHARTYPE *);
short Help(CHARTYPE *);
short Hex(CHARTYPE *);
short Hexdisplay(CHARTYPE *);
short Hexshow(CHARTYPE *);
short Hit(CHARTYPE *);
short Idline(CHARTYPE *);
short Impmacro(CHARTYPE *);
short Impos(CHARTYPE *);
short Input(CHARTYPE *);
short Insertmode(CHARTYPE *);
short Join(CHARTYPE *);
short Left(CHARTYPE *);
short Linend(CHARTYPE *);
short Locate(CHARTYPE *);
short Lowercase(CHARTYPE *);
short Macro(CHARTYPE *);
short Macroext(CHARTYPE *);
short Macropath(CHARTYPE *);
short Margins(CHARTYPE *);
short Mark(CHARTYPE *);
short Modify(CHARTYPE *);
short THEMove(CHARTYPE *);
short Msg(CHARTYPE *);
short Msgline(CHARTYPE *);
short Msgmode(CHARTYPE *);
short Newlines(CHARTYPE *);
short Next(CHARTYPE *);
short Nextwindow(CHARTYPE *);
short Nfind(CHARTYPE *);
short Nfindup(CHARTYPE *);
short Nomsg(CHARTYPE *);
short Nondisp(CHARTYPE *);
short Nop(CHARTYPE *);
short Number(CHARTYPE *);
short Overlaybox(CHARTYPE *);
short Os(CHARTYPE *);
short Osnowait(CHARTYPE *);
short Osquiet(CHARTYPE *);
short Osredir(CHARTYPE *);
short Pending(CHARTYPE *);
short Point(CHARTYPE *);
short Position(CHARTYPE *);
short Prefix(CHARTYPE *);
short Preserve(CHARTYPE *);
short Print(CHARTYPE *);
short THEPrinter(CHARTYPE *);
short Put(CHARTYPE *);
short Putd(CHARTYPE *);
short Qquit(CHARTYPE *);
short Quit(CHARTYPE *);
short Query(CHARTYPE *);
short Readv(CHARTYPE *);
short Recover(CHARTYPE *);
short Reexecute(CHARTYPE *);
short Redraw(CHARTYPE *);
short THERefresh(CHARTYPE *);
short Repeat(CHARTYPE *);
short Replace(CHARTYPE *);
short Reprofile(CHARTYPE *);
short Reserved(CHARTYPE *);
short Reset(CHARTYPE *);
short Restore(CHARTYPE *);
short Retrieve(CHARTYPE *);
short Rexxoutput(CHARTYPE *);
short Rgtleft(CHARTYPE *);
short Right(CHARTYPE *);
short Save(CHARTYPE *);
short Scope(CHARTYPE *);
short Scale(CHARTYPE *);
short Select(CHARTYPE *);
short Set(CHARTYPE *);
short Schange(CHARTYPE *);
short THEScreen(CHARTYPE *);
short Shadow(CHARTYPE *);
short Shift(CHARTYPE *);
short ShowKey(CHARTYPE *);
short Sort(CHARTYPE *);
short Sos(CHARTYPE *);
short Sos_addline(CHARTYPE *);
short Sos_bottomedge(CHARTYPE *);
short Sos_current(CHARTYPE *);
short Sos_cursoradj(CHARTYPE *);
short Sos_delback(CHARTYPE *);
short Sos_delchar(CHARTYPE *);
short Sos_delend(CHARTYPE *);
short Sos_delline(CHARTYPE *);
short Sos_delword(CHARTYPE *);
short Sos_doprefix(CHARTYPE *);
short Sos_edit(CHARTYPE *);
short Sos_endchar(CHARTYPE *);
short Sos_execute(CHARTYPE *);
short Sos_firstchar(CHARTYPE *);
short Sos_firstcol(CHARTYPE *);
short Sos_lastcol(CHARTYPE *);
short Sos_leftedge(CHARTYPE *);
short Sos_makecurr(CHARTYPE *);
short Sos_marginl(CHARTYPE *);
short Sos_marginr(CHARTYPE *);
short Sos_parindent(CHARTYPE *);
short Sos_prefix(CHARTYPE *);
short Sos_qcmnd(CHARTYPE *);
short Sos_rightedge(CHARTYPE *);
short Sos_startendchar(CHARTYPE *);
short Sos_tabb(CHARTYPE *);
short Sos_tabf(CHARTYPE *);
short Sos_tabfieldb(CHARTYPE *);
short Sos_tabfieldf(CHARTYPE *);
short Sos_tabwordb(CHARTYPE *);
short Sos_tabwordf(CHARTYPE *);
short Sos_topedge(CHARTYPE *);
short Sos_undo(CHARTYPE *);
short Split(CHARTYPE *);
short Spltjoin(CHARTYPE *);
short Ssave(CHARTYPE *);
short Status(CHARTYPE *);
short Statusline(CHARTYPE *);
short Stay(CHARTYPE *);
short Suspend(CHARTYPE *);
short Synonym(CHARTYPE *);
short Tabkey(CHARTYPE *);
short Tabline(CHARTYPE *);
short Tabpre(CHARTYPE *);
short Tabs(CHARTYPE *);
short Tabsin(CHARTYPE *);
short Tabsout(CHARTYPE *);
short Text(CHARTYPE *);
short Top(CHARTYPE *);
short THETypeahead(CHARTYPE *);
short Up(CHARTYPE *);
short Uppercase(CHARTYPE *);
short Verify(CHARTYPE *);
short Wordwrap(CHARTYPE *);
short Xedit(CHARTYPE *);
short Xterminal(CHARTYPE *);
short Zone(CHARTYPE *);

#else
                                                         /* commutil.c */
CHARTYPE *get_key_name();
CHARTYPE *get_key_definition();
short function_key();
CHARTYPE *build_default_key_definition();
short display_all_keys();
short command_line();
void cleanup_command_line();
void split_command();
short param_split();
short command_split();
LINETYPE get_true_line();
void print_line();
void print_shadow_line();
CHARTYPE next_char();
short add_define();
short remove_define();
short append_define();
int find_key_value();
short find_command();
void init_command();
void add_command();
CHARTYPE *get_next_command();
bool valid_command_to_save();
bool is_tab_col();
LENGTHTYPE find_next_tab_col();
LENGTHTYPE find_prev_tab_col();
short tabs_convert();
short convert_hex_strings();
short marked_block();
short suspend_curses();
short resume_curses();
short restore_THE();
short execute_set_sos_command();
short valid_command_type();
short allocate_temp_space();
void free_temp_space();
CHARTYPE calculate_actual_row();
short get_valid_macro_file_name();
bool define_command();
int find_key_name();
int readv_cmdline();
                                                           /* target.c */
short split_change_params();
short parse_target();
void initialise_target();
void free_target();
short find_target();
short find_column_target();
LINE *find_named_line();
short find_string_target();
bool find_rtarget_target();
bool find_rtarget_column_target();
LINETYPE find_next_in_scope();
LINETYPE find_last_not_in_scope();
short validate_target();
bool in_scope();
void calculate_scroll_values();
short find_first_focus_line();
short find_last_focus_line();
CHARTYPE find_unique_char();
                                                         /* reserved.c */
short add_reserved_line();
RESERVED *find_reserved_line();
short delete_reserved_line();
                                                              /* box.c */
void box_operations();
short box_delete();
short box_move();
short box_fill();
                                                          /* execute.c */
short execute_os_command();
short execute_change_command();
short selective_change();
short insert_new_line();
short execute_makecurr();
short execute_shift_command();
short execute_change_case();
short change_case();
short rearrange_line_blocks();
short execute_set_point();
short execute_wrap_word();
short execute_split_join();
short execute_put();
short execute_macro();
short execute_set_on_off();
short execute_set_row_position();
short processable_line();
short execute_expand();
short execute_move_cursor();
short execute_find_command();
short execute_modify_command();
LENGTHTYPE calculate_rec_len();
                                                          /* default.c */
void set_global_defaults();
void set_file_defaults();
void set_view_defaults();
short get_profile();
short defaults_for_first_file();
short defaults_for_other_files();
short default_file_attributes();
void set_screen_defaults();
void set_defaults();
short set_THE_defaults();
short set_XEDIT_defaults();
short set_KEDIT_defaults();
                                                             /* edit.c */
void editor();
int process_key();
                                                            /* error.c */
void display_error();
void clear_msgline();
void display_prompt();
void expose_msgline();
                                                             /* file.c */
short get_file();
LINE *read_file();
LINE *read_fixed_file();
short save_file();
short increment_alt();
CHARTYPE *new_filename();
short remove_aus_file();
short free_view_memory();
void free_a_view();
short free_file_memory();
short read_directory();
VIEW_DETAILS *find_file();
short execute_command_file();
short process_command_line();
                                                            /* getch.c */
#if !defined(DOS) && !defined(OS2)
int my_getch ();
#endif
                                                          /* nonansi.c */
short file_readable();
short file_writable();
short file_exists();
short remove_file();
short splitpath();
#ifndef HAVE_RENAME
short rename();
#endif
#ifdef OS2
bool LongFileName();
#endif
                                                           /* prefix.c */
short execute_prefix_commands();
void clear_pending_prefix_command();
PPC *delete_pending_prefix_command();
void add_prefix_command();
short add_prefix_synonym();
CHARTYPE *find_prefix_synonym();
CHARTYPE *find_prefix_oldname();
CHARTYPE *get_prefix_command();
                                                             /* show.c */
void show_heading();
void show_footing();
void clear_footing();
void build_screen();
void display_screen();
void show_marked_block();
void redraw_window();
void repaint_screen();
void touch_screen();
void refresh_screen();
void redraw_screen();
bool line_in_view();
bool column_in_view();
LINETYPE find_next_current_line();
short get_row_for_focus_line();
LINETYPE get_focus_line_in_view();
LINETYPE calculate_focus_line();
void get_current_position();
void calculate_new_column();
short prepare_view();
short advance_view();
short THE_Resize();
                                                           /* scroll.c */
short scroll_page();
short scroll_line();
                                                              /* the.c */
void init_colour_pairs();
void display_info();
void cleanup();
                                                             /* util.c */
short memreveq();
short memrevne();
CHARTYPE *meminschr();
CHARTYPE *meminsmem();
CHARTYPE *memdelchr();
short strzne();
CHARTYPE *my_strdup();
short memne();
short strzrevne();
short strzreveq();
CHARTYPE *strtrunc();
CHARTYPE *MyStrip();
short memfind();
short memcmpi();
CHARTYPE *make_upper();
unsigned short equal();
short valid_integer();
short valid_positive_integer();
short strzeq();
CHARTYPE *strtrans();
LINE *add_line();
LINE *append_line();
LINE *delete_line();
void put_string();
void put_char();
short set_up_windows();
short draw_divider();
short create_statusline_window();
void pre_process_line();
short post_process_line();
bool blank_field();
void adjust_marked_lines();
void adjust_pending_prefix();
CHARTYPE case_translate();
void add_to_recovery_list();
void get_from_recovery_list();
void free_recovery_list();
short my_wmove();
short get_row_for_tof_eof();

#if THIS_APPEARS_TO_NOT_BE_USED
WINDOW *adjust_window();
#endif

void draw_cursor();
short my_wclrtoeol();
short my_wdelch();
short get_word();
                                                           /* linked.c */
void *ll_add();
void *ll_del();
void ll_free();
void *ll_find();
LINE *lll_add();
LINE *lll_del();
LINE *lll_free();
LINE *lll_find();
VIEW_DETAILS *vll_add();
VIEW_DETAILS *vll_del();
DEFINE *dll_add();
DEFINE *dll_del();
DEFINE *dll_free();
PPC *pll_add();
PPC *pll_del();
PPC *pll_free();
PPC *pll_find();
RESERVED *rll_add();
RESERVED *rll_del();
RESERVED *rll_free();
RESERVED *rll_find();
                                                             /* rexx.c */
short initialise_rexx();
short finalise_rexx();
short execute_macro_file();
short set_rexx_variable();
                                                            /* query.c */
short find_item();
short show_status();
short save_status();
short set_extract_variables();
short get_item_values();
                                                         /* directry.c */
short set_dirtype();
                                                          /* fnmatch.c */
int fnmatch();
                                                             /* sort.c */
short execute_sort();
                                                           /* cursor.c */
short cursor_cmdline();
short cursor_column();
short cursor_down();
short cursor_file();
short cursor_home();
short cursor_left();
short cursor_right();
short cursor_up();
short cursor_move();
long where_now();
long what_current_now();
long what_other_now();
long where_next();
long where_before();
bool enterable_field();
short go_to_new_field();
void get_cursor_position();
short advance_focus_line();
short advance_current_line();
                                                           /* colour.c */
short parse_colours();
chtype set_colour();
void set_up_default_colours();
CHARTYPE *get_colour_strings();
                                                           /* column.c */
short column_command();
                                                            /* mouse.c */
short THEMouse();
short get_mouse_info();
                                                            /* comm*.c */
short Add();
short All();
short Arbchar();
short Autosave();
short Backup();
short Backward();
short BeepSound();
short Bottom();
short Cappend();
short Cancel();
short Case();
short Ccancel();
short Cdelete();
short Cfirst();
short Change();
short Cinsert();
short Clast();
short Clearscreen();
short Clocate();
short Clock();
short Cmatch();
short Cmdarrows();
short Cmdline();
short Cmsg();
short Colour();
short Compat();
short Compress();
short THECommand();
short Control_char();
short Copy();
short Coverlay();
short Creplace();
short Curline();
short Cursor();
short CursorStay();
short Define();
short DeleteLine();
short Directory();
short Dirinclude();
short Display();
short Duplicate();
short Emsg();
short Enter();
short Eolout();
short Etmode();
short Expand();
short Extract();
short Ffile();
short File();
short Fillbox();
short Find();
short Findup();
short Forward();
short Get();
short Help();
short Hex();
short Hexdisplay();
short Hexshow();
short Hit();
short Idline();
short Impmacro();
short Impos();
short Input();
short Insertmode();
short Join();
short Left();
short Linend();
short Locate();
short Lowercase();
short Macro();
short Macroext();
short Macropath();
short Margins();
short Mark();
short Modify();
short THEMove();
short Msg();
short Msgline();
short Msgmode();
short Newlines();
short Next();
short Nextwindow();
short Nfind();
short Nfindup();
short Nomsg();
short Nondisp();
short Nop();
short Number();
short Overlaybox();
short Os();
short Osnowait();
short Osquiet();
short Osredir();
short Pending();
short Point();
short Position();
short Prefix();
short Preserve();
short Print();
short THEPrinter();
short Put();
short Putd();
short Qquit();
short Quit();
short Query();
short Readv();
short Recover();
short Reexecute();
short Redraw();
short THERefresh();
short Repeat();
short Replace();
short Reprofile();
short Reserved();
short Reset();
short Restore();
short Retrieve();
short Rexxoutput();
short Rgtleft();
short Right();
short Save();
short Scale();
short Scope();
short Select();
short Schange();
short THEScreen();
short Set();
short Shadow();
short Shift();
short ShowKey();
short Sort();
short Sos();
short Sos_addline();
short Sos_bottomedge();
short Sos_current();
short Sos_cursoradj();
short Sos_delback();
short Sos_delchar();
short Sos_delend();
short Sos_delline();
short Sos_delword();
short Sos_doprefix();
short Sos_edit();
short Sos_endchar();
short Sos_execute();
short Sos_firstchar();
short Sos_firstcol();
short Sos_lastcol();
short Sos_leftedge();
short Sos_makecurr();
short Sos_marginl();
short Sos_marginr();
short Sos_parindent();
short Sos_prefix();
short Sos_qcmnd();
short Sos_rightedge();
short Sos_startendchar();
short Sos_tabb();
short Sos_tabf();
short Sos_tabfieldb();
short Sos_tabfieldf();
short Sos_tabwordb();
short Sos_tabwordf();
short Sos_topedge();
short Sos_undo();
short Split();
short Spltjoin();
short Ssave();
short Status();
short Statusline();
short Stay();
short Suspend();
short Synonym();
short Tabkey();
short Tabline();
short Tabpre();
short Tabs();
short Tabsin();
short Tabsout();
short Text();
short Top();
short THETypeahead();
short Up();
short Uppercase();
short Verify();
short Wordwrap();
short Xedit();
short Xterminal();
short Zone();

#endif
