/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1980 Regents of the University of California.\n\
 All rights reserved.\n";
#endif not lint

#ifndef lint
static char sccsid[] = "@(#)mt.c        5.1 (Berkeley) 4/30/85";
#endif not lint

/*
 * mt --
 *   magnetic tape manipulation program
 *
 *   modified for use with DOS Archive QIC02 device driver by
 *   Eddy Olk, eddy@duteca.et.tudelft.nl
 *
 */
#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include "mtio.h"

#include <io.h>

#define equal(s1,s2)    (strcmp(s1, s2) == 0)

struct commands {
        char *c_name;
        int c_code;
        int c_ronly;
} com[] = {
        { "weof",       MTWEOF, 0 },
        { "eof",        MTWEOF, 0 },
        { "fsf",        MTFSF,  1 },
        { "bsf",        MTBSF,  1 },
        { "fsr",        MTFSR,  1 },
        { "bsr",        MTBSR,  1 },
        { "rewind",     MTREW,  1 },
        { "offline",    MTOFFL, 1 },
        { "rewoffl",    MTOFFL, 1 },
        { "status",     MTNOP,  1 },
        { "eod",        MTEOD,  1 },
        { "eom",        MTEOD,  1 },
        { "erase",      MTERASE,0},
        { "retension",  MTRETENSION,1},
        { "reset",      MTRESET, 1},
        { 0 }
};

int mtfd;
struct mtop mt_com;
struct mtget mt_status;
char *tape;
char *progname;

main(argc, argv)
        char **argv;
{
        char line[80], *getenv();
        register char *cp;
        register struct commands *comp;

        progname = argv[0];

        if (argc > 2 && (equal(argv[1], "-t") || equal(argv[1], "-f"))) {
                argc -= 2;
                tape = argv[2];
                argv += 2;
        } else
                if ((tape = getenv("TAPE")) == NULL)
                        tape = DEFTAPE;
        if (argc < 2) {
                fprintf(stderr, "usage: %s [ -f device ] command [ count ]\n",progname);
                exit(1);
        }
        cp = argv[1];
        for (comp = com; comp->c_name != NULL; comp++)
                if (strncmp(cp, comp->c_name, strlen(cp)) == 0)
                        break;
        if (comp->c_name == NULL) {
                fprintf(stderr, "%s: don't grok \"%s\"\n",progname, cp);
                exit(1);
        }
        if ((mtfd = open(tape, comp->c_ronly ? 0 : 2)) < 0) {
                perror(tape);
                exit(1);
        }
        if (comp->c_code != MTNOP) {
                mt_com.mt_op = comp->c_code;
                mt_com.mt_count = (argc > 2 ? atoi(argv[2]) : 1);
                if (mt_com.mt_count < 0) {
                        fprintf(stderr, "%s: negative repeat count\n",progname);
                        exit(1);
                }
                if (ioctl(mtfd, MTIOCTOP, &mt_com) < 0) {
                        fprintf(stderr, "%s %s %d ", tape, comp->c_name,
                                mt_com.mt_count);
                        perror("failed");
                        exit(2);
                }
        } else {
                if (ioctl(mtfd, MTIOCGET, (char *)&mt_status) < 0) {
                        perror("mt");
                        exit(2);
                }
                status(&mt_status);
        }
}


/*
 * Interpret the status buffer returned
 */

typedef struct {
  int mask;
  char *expln;
} info;

info err_byte0[] = {
  { MT_FIL, "File mark detected" },
  { MT_BNL, "Block not located" },
  { MT_UDE, "Unrecoverable data error" },
  { MT_EOM, "End of medium" },
  { MT_WRP, "Write protected cartridge" },
  { MT_DFF, "Device fault or SELF TEST failed" },
  { MT_CNI, "Cartridge not in place" }
};

info err_byte1[] = {
  { MT_POR, "Power on or RESET occurred" },
  { MT_EOD, "End of recorded data" },
  { MT_PAR, "Bus parity error" },
  { MT_BOM, "Beginning of medium" },
  { MT_MBD, "Marginal block detected" },
  { MT_NDT, "No data detected" },
  { MT_ILL, "Illegal command" }
};


status(bp)
        register struct mtget *bp;
{
  register int i, status;

  status = bp->mt_dsreg;
  switch (bp->mt_type) {
  case MT_ISAR:
    printf("Archive SC402/499R QIC02");
    break;
  default:
    printf("Unknown tape drive");
  }
  printf(", residual = %d\nsense (0x%04x):",
         bp->mt_resid, status);

  if (!(status&MT_ST0) && !(status&MT_ST1)) {
     printf("\n\tnothing special");
  }
  else {
    if (status&MT_ST1) {
       for (i=0; i<7; i++)
         if (status&err_byte1[i].mask)
           printf("\n\t%s", err_byte1[i].expln);
     }
     if (status&MT_ST0) {
       for (i=0; i<7; i++)
         if (status&err_byte0[i].mask)
           printf("\n\t%s", err_byte0[i].expln);
     }
  }
  printf("\nerrors = %u\nunderruns = %u\nfileno = %lu\nblockno = %lu\n",
         bp->mt_erreg, bp->mt_unrun, bp->mt_fileno, bp->mt_blkno);
}
