
PAGE ,132
TITLE PAU.COM - "Shipdisk" Utility

COMMENT {  PAU.COM is a program to move the fixed-disk head
to a safe "Landing-Zone" (cylinder 306 on a standard PC/XT disk).
Should be used before powering-down a system with a hard disk to
prevent damage from shock, vibration, etc.

NOTE:   Format for hard disk cylinders/sectors in register cx is:
|-------------- CH ----------------|----------------- CL ---------------|
|                |                 |                   |                |
| 15  14  13  12 |  11  10   9   8 |   7   6 |   5   4 |   3   2   1   0|
| c7  c6  c5  c4 |  c3  c2  c1  c0 |  c9  c8 |  s5  s4 |  s3  s2  s1  s0|
                                             |
|-----------------  CYLINDERS  --------------|-------- SECTORS ---------|
|    Max. number of cylinders = 1024         | Max. Sectors/Track = 64  |
{

;=-=-=-=-=-=-=-=-=-= MACROS -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
COMMENT	{	This macro will, by successive subtraction, convert the
binary number in AX into ASCII characters which will be output one at
a time, as translated.  A value of 20h in DH will cause leading zeros
to be suppressed, otherwise enter with a value of 30h.  Registers
AX and DX are destroyed.
{
CYL2ASC	MACRO	VALUE
	local	subtr, toofar, z_out
	xor	dl,dl		;;clear dl (counter).
subtr:	sub	ax, VALUE	
	jc	toofar		;;subtract went negative
	inc	dl		;;increment counter
	jmp	subtr		;;loop for successive subtr.
toofar:	add	ax,VALUE	;;restore ax.
	or	dl,dl		;;test if count is 0.
	jz	z_out
	mov	dh,30h		;;If non-zero, convert to numeric.
z_out:	add	dl,dh		;;Convert to ASCII.
	push	ax
	mov	ah,02h		;;DOS out_char function.
	int	21h
	pop	ax
ENDM
;==================================================================
CYL1ASC	MACRO		;;Use this MACRO instead of divide-by-one
	mov	dl,al
	add	dl,30h		;Always make this digit numeric.
	mov	ah,02h
	int	21h
	lea	dx,MESG5	;Add spaces (3) at end.
	mov	ah,9
	int	21h
ENDM
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
PAU	segment
	assume 	cs:PAU, ds:PAU
	org	100h
START:	jmp	START_CODE

;^^^^^^^^^^^^^^^^^^^^^^^^ DATA ^^^^^^^^^^^^^^^^^^^^^^^^^^^
BANNER	db	'PAU.COM -- Ver. 5.0 (J.Borza 4/89)',0Dh,0Ah
	db	'"Shipdisk" Utility for one or two hard disk drives'
CRLF	db	0Dh,0Ah,0Ah,'$'
MESG1	db	'No fixed-disks found!',0Dh,0Ah,'$'
MESG2	db	'Hard Disk parked.',0Dh,0Ah,'$'
MESG3	db	'Both Hard Disks parked.',0Dh,0Ah,'$'
MESG4	db	'Cylinder: $'
MESG5	db	'   $'		;Pad spaces (3)
;^^^^^^^^^^^^^^^^^^^^^^^ CODE ^^^^^^^^^^^^^^^^^^^
START_CODE:
	mov	dx, offset BANNER	;display banner
	mov	ah,9
	int 	21h
	mov	dx,80h		;1st hard disk.
	call	SEEK		;Try parking 1st disk.
	jc	NO_DSK		;Oops - no disk(s).
	mov	dx,81h		;2nd hard disk.
	call	SEEK		;Try parking 2nd disk.
	jc	ONE_DSK		;Oops - only one disk.
	lea	dx,MESG3	;Both Disks......
	jmp	PUTOUT
ONE_DSK:
	lea	dx,MESG2	;Fixed disk....
	jmp	PUTOUT
NO_DSK:
	lea	dx,MESG1	;No disks installed......
PUTOUT:
	mov	ah,9		;print the message
	int	21h
	mov	ax,4C00h	;Exit (ECODE=0)
	int	21h
;------------------------------------------------------------------
SEEK	proc	near
	push	dx		;Preserve dx thru BIOS call
	clc
	mov	ah,08h		;Get drive parms
	int	13h
	jnc	PARMS_GOT	;Continue if OK else,
	ret			;return with carry set.
PARMS_GOT:
	mov	ah,0Ch		;Seek to end.
	pop	dx		;Cleanup dx
	int	13h		;Seek!
	jnc	MOVIT		;If seek was good, go in one more cyl,
	ret			;else return with carry set.
MOVIT:	add	ch,1		;Next cylinder.
	jnc	INCADJ		;If register over-
	add	cl, 40h		;flowed, increase high bits.
INCADJ:	mov	ax, 0C00h	;Move (seek) to next cylinder.
	int	13h
OUTCYL:
	lea	dx, MESG4
	mov	ah,9
	int	21h
	mov	ax,cx		;Isolate cylinder #.
	mov	cx,6
	shr	al,cl
	xchg	ah,al
	mov	dh,20h
	CYL2ASC	1000d
	CYL2ASC	100d
	CYL2ASC	10d
	CYL1ASC
	clc
	ret
SEEK	endp
;==================================================================
PAU	ends
	END	START
