/*  mblock.c    -- display a Minix disk block */
/*  Copyright 1988,1991 Steven W. Harrold - All rights reserved. */
/*  $Header: MBLOCK.C_V 1.4 91/03/22 07:54:07 SWH Exp $ */

#include    <stdio.h>
#include    <stdlib.h>
#include    <ctype.h>
#include    <string.h>
#include    "mfs.h"
#include    "dev.h"

DEVINIT
PRINT_HEX_BUF
READ_BLOCK


/*==================================================================*/
main (argc, argv)
int     argc ;
char    *argv[] ;
{
    byte    buf[BLOCK_SIZE] ;
    int     blkno = 0 ;
    int     drive ;
    char    drid = 'A' ;
    char    *dp = DRIVES ;
    struct devdata *ddata ;

    printf ("**** Displays a block from a Minix file system ****\n") ;
    printf ("\n") ;

/*  Does he want help?
 */
    if ((argc >= 2) && (argv[1][0] == '-') && (argv[1][1] == '?'))
    {
printf ("Copyright 1988,1991 Steven W. Harrold - All rights reserved\n") ;
        printf ("Version %s\n", VERSION) ;
        printf ("Usage:   %s  [blkno] [drid]\n", argv[0]) ;
        printf ("'blkno' is number of block [0..32767]\n") ;
        printf ("'drid' is a letter from the set [a-z], default: 'a'\n") ;
        exit (0) ;
    }

/*  Fetch the block number
 */
    if (argc >= 2)
        blkno = atoi(argv[1]) ;

/*  Fetch the drive identifier
 */
    if (argc >= 3)
    {
        drid = toupper(argv[2][0]) ;
        if ((drid < 'A') || (drid > 'Z'))
            drid = 'A' ;
    }
    drive = strchr (dp, drid) - dp ;
    ddata = devinit (drive,0) ;
    if (!ddata)
    {
        printf ("Cannot initialize device 0x%02X, Dstatus=%d\n",
                drive, Dstatus) ;
        exit (2) ;
    }

/*  The desired block
 */
    read_block (buf, blkno, ddata) ;
    print_hex_buf (buf, blkno, "Contents of selected block") ;


} /* main() */


/*---eof---*/
