/*
 *  DRSP - DriveSpeed, version 3.10 (GPL FREEWARE)
 *  Copyleft (l) Stanislav Sokolov, May 1998 and onwards.
 *
 *  This program is subject to GNU General Public License ver. 2 of June 1991
 *  and any later version.
 *
 *  You may use this source with your programs, provided
 *  due credits are given.
 *
 *  Contact the author by e-mail: stanislavs@hotmail.com
 *
 *  Internet:  http://members.tripod.com/~stanislavs/prog/prog.htm
 */

#ifndef __DRSP_H
#define __DRSP_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <io.h>
#include <time.h>
#include <sys\stat.h>

#include <fcntl.h>

#include <conio.h>
#include <dos.h>
#include <bios.h>
#include <dir.h>
#include <signal.h>


//Hardware return codes
#define IGNORE  0
#define RETRY   1
#define ABORT   2

//Results table
#define L1         "#Test MBTurns  Write KB/Sec   Write MB/Min    Read KB/Sec    Read MB/Min "
#define L2         ""
#define DISK_STAT  "%c %#6.2f %3i %#16.9f%#14.9f%#16.9f%#14.9f\n"
#define L3         "Ŀ"
#define FAS_STAT   " %02d.%02d.%4d, %02d:%02d 	       FAS is %#9.3f operations per second         \n"
#define NO_FAS     " %02d.%02d.%4d, %02d:%02d        Read-only mode - FAS test was not performed       \n"
#define L4         ""
#define DBL_LINE   "\n\n"

#define FILE_NAME "A:\\DRSPTEST.TMP"

#define MAX_FBUF 17
#define MAX_PATH 81

//Exit values
#define EX_OK			0
#define EX_ABORT 		1
#define EX_NO_LOG		2
#define EX_OPEN_ERR		3
#define EX_WRITE_ERR	4
#define EX_CLOSE_ERR	5
#define EX_DEL_ERR		6
#define EX_OLD_DOS		7
#define EX_NO_MEM		8
#define EX_MATH_ERR		9
#define EX_BAD_DRV		10
#define EX_BAD_SIZE		11
#define EX_BAD_TURN		12


enum Bool {False, True};
enum Ro_mode {Off, Single, Multi};

extern int HError;
extern Bool fError;

//This struct and union are used to find segment:offset of a pointer
//(can also be used to find high and low int's of a long value)
typedef struct{
	int Low;
	int High;
} Long;

typedef union{
	long Whole;
	Long Part;
}FindLong;


typedef struct{
	char Path[256];
	unsigned long Size;
} TestFile;

//A collection of data used in drive testing and reporting
typedef struct{
	char 	      Drive;
	unsigned long Size;
	float         TestSize;
	unsigned int  Turns;
	Ro_mode       RO;
	Bool          Batch;
	char         *LogFile;
}TestData;

//Function prototypes
 //drsp.c
TestData ParseArg(int argc, char *argv[]);
char Ask(const char *Prompt);
void Abort(int Handle, const char *FName, const char *Msg, int status);
void Info(Bool Help);
void ClearCache(void);
void nfree(void *ptr);
void nexit(int status);

 //handlers.c
void interrupt Brk(void);
int FatalHandler(int errval, int ax, int bp, int si);
void Trap(int sType);

 //getsinfo.c
void ScanDrv(void);
char GetDrive(void);
unsigned long GetTestSize(TestData *TD);
unsigned int GetTurns(void);
Ro_mode SetRO(TestData TD);
char *SearchRO(TestData *TD, TestFile TF[]);
Bool DriveIsOK(char Drive);
char *FindPath(char *Path);
unsigned long ScanPath(unsigned long maxSize, const char *Path, char **RetPath, unsigned long biggest);
unsigned long ScanPath(unsigned long maxSize, const char *Path, TestFile TF[]);

 //diags.c
void DoTest(TestData TD, float *ReadSpd, float *WriteSpd); //RW
float DoTest(char *RetPath, TestData TD);                  //RO m-pass
float DoTest(TestFile TF[], unsigned long Size);           //RO s-pass
float TestFAS(char Drive);                                 //File Access Speed
float finddiff(struct time on, struct time off);

 //results.c
void Analyze(TestData TD, float WriteSpd, float ReadSpd, float FAS);
void Analyze(TestData TD, float ReadSpd);
FILE *OpenLog(TestData TD, char *FName);
//End of function prototypes

#endif





